/*
** skinedvscrollbar.c for  in /home/dev/NoSoucy-0.3
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Thu Aug  7 19:16:31 2003 Anto
** Last update Fri Dec 19 11:02:38 2003 Anto
*/

#include "skinedvscrollbar.h"
/* #include "gtksignal.h" */
#include "skin.h"

#define RANGE_CLASS(w)  GTK_RANGE_CLASS(GTK_OBJECT(w)->klass)

static void skined_vscrollbar_class_init(SkinedVScrollbarClass *);
static void skined_vscrollbar_init(SkinedVScrollbar *);
static void skined_vscrollbar_realize(GtkWidget *);
static void skined_vscrollbar_size_request(GtkWidget *, GtkRequisition *);
static void skined_vscrollbar_size_allocate(GtkWidget *, GtkAllocation *);
static void skined_vscrollbar_draw_trough(GtkRange *);
static void skined_vscrollbar_draw_slider(GtkRange *);
static void skined_vscrollbar_draw_step_forw(GtkRange *);
static void skined_vscrollbar_draw_step_back(GtkRange *);
static void skined_vscrollbar_slider_update(GtkRange *);
static void skined_vscrollbar_calc_slider_size(SkinedVScrollbar *);


GtkType			skined_vscrollbar_get_type(void)
{
  static GtkType	vscrollbar_type = 0;
  
  if (!vscrollbar_type)
    {
      static const GtkTypeInfo vscrollbar_info =
      {
        "SkinedVScrollbar",
        sizeof (SkinedVScrollbar),
        sizeof (SkinedVScrollbarClass),
        (GtkClassInitFunc) skined_vscrollbar_class_init,
        (GtkObjectInitFunc) skined_vscrollbar_init,
        /* reserved_1 */ NULL,
        /* reserved_2 */ NULL,
        (GtkClassInitFunc) NULL,
      };
      vscrollbar_type = gtk_type_unique(GTK_TYPE_VSCROLLBAR, &vscrollbar_info);
    }
  return (vscrollbar_type);
}

static void		skined_vscrollbar_class_init(SkinedVScrollbarClass *class)
{
  GtkObjectClass	*object_class;
  GtkWidgetClass	*widget_class;
  GtkRangeClass		*range_class;
  
  object_class = (GtkObjectClass*)class;
  widget_class = (GtkWidgetClass*)class;
  range_class = (GtkRangeClass*)class;

  widget_class->realize = skined_vscrollbar_realize;
  widget_class->size_request = skined_vscrollbar_size_request;
  widget_class->size_allocate = skined_vscrollbar_size_allocate;

  range_class->draw_trough = skined_vscrollbar_draw_trough;
  range_class->draw_slider = skined_vscrollbar_draw_slider;
  range_class->draw_step_forw = skined_vscrollbar_draw_step_forw;
  range_class->draw_step_back = skined_vscrollbar_draw_step_back;
  range_class->slider_update = skined_vscrollbar_slider_update;
  range_class->slider_width = 16;
  range_class->stepper_size = 16;
  range_class->stepper_slider_spacing = 0;
  range_class->min_slider_size = 6;
}

static void	skined_vscrollbar_init(SkinedVScrollbar *vscrollbar)
{
}

GtkWidget	*skined_vscrollbar_new()
{
  GtkWidget	*vscrollbar;
  
  vscrollbar = gtk_widget_new(SKINED_TYPE_VSCROLLBAR, NULL);
  gtk_range_set_adjustment(GTK_RANGE(vscrollbar), (GtkAdjustment*)gtk_object_new(GTK_TYPE_ADJUSTMENT, NULL));
  return (vscrollbar);
}

static void	skined_vscrollbar_realize(GtkWidget *widget)
{
  GtkRange	*range;
  GdkWindowAttr	attributes;
  gint		attributes_mask;
  gint		slider_width;
  gint		stepper_size;
  
  GTK_WIDGET_SET_FLAGS(widget, GTK_REALIZED);
  range = GTK_RANGE(widget);
  
  _gtk_range_get_props(range, &slider_width, NULL, &stepper_size, NULL);

  attributes.x = widget->allocation.x + (widget->allocation.width - widget->requisition.width) / 2;
  attributes.y = widget->allocation.y;
  attributes.width = widget->requisition.width;
  attributes.height = widget->allocation.height;
  attributes.wclass = GDK_INPUT_OUTPUT;
  attributes.window_type = GDK_WINDOW_CHILD;
  attributes.visual = gtk_widget_get_visual(widget);
  attributes.colormap = gtk_widget_get_colormap(widget);
  attributes.event_mask = gtk_widget_get_events(widget);
  attributes.event_mask |= (GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK |
			    GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK);
  
  attributes_mask = GDK_WA_X | GDK_WA_Y | GDK_WA_VISUAL | GDK_WA_COLORMAP;
  widget->window = gdk_window_new(gtk_widget_get_parent_window(widget), &attributes, attributes_mask);
  
  range->trough = widget->window;
  gdk_window_ref(range->trough);
  
  attributes.x = 0;
  attributes.y = 0;
  attributes.width = stepper_size;
  attributes.height = stepper_size;
  
  range->step_back = gdk_window_new(range->trough, &attributes, attributes_mask);
  
  attributes.y = (widget->allocation.height - stepper_size);
  
  range->step_forw = gdk_window_new(range->trough, &attributes, attributes_mask);
  
  attributes.x = 0;
  attributes.y = stepper_size;
  attributes.width = slider_width;
  attributes.height = (widget->allocation.height - stepper_size * 2);
  attributes.event_mask |= (GDK_BUTTON_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK);
  
  range->slider = gdk_window_new(range->trough, &attributes, attributes_mask);
  
  skined_vscrollbar_calc_slider_size(SKINED_VSCROLLBAR(widget));
  gtk_range_slider_update(GTK_RANGE(widget));
  
  widget->style = gtk_style_attach(widget->style, widget->window);
  
  gdk_window_set_user_data(range->trough, widget);
  gdk_window_set_user_data(range->slider, widget);
  gdk_window_set_user_data(range->step_forw, widget);
  gdk_window_set_user_data(range->step_back, widget);
    
  gdk_window_show(range->slider);
  gdk_window_show(range->step_forw);
  gdk_window_show(range->step_back);
}

static void	skined_vscrollbar_size_request(GtkWidget *widget, GtkRequisition *requisition)
{
  gint		slider_width;
  gint		stepper_size;
  gint		stepper_spacing;
  GtkRange	*range;

  range = GTK_RANGE(widget);

  _gtk_range_get_props(range, &slider_width, NULL, &stepper_size, &stepper_spacing);
  
  requisition->width = slider_width;
  requisition->height = (RANGE_CLASS(widget)->min_slider_size + stepper_size + stepper_spacing) * 2;
}

static void	skined_vscrollbar_size_allocate(GtkWidget *widget, GtkAllocation *allocation)
{
  GtkRange	*range;
  gint		stepper_size;
  
  widget->allocation = *allocation;
  if (GTK_WIDGET_REALIZED(widget))
    {
      range = GTK_RANGE(widget);

      _gtk_range_get_props(range, NULL, NULL, &stepper_size, NULL);
      
      gdk_window_move_resize(range->trough,
			     allocation->x + (allocation->width - widget->requisition.width) / 2,
			     allocation->y, widget->requisition.width, allocation->height);
      gdk_window_move_resize(range->step_back, 0, 0, widget->requisition.width, stepper_size);
      gdk_window_move_resize(range->step_forw, 0, allocation->height - stepper_size,
			     widget->requisition.width, stepper_size);
      gdk_window_resize(range->slider, widget->requisition.width, RANGE_CLASS(range)->min_slider_size);
      
      gtk_range_slider_update(GTK_RANGE(widget));
    }
}

static void	skined_vscrollbar_draw_step_forw(GtkRange *range)
{
  GdkGC		*gc;
  int		decal;
  
  if (GTK_WIDGET_DRAWABLE(range))
    {
      gc = gdk_gc_new(GTK_WIDGET(range)->window);

      decal = (range->in_child == RANGE_CLASS(range)->step_forw) ? 32 : 0;
      gdk_draw_pixmap(range->step_forw, gc, skin->icon[SKIN_SCROLLBAR].pixmap, decal, 66, 0, 0, 16, 16);
      
      gdk_gc_destroy(gc);
    }
}

static void	skined_vscrollbar_draw_step_back(GtkRange *range)
{
  GdkGC		*gc;
  int		decal;
  
  if (GTK_WIDGET_DRAWABLE(range))
    {
      gc = gdk_gc_new(GTK_WIDGET(range)->window);

      decal = (range->in_child == RANGE_CLASS(range)->step_back) ? 32 : 0;
      gdk_draw_pixmap(range->step_back, gc, skin->icon[SKIN_SCROLLBAR].pixmap, decal, 0, 0, 0, 16, 16);
      
      gdk_gc_destroy(gc);
    }
}

static void	skined_vscrollbar_draw_trough(GtkRange *range)
{
  GdkGC		*gc;
  GdkPixmap	*pixmap;
  int		decal;
  int		height;
  int		i;
  
  if (range->trough)
    {
      gdk_window_get_size(range->trough, NULL, &height);
      pixmap = gdk_pixmap_new(range->trough, 16, height, 
			      gdk_window_get_visual(range->trough)->depth);
      gc = gdk_gc_new(range->trough);
      
      decal = (range->in_child == RANGE_CLASS(range)->trough) ? 32 : 0;
      for (i = 0; i < height; i += 23)
	gdk_draw_pixmap(pixmap, gc, skin->icon[SKIN_SCROLLBAR].pixmap, decal, 41, 0, i, 16, 23);
      gdk_window_copy_area(range->trough, gc, 0, 0, pixmap, 0, 0, 16, height);
      
      gdk_gc_destroy(gc);
      gdk_pixmap_unref(pixmap);
    }
}

static void	skined_vscrollbar_draw_slider(GtkRange *range)
{
  GdkGC		*gc;
  GdkPixmap	*pixmap;
  int		decal;
  int		height;
  int		i;
  
  if (range->slider)
    {
      gdk_window_get_size(range->slider, NULL, &height);
      pixmap = gdk_pixmap_new(range->slider, 16, height, 
			      gdk_window_get_visual(range->slider)->depth);
      gc = gdk_gc_new(range->slider);
      
      decal = (range->in_child == RANGE_CLASS(range)->slider) ? 32 : 0;
      gdk_draw_pixmap(pixmap, gc, skin->icon[SKIN_SCROLLBAR].pixmap, decal, 17, 0, 0, 16, 6);
      for (i = 6; i < height - 2; i += 15)
	gdk_draw_pixmap(pixmap, gc, skin->icon[SKIN_SCROLLBAR].pixmap, decal, 23, 0, i, 16, 15);
      gdk_draw_pixmap(pixmap, gc, skin->icon[SKIN_SCROLLBAR].pixmap, decal, 39, 0, height - 2, 16, 2);
      gdk_window_copy_area(range->slider, gc, 0, 0, pixmap, 0, 0, 16, height);
      
      gdk_gc_destroy(gc);
      gdk_pixmap_unref(pixmap);
    }
}

static void	skined_vscrollbar_slider_update(GtkRange *range)
{
  gint		top;
  gint		bottom;
  gint		y;
  gint		trough_height;
  gint		slider_height;
  gint		stepper_size;

  skined_vscrollbar_calc_slider_size(SKINED_VSCROLLBAR(range));

  if (GTK_WIDGET_REALIZED(range))
    {
      _gtk_range_get_props(range, NULL, NULL, &stepper_size, NULL);

      gdk_window_get_size(range->trough, NULL, &trough_height);
      gdk_window_get_size(range->slider, NULL, &slider_height);
      top = stepper_size;
      bottom = trough_height - slider_height - stepper_size;
      y = top;

      if (range->adjustment->value < range->adjustment->lower)
	range->adjustment->value = range->adjustment->lower;
      else if (range->adjustment->value > range->adjustment->upper)
	range->adjustment->value = range->adjustment->upper;

      if (range->adjustment->lower != (range->adjustment->upper - range->adjustment->page_size))
	y += ((bottom - top) * (range->adjustment->value - range->adjustment->lower) /
	      (range->adjustment->upper - range->adjustment->lower - range->adjustment->page_size));

      if (y < top)
	y = top;
      else if (y > bottom)
	y = bottom;
      gdk_window_move(range->slider, 0, y);
    }
}

static void	skined_vscrollbar_calc_slider_size(SkinedVScrollbar *vscrollbar)
{
  GtkRange	*range;
  gint		step_back_y;
  gint		step_back_height;
  gint		step_forw_y;
  gint		stepper_spacing;
  gint		slider_width;
  gint		slider_height;
  gint		top, bottom;
  gint		height;
  
  if (GTK_WIDGET_REALIZED(vscrollbar))
    {
      range = GTK_RANGE(vscrollbar);
      
      _gtk_range_get_props(range, NULL, NULL, NULL, &stepper_spacing);
      
      gdk_window_get_size(range->step_back, NULL, &step_back_height);
      gdk_window_get_position(range->step_back, NULL, &step_back_y);
      gdk_window_get_position(range->step_forw, NULL, &step_forw_y);
      
      top = (step_back_y + step_back_height + stepper_spacing);
      bottom = step_forw_y - stepper_spacing;
      height = bottom - top;
      
      if ((range->adjustment->page_size > 0) &&
          (range->adjustment->lower != range->adjustment->upper))
        {
          if (range->adjustment->page_size > (range->adjustment->upper - range->adjustment->lower))
            range->adjustment->page_size = range->adjustment->upper - range->adjustment->lower;
          
          height = (height * range->adjustment->page_size /
                    (range->adjustment->upper - range->adjustment->lower));
          
          if (height < RANGE_CLASS(vscrollbar)->min_slider_size)
            height = RANGE_CLASS(vscrollbar)->min_slider_size;
        }
      gdk_window_get_size(range->slider, &slider_width, &slider_height);
      if (slider_height != height)
        gdk_window_resize(range->slider, slider_width, height);
    }
}
