/*
** confxml.h for  in /home/dev/xml
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Sat May 17 05:27:15 2003 Anto
** Last update Fri Dec 19 07:14:12 2003 Anto
*/

#ifndef	_CONF_H_
#define _CONF_H_

#include "list.h"

typedef struct	conf_s
{
  /* connection */
  char		*host;
  short		port;
  char		*login;
  char		*password;
  char		*location;
  char		*user_data;
  unsigned int	attempt;
  unsigned int	delay;

  /* automation */
  unsigned int	away_delay;
  char		default_message;
  unsigned char	auto_answer;
  list_t	*answer;
  char		big_mail_alert;

  /* aspect */
  int		aspect_width;
  int		aspect_height;
  int		aspect_x;
  int		aspect_y;
  int		save_geometry;
  char		*skin_file;

  /* ignore */
  list_t	*ignore;
  char		*ignore_answer;

  /* contacts */
  int		offline_group;
  int		group_count;
  int		auto_expand;
  list_t	*buddy;
  list_t	*group;

  /* message */
  int		message_width;
  int		message_height;
  int		message_x;
  int		message_y;
  int		message_save_geometry;
  int		expand_pict;
  int		history;
  char		*history_color;
  int		history_line;
  int		time_format;
  char		*login_color;
  char		*contact_color;
  char		*text_color;
}		conf_t;

extern conf_t	*conf;

#ifndef TRUE
#define TRUE	1
#endif

#ifndef FALSE
#define FALSE	0
#endif

#define	DEFAULT_HOST			"ns-server.epita.fr"
#define	DEFAULT_PORT			4242
#define	DEFAULT_LOGIN			"login_x"
#define	DEFAULT_PASSWORD		"password"
#define	DEFAULT_LOCATION		"home_r1p1"
#define	DEFAULT_USER_DATA		"NoSoucy is good"
#define	DEFAULT_ATTEMPT			5
#define DEFAULT_DELAY			20
#define DEFAULT_SAVE_GEOMETRY		FALSE
#define DEFAULT_ASPECT_WIDTH		175
#define DEFAULT_ASPECT_HEIGHT		400
#define DEFAULT_ASPECT_X		0
#define DEFAULT_ASPECT_Y		0
#define DEFAULT_SKIN_FILE		""
#define DEFAULT_AWAY_DELAY		10
#define DEFAULT_BIG_MAIL_ALERT		TRUE
#define DEFAULT_DEFAULT_ANSWER		-1
#define DEFAULT_BOOL_ANSWER		TRUE
#define DEFAULT_ANSWER			NULL
#define DEFAULT_IGNORE_ANSWER		""
#define DEFAULT_IGNORE_LOGIN		NULL
#define DEFAULT_OFFLINE_GROUP		TRUE
#define DEFAULT_GROUP_COUNT		TRUE
#define DEFAULT_AUTO_EXPAND		FALSE
#define DEFAULT_WITHOUT_GROUP		FALSE
#define DEFAULT_MESSAGE_WIDTH		370
#define DEFAULT_MESSAGE_HEIGHT		300
#define DEFAULT_MESSAGE_X		200
#define DEFAULT_MESSAGE_Y		0
#define DEFAULT_MESSAGE_SAVE_GEOMETRY	FALSE
#define DEFAULT_EXPAND_PICT		FALSE
#define DEFAULT_HISTORY			TRUE
#define DEFAULT_HISTORY_LINE		100
#define DEFAULT_HISTORY_COLOR		"#C3C3C3"
#define DEFAULT_TIME_FORMAT		0
#define DEFAULT_LOGIN_COLOR		"#FF0000"
#define DEFAULT_CONTACT_COLOR		"#0000FF"
#define DEFAULT_TEXT_COLOR		"#000000"

void	confSaveDoc(const char *);
conf_t	*confParseDoc(char *);
void	confFree(conf_t *, char);
void	confShow();

#endif /* _CONF_H_ */
