/*
** NoSoucy_callback.c for  in /home/dev/NoSoucy-0.3
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Mon May 19 08:37:36 2003 Anto
** Last update Sun Jan  4 22:05:49 2004 Anto
*/

#include "NoSoucy.h"
#include "list.h"
#include "netsoul.h"
#include "request.h"
#include "control_panel.h"
#include "skin.h"
#include "mail.h"
#include "env.h"
#include "message.h"
#include "contacts.h"
#include "conf.h"
#include "log.h"
#include "dialog.h"
#include <time.h>
#include <stdlib.h>

static void	on_log_destroy(GtkWidget *widget, gpointer user_data)
{
  log_t		**log;

  log = (log_t **)user_data;
  *log = NULL;
}

static void	put_menu(GtkMenu *menu, gint *x, gint *y, gpointer user_data)
{
  int		pos_x[2];
  int		pos_y[2];
  GtkRequisition requ[2];
  GtkWidget	*NoSoucyUI;
  GtkWidget	*evtState;

  NoSoucyUI = (GtkWidget *)user_data;
  evtState = gtk_object_get_data(GTK_OBJECT(NoSoucyUI), "evtState");
  gtk_widget_size_request(GTK_WIDGET(menu), &requ[0]);
  gtk_widget_size_request(evtState, &requ[1]);
  gdk_window_get_position(NoSoucyUI->window, &pos_x[0], &pos_y[0]);
  gdk_window_get_position(evtState->window, &pos_x[1], &pos_y[1]);
  *x = pos_x[0];
  *y = pos_y[0] + pos_y[1] - requ[0].height; 
  if (*y < 0)
    *y = pos_y[0] + pos_y[1] + requ[1].height + 4;
}

gboolean	on_evtState_button_press_event(GtkWidget *widget,
					       GdkEventButton *event,
					       gpointer user_data)
{
  GtkWidget	*menu;
  GtkWidget	*NoSoucyUI;

  NoSoucyUI = (GtkWidget *)user_data;
  menu = gtk_object_get_data(GTK_OBJECT(NoSoucyUI), "menu");
  gtk_object_set_data(GTK_OBJECT(menu), "widget_menued", NULL);
  if (event->button == 1)
    gtk_menu_popup(GTK_MENU(menu),
		   NULL, NULL, put_menu, NoSoucyUI,
		   event->button, event->time);  
  return FALSE;
}

gboolean	on_evtControlPanel_button_press_event(GtkWidget *widget,
						      GdkEventButton *event,
						      gpointer user_data)
{
  ControlPanel_UIShow();  
  return FALSE;
}

gboolean	on_evtMessage_button_press_event(GtkWidget *widget,
						 GdkEventButton *event,
						 gpointer user_data)
{
  char		*login;

  if (!(login = dialog_input("Send message to : ", SKIN_SEND_MESSAGE)))
    return FALSE;
  message_new(MESSAGE_TYPE_UNKNOWN, login, NULL, NULL);
  free(login);
  return FALSE;
}

gboolean	on_evtMail_button_press_event(GtkWidget *widget,
					      GdkEventButton *event,
					      gpointer user_data)
{
  GtkWidget	*xpmMail;
  GtkWidget	*NoSoucyUI;
  GtkTooltips	*tooltip;
  gint		timeout_id;

  NoSoucyUI = (GtkWidget *)user_data;
  xpmMail = gtk_object_get_data(GTK_OBJECT(NoSoucyUI), "xpmMail");
  tooltip = gtk_object_get_data(GTK_OBJECT(NoSoucyUI), "tooltips_mail");
  timeout_id = (gint)gtk_object_get_data(GTK_OBJECT(xpmMail), "timeout_id");
  gtk_tooltips_set_tip(tooltip, widget, "No new mail", NULL);
  if (timeout_id != -1)
    {
      gtk_pixmap_set(GTK_PIXMAP(xpmMail), 
		     skin->icon[SKIN_MAIL].pixmap,
		     skin->icon[SKIN_MAIL].mask);  
      gtk_timeout_remove(timeout_id);
      gtk_object_set_data(GTK_OBJECT(xpmMail), "timeout_id", (gpointer)-1);
      mail_delete_all();
    }
  return FALSE;
}

gboolean	on_evtLog_button_press_event(GtkWidget *widget,
					     GdkEventButton *event,
					     gpointer user_data)
{
  log_t		**log;
  list_t	*list;
  
  log = (log_t **)user_data;
  if (*log == NULL)
    {
      *log = log_new("NoSoucy - Debug window");
      log_destroy_event(*log, on_log_destroy, user_data);
    }
  for (list = netsoul->log; list; list = list->next)
    log_add(*log, list->data);
  log_show(*log);
  return FALSE;
}

void		on_NoSoucyUI_destroy_event(GtkWidget *widget,
					   gpointer user_data)
{
  confSaveDoc(env->conf);  
  gtk_exit(0);
}

gboolean	on_NoSoucyUI_delete_event(GtkWidget *widget,
					  GdkEvent *event,
					  gpointer user_data)
{
  NoSoucy_UISaveGeometry();
  return (FALSE);
}

gboolean	on_NoSoucy_menu_exit(GtkMenuItem *widget,
				     gpointer user_data)
{
  NoSoucy_UISaveGeometry();
  confSaveDoc(env->conf);  
  gtk_exit(0);
  return FALSE;
}

gboolean	on_NoSoucy_menu_connect(GtkMenuItem *widget,
					gpointer user_data)
{
  if (netsoul->type == NETSOUL_TYPE_DISC)
    {
      netsoulRestart(TRUE);
      netsoul->delay = 0;
    }
  return FALSE;
}

gboolean	on_NoSoucy_menu_disconnect(GtkMenuItem *widget,
					   gpointer user_data)
{
  int		now;

  now = time(NULL) + netsoul->time[TIME_DECAL];
  netsoulLog("[info] : You signed off on %.24s\n", ctime((time_t *)&now));
  netsoulRestart(NETSOUL_DISCONNECT);
  contacts_UIHideAll(conf->buddy);
  return FALSE;
}

gboolean	on_NoSoucy_menu_state(GtkMenuItem *widget,
				      gpointer user_data)
{
  request_state(user_data, time(NULL));
  NoSoucy_UISetState(user_data);
  return FALSE;
}

gboolean	on_NoSoucy_menu_answer(GtkMenuItem *widget,
				       gpointer user_data)
{
  conf->auto_answer = (int)user_data != -1;
  conf->default_message = (int)user_data;
  return FALSE;
}

void		NoSoucy_paint(GtkWidget *widget, GdkRectangle *area, gpointer user_data)
{
  GdkGC		*gc;
  int		i;
  int		width, height;
  GdkPixmap	*pixmap;

  gdk_window_get_size(widget->window, &width, &height);
  pixmap = gdk_pixmap_new(widget->window, width, height, 
			  gdk_window_get_visual(widget->window)->depth);

  gc = gdk_gc_new(pixmap);
  /* TOP LEFT */
  gdk_draw_pixmap(pixmap, gc, skin->icon[SKIN_NOSOUCY].pixmap, 0, 0, 0, 0, 6, 5);
  /* TOP */
  for (i = 0; i <= (width - 11) / 115; i++)
    gdk_draw_pixmap(pixmap, gc, skin->icon[SKIN_NOSOUCY].pixmap,
		    7, 0, (i * 115) + 6, 0, 115, 5);
  /* TOP RIGHT */
  gdk_draw_pixmap(pixmap, gc, skin->icon[SKIN_NOSOUCY].pixmap, 
		  123, 0, width - 5, 0, 5, 5);
  /* MIDDLE LEFT */
  for (i = 0; i <= (height - 35) / 34; i++)
    gdk_draw_pixmap(pixmap, gc, skin->icon[SKIN_NOSOUCY].pixmap,
		    0, 7, 0, (i * 34) + 5, 6, 35);
  /* BOTTOM LEFT */
  gdk_draw_pixmap(pixmap, gc, skin->icon[SKIN_NOSOUCY].pixmap, 
		  0, 42, 0, height - 30, 6, 30);
  /* BOTTOM */
  for (i = 0; i <= (width - 11) / 115; i++)
    gdk_draw_pixmap(pixmap, gc, skin->icon[SKIN_NOSOUCY].pixmap,
		    7, 42, (i * 115) + 6, height - 30, 115, 30);
  /* BOTTOM RIGHT */
  gdk_draw_pixmap(pixmap, gc, skin->icon[SKIN_NOSOUCY].pixmap,
		  123, 42, width - 5, height - 30, 5, 30);
  gdk_window_copy_area(widget->window, gc, 
		       area->x, area->y, pixmap, 
		       area->x, area->y, area->width, area->height);
  
  gdk_gc_destroy(gc);
  gdk_pixmap_unref(pixmap);
}

void	on_NoSoucy_event_draw(GtkWidget       *widget,
			      GdkRectangle    *area,
			      gpointer         user_data)
{
  GdkGC		*gc;

  gc = gdk_gc_new(widget->window);
  gdk_draw_pixmap(widget->window, gc, skin->icon[SKIN_NOSOUCY].pixmap,
		  7, 42, 0, -5, 115, 30);
  gdk_gc_destroy(gc);
  if (GTK_WIDGET_DRAWABLE(widget))
    gtk_widget_draw(GTK_BIN(widget)->child, area);
}

gboolean	on_NoSoucy_event_expose_event(GtkWidget       *widget,
					      GdkEventExpose  *event,
					      gpointer         user_data)
{
  on_NoSoucy_event_draw(widget, &event->area, NULL);
  return FALSE;
}
