/*
** contacts.c for  in /home/dev/xml
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Sun May 18 07:56:54 2003 Anto
** Last update Fri Dec 12 00:57:21 2003 Anto
*/

#include "contacts.h"
#include <stdlib.h>
#include <string.h>

group_t		*contactsNewGroup(char *name, int expand)
{
  group_t	*new;

  if (!name || !*name)
    return (NULL);
  new = calloc(1, sizeof(group_t));
  new->name = (name) ? strdup(name) : DEFAULT_GROUP_NAME;
  new->expand = expand;
  return (new);
}

buddy_t		*contactsNewBuddy(char *login, char *alias, int expand, int alerte)
{
  buddy_t	*new;
  int		i;
  
  if (!login || !*login)
    return (NULL);
  new = calloc(1, sizeof(buddy_t));
  new->login = (login) ? strdup(login) : DEFAULT_BUDDY_LOGIN;
  new->alias = (alias && *alias) ? strdup(alias) : DEFAULT_BUDDY_ALIAS;
  new->expand = expand;
  new->alerte = alerte;
  new->nb_log = 0;
  for (i = 0; i < MAX_LOG; i++)
    new->info[i].id = -1;
  return (new);
}

group_t		*contactsDupGroup(group_t *group)
{
  group_t	*dup;

  dup = calloc(1, sizeof(group_t));
  dup->name = (group->name) ? strdup(group->name) : DEFAULT_GROUP_NAME;
  dup->expand = group->expand;
  return (dup);
}

buddy_t		*contactsDupBuddy(buddy_t *buddy)
{
  buddy_t	*dup;
  int		i;

  dup = calloc(1, sizeof(buddy_t));
  dup->login = (buddy->login) ? strdup(buddy->login) : DEFAULT_BUDDY_LOGIN;
  dup->alias = (buddy->alias) ? strdup(buddy->alias) : DEFAULT_BUDDY_ALIAS;
  dup->expand = buddy->expand;
  dup->alerte = buddy->alerte;
  for (i = 0; i < MAX_LOG; i++)
    dup->info[i].id = -1;
  return (dup);
}

void	contactsUpdateGroup(group_t *group, char *name, int expand)
{
  if (group->name)
    free(group->name);
  group->name = strdup(name);
  group->expand = expand;
}

void	contactsUpdateBuddy(buddy_t *buddy, char *login, char *alias, int expand, int alerte)
{
  if (buddy->login)
    free(buddy->login);
  if (buddy->alias)
    free(buddy->alias);
  buddy->login = strdup(login);
  buddy->alias = (!alias || !*alias) ? DEFAULT_BUDDY_ALIAS : strdup(alias);  
  buddy->expand = expand;
  buddy->alerte = alerte;
}

void	contactsFreeGroup(group_t *group)
{
  if (group->name)
    free(group->name);
  free(group);
}

void	contactsFreeBuddy(buddy_t *buddy)
{
  if (buddy->login)
    free(buddy->login);
  if (buddy->alias)
    free(buddy->alias);
  free(buddy);
}

int	contactsFindBuddyId(buddy_t *buddy, int id)
{
  int	i;

  for (i = 0; i < MAX_LOG; i++)
    if (buddy->info[i].id == id)
      return (i);
  return (-1);
}

int	contactsCmpBuddy(buddy_t *buddy, char *login)
{
  return (strcmp(buddy->login, login));
}

int	contactsGetNewBuddyInfoId(buddy_t *buddy)
{
  int	i;

  for (i = 0; i < MAX_LOG; i++)
    {
      if (buddy->info[i].id == -1)
	{
	  if (buddy->group && buddy->nb_log == 0)
	    buddy->group->online_count++;
	  buddy->nb_log++;
	  return (i);
	}
    }
  return (-1);
}

void	contactsFreeBuddyInfo(buddy_t *buddy, int id)
{
  if (buddy->info[id].login)
    free(buddy->info[id].login);
  if (buddy->info[id].ip)
    free(buddy->info[id].ip);
  if (buddy->info[id].auth_user)
    free(buddy->info[id].auth_user);
  if (buddy->info[id].auth_ag)
    free(buddy->info[id].auth_ag);
  if (buddy->info[id].mach_func)
    free(buddy->info[id].mach_func);
  if (buddy->info[id].mach_loc)
    free(buddy->info[id].mach_loc);
  if (buddy->info[id].group)
    free(buddy->info[id].group);
  if (buddy->info[id].state)
    free(buddy->info[id].state);
  if (buddy->info[id].user_data)
    free(buddy->info[id].user_data);
  buddy->nb_log--;
  if (!buddy->nb_log && buddy->group)
    buddy->group->online_count--;
  buddy->info[id].id = -1;
  buddy->info[id].login = NULL;
  buddy->info[id].ip = NULL;
  buddy->info[id].auth_user = NULL;
  buddy->info[id].auth_ag = NULL;
  buddy->info[id].mach_func = NULL;
  buddy->info[id].mach_loc = NULL;
  buddy->info[id].group = NULL;
  buddy->info[id].state = NULL;
  buddy->info[id].user_data = NULL;
}

void	contactsUpdateBuddyInfo(buddy_t *buddy, int id, char **input, short mask)
{
  if (mask & BUDDY_MASK_ID)
    buddy->info[id].id = atoi(input[BUDDY_INFO_ID]);
  if (mask & BUDDY_MASK_LOGIN)
    {
      if (buddy->info[id].login)
	free(buddy->info[id].login);
      buddy->info[id].login = strdup(input[BUDDY_INFO_LOGIN]);
    }
  if (mask & BUDDY_MASK_IP)
    {
      if (buddy->info[id].ip)
	free(buddy->info[id].ip);
      buddy->info[id].ip = strdup(input[BUDDY_INFO_IP]);
    }
  if (mask & BUDDY_MASK_TIME_LOGIN)
    buddy->info[id].time_login = atoi(input[BUDDY_INFO_TIME_LOGIN]);
  if (mask & BUDDY_MASK_TIME_IDLE)
    buddy->info[id].time_idle = atoi(input[BUDDY_INFO_TIME_IDLE]);
  if (mask & BUDDY_MASK_AUTH_USER)
    {
      if (buddy->info[id].auth_user)
	free(buddy->info[id].auth_user);
      buddy->info[id].auth_user = strdup(input[BUDDY_INFO_AUTH_USER]);
    }
  if (mask & BUDDY_MASK_AUTH_AG)
    {
      if (buddy->info[id].auth_ag)
	free(buddy->info[id].auth_ag);
      buddy->info[id].auth_ag = strdup(input[BUDDY_INFO_AUTH_AG]);
    }
  if (mask & BUDDY_MASK_MACH_FUNC)
    {
      if (buddy->info[id].mach_func)
	free(buddy->info[id].mach_func);
      buddy->info[id].mach_func = strdup(input[BUDDY_INFO_MACH_FUNC]);
    }
  if (mask & BUDDY_MASK_MACH_LOC)
    {
      if (buddy->info[id].mach_loc)
	free(buddy->info[id].mach_loc);
      buddy->info[id].mach_loc = strdup(input[BUDDY_INFO_MACH_LOC]);
    }
  if (mask & BUDDY_MASK_GROUP)
    {
      if (buddy->info[id].group)
	free(buddy->info[id].group);
      buddy->info[id].group = strdup(input[BUDDY_INFO_GROUP]);
    }
  if (mask & BUDDY_MASK_STATE)
    {
      if (buddy->info[id].state)
	free(buddy->info[id].state);
      buddy->info[id].state = strdup(input[BUDDY_INFO_STATE]);
    }    
  if (mask & BUDDY_MASK_TIME_STATE)
    buddy->info[id].time_state = atoi(input[BUDDY_INFO_TIME_STATE]);
  if (mask & BUDDY_MASK_USER_DATA)
    {
      if (buddy->info[id].user_data)
	free(buddy->info[id].user_data);
      buddy->info[id].user_data = strdup(input[BUDDY_INFO_USER_DATA]);
    }
}

list_t		*contactsMakeBuddyList(list_t *buddylist)
{
  list_t	*list;
  
  for (list = NULL; buddylist; buddylist = buddylist->next)
    putinlist(&list, strdup(((buddy_t *)buddylist->data)->login));
  return (list);
}
