# Copyright 1999-2017 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2

EAPI=7

CMAKE_MIN_VERSION=3.5
EGIT_REPO_URI="https://github.com/neithernut/pam_e4crypt.git"
#EGIT_COMMIT="7ffea5e692e8cb90537a194889925af35a9b0fbd"

[[ ${PV} == 9999 ]] && SCM="git-r3" || SCM=""

inherit ${SCM} cmake-multilib pam

DESCRIPTION="A PAM module  for unlocking transparently encrypted directories on ext4"

HOMEPAGE="https://github.com/neithernut/pam_e4crypt"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~amd64"

IUSE="libressl"

COMMON_DEPEND="sys-libs/pam
	sys-apps/keyutils
	sys-apps/util-linux
	libressl? ( dev-libs/libressl:0= )
	!libressl? ( dev-libs/openssl:0= )"

DEPEND="${COMMON_DEPEND}"
RDEPEND="${COMMON_DEPEND}"

multilib_src_install() {
	pushd "${BUILD_DIR}" > /dev/null || die
	dopammod pam_e4crypt.so
	popd > /dev/null || die

	pushd "${S}" > /dev/null || die
	einstalldocs
	popd > /dev/null || die
}
