/*
** contacts_ui.c for  in /home/dev/NoSoucy
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Sun May 18 12:27:49 2003 Anto
** Last update Sun Jan  4 21:24:01 2004 Anto
*/

#include "contacts.h"
#include "netsoul.h"
#include "conf.h"
#include "skin.h"
#include "ns_tooltip.h"
#include "utils.h"
#include "menu.h"
#include "url.h"
#include "dialog.h"
#include "message.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

static GtkTooltips	*tooltips;
static GtkWidget	*Contacts;
static GtkWidget	*offline_item;
static void		setGroupCount(char[9], int, int);
static GtkWidget	*contacts_UICreateGroup(group_t *);
static GtkWidget	*contacts_UICreateBuddy(char *, char *, int);
static GList		*contacts_UIOfflineGroup(list_t *, GList *);
static GList		*contacts_UICreateBuddyTree(buddy_t *, GList *);

static menu_t	menu_add[] = 
  {
    {MENU_TYPE_BUTTON, ADD_MENU_ADD_GROUP, MENU_NO_ICON, on_menu_add_group, NULL, NULL},
    {MENU_TYPE_BUTTON, ADD_MENU_ADD_BUDDY, MENU_NO_ICON, on_menu_add_buddy, NULL, NULL},
    MENU_END_ITEM
  };

static menu_t	menu_contact_option_def[] = 
  {
    {MENU_TYPE_BUTTON, GROUP_MENU_ADD, SKIN_ADD, NULL, NULL, menu_add},
    {MENU_TYPE_SEPARATOR, "-", MENU_NO_ICON, NULL, NULL, NULL},
    {MENU_TYPE_CHECK, CONTACT_MENU_GROUP_COUNT, MENU_NO_ICON, on_menu_group_count, NULL, NULL},
    {MENU_TYPE_CHECK, CONTACT_MENU_OFFLINE_CONTACTS, MENU_NO_ICON, on_menu_offline_contacts, NULL, NULL},
    {MENU_TYPE_CHECK, CONTACT_MENU_AUTO_EXPAND, MENU_NO_ICON, on_menu_auto_expand, NULL, NULL},
    MENU_END_ITEM
  };

static menu_t	menu_group_def[] = 
  {
    {MENU_TYPE_BUTTON, GROUP_MENU_MASS_MESSAGE, SKIN_SEND_MESSAGE, on_menu_group_mass_message, NULL, NULL},
    {MENU_TYPE_SEPARATOR, "-", MENU_NO_ICON, NULL, NULL, NULL},
    {MENU_TYPE_BUTTON, GROUP_MENU_EDIT, SKIN_RENAME, on_Group_menu_rename, NULL, NULL},
    {MENU_TYPE_SEPARATOR, "-", MENU_NO_ICON, NULL, NULL, NULL},
    {MENU_TYPE_BUTTON, GROUP_MENU_REMOVE, SKIN_REMOVE, on_menu_remove_group, NULL, NULL},
    {MENU_TYPE_BUTTON, GROUP_MENU_ADD, SKIN_ADD, NULL, NULL, menu_add},
    {MENU_TYPE_SEPARATOR, "-", MENU_NO_ICON, NULL, NULL, NULL},
    {MENU_TYPE_BUTTON, GROUP_MENU_CONTACT_LIST_OPTION, MENU_NO_ICON, NULL, NULL, NULL},
    MENU_END_ITEM
  };

static menu_t	menu_buddy_def[] = 
  {
    {MENU_TYPE_BUTTON, BUDDY_MENU_MESSAGE, SKIN_SEND_MESSAGE, on_menu_buddy_message, NULL, NULL},
    {MENU_TYPE_BUTTON, BUDDY_MENU_SHOW_LOG, SKIN_SHOW_LOG, on_menu_buddy_show_log, NULL, NULL},
    {MENU_TYPE_SEPARATOR, "-", MENU_NO_ICON, NULL, NULL, NULL},
    {MENU_TYPE_BUTTON, BUDDY_MENU_EDIT, SKIN_RENAME, on_menu_buddy_rename, NULL, NULL},
    {MENU_TYPE_SEPARATOR, "-", MENU_NO_ICON, NULL, NULL, NULL},
    {MENU_TYPE_BUTTON, BUDDY_MENU_REMOVE, SKIN_REMOVE, on_menu_buddy_remove, NULL, NULL},
    {MENU_TYPE_BUTTON, BUDDY_MENU_ADD, SKIN_ADD, NULL, NULL, menu_add},
    {MENU_TYPE_SEPARATOR, "-", MENU_NO_ICON, NULL, NULL, NULL},
    {MENU_TYPE_BUTTON, BUDDY_MENU_ALERT, SKIN_ALERT, on_menu_buddy_alert, NULL, NULL},
    {MENU_TYPE_BUTTON, BUDDY_MENU_BLOCK, SKIN_BLOCK, on_menu_buddy_block, NULL, NULL},
    {MENU_TYPE_SEPARATOR, "-", MENU_NO_ICON, NULL, NULL, NULL},
    {MENU_TYPE_BUTTON, BUDDY_MENU_CONTACT_LIST_OPTION, MENU_NO_ICON, NULL, NULL, NULL},
    MENU_END_ITEM
  };

static GtkWidget	*menu_group = NULL;
static GtkWidget	*menu_buddy = NULL;
static GtkWidget	*menu_contact_option = NULL;

void		contacts_UI(GtkWidget *container)
{
  GtkWidget	*item;

  tooltips = gtk_tooltips_new();
  Contacts = gtk_list_new();
  gtk_object_set_data(GTK_OBJECT(container), "Contacts", Contacts);
  gtk_widget_show(Contacts);
  gtk_container_add(GTK_CONTAINER(container), Contacts);
  menu_group = menu_new(menu_group_def);
  menu_buddy = menu_new(menu_buddy_def);
  menu_contact_option = menu_new(menu_contact_option_def);
  item = gtk_object_get_data(GTK_OBJECT(menu_group), GROUP_MENU_CONTACT_LIST_OPTION);
  menu_set_submenu(menu_group, item, menu_contact_option);
  gtk_object_set_data(GTK_OBJECT(menu_contact_option), "gtk-menu-attach-data", NULL);
  item = gtk_object_get_data(GTK_OBJECT(menu_buddy), BUDDY_MENU_CONTACT_LIST_OPTION);
  menu_set_submenu(menu_buddy, item, menu_contact_option);
  gtk_object_set_data(GTK_OBJECT(menu_contact_option), "gtk-menu-attach-data", NULL);
  contacts_UISetMenuContactOption(FALSE);
  gtk_signal_connect(GTK_OBJECT(container), "button_press_event",
		     GTK_SIGNAL_FUNC(menu_show), (gpointer)menu_contact_option);
  ns_tooltip_new();
  gtk_widget_set_name(Contacts, "NoSoucyBackground");
}

GtkWidget	*contacts_UIGetMenuGroup()
{
  return (menu_group);
}

GtkWidget	*contacts_UIGetMenuBuddy()
{
  return (menu_buddy);
}

GtkWidget	*contacts_UIGetOfflineGroup()
{
  return (offline_item);
}

void		contacts_UISetMenuContactOption(int flag)
{
  GtkWidget	*item;
  int		state;

  item = gtk_object_get_data(GTK_OBJECT(menu_contact_option), CONTACT_MENU_GROUP_COUNT);
  state = (int)gtk_object_get_data(GTK_OBJECT(item), "state");
  if (state != conf->group_count)
    gtk_menu_item_activate(GTK_MENU_ITEM(item));
  item = gtk_object_get_data(GTK_OBJECT(menu_contact_option), CONTACT_MENU_OFFLINE_CONTACTS);
  state = (int)gtk_object_get_data(GTK_OBJECT(item), "state");
  if (state != conf->offline_group)
    gtk_menu_item_activate(GTK_MENU_ITEM(item));
  item = gtk_object_get_data(GTK_OBJECT(menu_contact_option), CONTACT_MENU_AUTO_EXPAND);
  state = (int)gtk_object_get_data(GTK_OBJECT(item), "state");
  if (state != conf->auto_expand)
    gtk_menu_item_activate(GTK_MENU_ITEM(item));
}

void		contacts_UIInsertBuddy(buddy_t *buddy)
{
  GList		*lst = NULL;
  GList		*child;
  int		index = 0;
  gpointer	type;
  GtkWidget	*item;

  lst = contacts_UICreateBuddyTree(buddy, lst);
  child = GTK_LIST(Contacts)->children;
  if (buddy->group)
    {
      index = g_list_index(child, buddy->group->item) + 1;
      child = g_list_nth(child, index);
    }
  while (child)
    {
      type = gtk_object_get_data(GTK_OBJECT((GtkWidget *)child->data), "type");
      if (type == TYPE_GROUP)
	break ;
      index++;
      child = g_list_next(child);
    }
  gtk_list_insert_items(GTK_LIST(Contacts), lst, index);
  /* offline */
  lst = NULL;
  item = contacts_UICreateBuddy(buddy->login, buddy->alias, 1);
  if (buddy->alerte)
    gtk_widget_show(gtk_object_get_data(GTK_OBJECT(item), "alert"));
  if (listFind(conf->ignore, buddy->login, strcmp))
    gtk_widget_show(gtk_object_get_data(GTK_OBJECT(item), "block"));
  if ((int)gtk_object_get_data(GTK_OBJECT(offline_item), "expanded") == FALSE ||
      !conf->offline_group)
    gtk_widget_hide(item);
  lst = g_list_append(lst, item);
  buddy->offline = item;
  gtk_list_append_items(GTK_LIST(Contacts), lst);
  /* group count */
  if (buddy->group)
    {
      char	cnt[9];
      GtkWidget *count;

      buddy->group->buddy_count++;
      setGroupCount(cnt, buddy->group->online_count, buddy->group->buddy_count);
      count = gtk_object_get_data(GTK_OBJECT(buddy->group->item), "count");
      gtk_label_set(GTK_LABEL(count), cnt);
    }
}

void		contacts_UIInsertGroup(group_t *group)
{
  GtkWidget	*item;
  GList		*lst = NULL;
  int		index;
  
  item = contacts_UICreateGroup(group);  
  index = g_list_index(GTK_LIST(Contacts)->children, offline_item) - 1;
  lst = g_list_append(lst, item);
  gtk_list_insert_items(GTK_LIST(Contacts), lst, index);
}

void		contacts_UIFillList(list_t *group, list_t *buddy)
{
  list_t	*tmp;
  GList		*lst = NULL;
  GtkWidget	*item;

  while (group)
    {
      if (group->data)
	{
	  item = contacts_UICreateGroup(group->data);
	  lst = g_list_append(lst, item);
	}
      for (tmp = buddy; tmp; tmp = tmp->next)
	if (((buddy_t *)tmp->data)->group == (group_t *)group->data)
	  lst = contacts_UICreateBuddyTree((buddy_t *)tmp->data, lst);
      group = group->next;
    }
  lst = contacts_UIOfflineGroup(buddy, lst);
  gtk_list_append_items(GTK_LIST(Contacts), lst);
}

void		contacts_UIEmptyList(list_t *buddy_list, list_t *group_list)
{
  int		i;
  buddy_t	*buddy;
  group_t	*group;

  while (buddy_list)
    {
      buddy = (buddy_t *)buddy_list->data;
      for (i = 0; i < MAX_LOG; i++)
	{
	  if (buddy->info[i].item)
	    gtk_widget_destroy(buddy->info[i].item);
	  buddy->info[i].item = NULL;
	  contactsFreeBuddyInfo(buddy, i);
	}
      if (buddy->group)
	buddy->group->online_count--;
      gtk_widget_destroy(buddy->item);
      gtk_widget_destroy(buddy->offline);
      buddy->item = NULL;
      buddy->offline = NULL;      
      buddy_list = buddy_list->next;
    }
  gtk_widget_destroy(offline_item);
  while (group_list)
    {
      if ((group = (group_t *)group_list->data))
	{
	  gtk_widget_destroy(group->item);
	  group->item = NULL;
	}
      group_list = group_list->next;
    }
}

static GtkWidget	*contacts_UICreateBuddy(char *login, char *alias, int level)
{
  GtkWidget		*item;
  GtkWidget		*hbox;
  GtkWidget		*label;
  GtkWidget		*pixmap;
  GtkWidget		*block;
  GtkWidget		*alert;
  GtkWidget		*decal;

  item = gtk_list_item_new();
  hbox = gtk_hbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(item), hbox);
  decal = gtk_label_new("");
  gtk_widget_set_usize(decal, level * 15, -2);
  gtk_object_set_data(GTK_OBJECT(item), "decal", decal);
  pixmap = gtk_pixmap_new(skin->icon[SKIN_OFFLINE].pixmap, skin->icon[SKIN_OFFLINE].mask);
  gtk_object_set_data(GTK_OBJECT(item), "pixmap", pixmap);
  alert = gtk_pixmap_new(skin->icon[SKIN_ALERT].pixmap, skin->icon[SKIN_ALERT].mask);
  gtk_object_set_data(GTK_OBJECT(item), "alert", alert);
  block = gtk_pixmap_new(skin->icon[SKIN_BLOCK].pixmap, skin->icon[SKIN_BLOCK].mask);
  gtk_object_set_data(GTK_OBJECT(item), "block", block);
  label = gtk_label_new(alias ? alias : login);
  gtk_misc_set_alignment(GTK_MISC(label), 0, .5);
  gtk_object_set_data(GTK_OBJECT(item), "label", label);
  gtk_box_pack_start(GTK_BOX(hbox), decal, FALSE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox), pixmap, FALSE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox), alert, FALSE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox), block, FALSE, TRUE, 0);
  gtk_widget_show_all(item);
  gtk_widget_hide(alert);
  gtk_widget_hide(block);
  gtk_signal_connect(GTK_OBJECT(item), "enter_notify_event",
		     GTK_SIGNAL_FUNC(on_item_enter_notify),
		     (gpointer)Contacts);
  /* skin */
  gtk_widget_set_name(item, "buddy");
  gtk_widget_set_name(label, SKIN_OFFLINE_TOKEN);
  return (item);
}

static GList	*contacts_UICreateBuddyTree(buddy_t *buddy, GList *lst)
{
  int		level;
  int		i;

  level = buddy->group ? 1 : 0;
  buddy->item = contacts_UICreateBuddy(buddy->login, buddy->alias, level);
  if (conf->offline_group)
    gtk_widget_hide(buddy->item);
  gtk_tooltips_set_tip(tooltips, buddy->item, "Never logged in", NULL);
  gtk_object_set_data(GTK_OBJECT(buddy->item), "buddy", buddy);
  gtk_object_set_data(GTK_OBJECT(buddy->item), "type", TYPE_BUDDY);
  lst = g_list_append(lst, buddy->item);
  for (i = 0; i < MAX_LOG; i++)
    {
      buddy->info[i].item = contacts_UICreateBuddy(buddy->login, buddy->alias, level + 1);
      gtk_widget_hide(buddy->info[i].item);
      gtk_object_set_data(GTK_OBJECT(buddy->info[i].item), "info", &(buddy->info[i]));
      gtk_object_set_data(GTK_OBJECT(buddy->info[i].item), "type", TYPE_BUDDY_INFO);
      buddy->expanded = TRUE;
      lst = g_list_append(lst, buddy->info[i].item);
      gtk_signal_connect(GTK_OBJECT(buddy->info[i].item), "button_press_event",
			 GTK_SIGNAL_FUNC(on_item_dblclick), (gpointer)buddy);
      gtk_signal_connect(GTK_OBJECT(buddy->info[i].item), "button_press_event",
			 GTK_SIGNAL_FUNC(menu_show), (gpointer)menu_buddy);
    }
  buddy->expanded = buddy->expand | conf->auto_expand;
  gtk_signal_connect(GTK_OBJECT(buddy->item), "button_press_event",
		     GTK_SIGNAL_FUNC(on_item_dblclick), (gpointer)buddy);
  gtk_signal_connect(GTK_OBJECT(buddy->item), "button_press_event",
		     GTK_SIGNAL_FUNC(on_item_contact_tree_button_press), (gpointer)buddy);
  gtk_signal_connect(GTK_OBJECT(buddy->item), "button_press_event",
		     GTK_SIGNAL_FUNC(menu_show), (gpointer)menu_buddy);
  ns_tooltip_add(buddy);
  /* skin */
  gtk_widget_set_name(gtk_object_get_data(GTK_OBJECT(buddy->item), "label"), SKIN_OFFLINE_TOKEN);
  if (buddy->alerte)
    gtk_widget_show(gtk_object_get_data(GTK_OBJECT(buddy->item), "alert"));
  if (listFind(conf->ignore, buddy->login, strcmp))
    gtk_widget_show(gtk_object_get_data(GTK_OBJECT(buddy->item), "block"));
  return (lst);
}

static GtkWidget	*contacts_UICreateGroup(group_t *group)
{
  GtkWidget		*hbox;
  GtkWidget		*label;
  GtkWidget		*count;
  char			buff[9];

  group->item = gtk_list_item_new();
  gtk_object_set_data(GTK_OBJECT(group->item), "type", TYPE_GROUP);
  gtk_object_set_data(GTK_OBJECT(group->item), "group", group);
  hbox = gtk_hbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(group->item), hbox);
  label = gtk_label_new(group->name);
  setGroupCount(buff, group->online_count, group->buddy_count);
  count = gtk_label_new(buff);
  gtk_object_set_data(GTK_OBJECT(group->item), "label", label);
  gtk_object_set_data(GTK_OBJECT(group->item), "count", count);
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox), count, FALSE, TRUE, 0);
  gtk_widget_show_all(group->item);
  if (conf->group_count == FALSE)
    gtk_widget_hide(count);
  group->expanded = group->expand | conf->auto_expand;
  gtk_signal_connect(GTK_OBJECT(group->item), "enter_notify_event",
		     GTK_SIGNAL_FUNC(on_item_enter_notify),
		     (gpointer)Contacts);
  gtk_signal_connect(GTK_OBJECT(group->item), "button_press_event",
		     GTK_SIGNAL_FUNC(on_group_tree_button_press), (gpointer)group);
  gtk_signal_connect(GTK_OBJECT(group->item), "button_press_event",
		     GTK_SIGNAL_FUNC(menu_show), (gpointer)menu_group);
  /* skin */
  gtk_widget_set_name(label, SKIN_GROUP_TOKEN);
  gtk_widget_set_name(count, SKIN_GROUP_TOKEN);
  gtk_widget_set_name(group->item, "group");
  return (group->item);
}

static GList	*contacts_UIOfflineGroup(list_t *buddy, GList *lst)
{
  GtkWidget	*item;

  offline_item = gtk_list_item_new_with_label(OFFLINE_CONTACTS);
  gtk_object_set_data(GTK_OBJECT(offline_item), "type", TYPE_GROUP);
  gtk_object_set_data(GTK_OBJECT(Contacts), OFFLINE_CONTACTS, offline_item);
  gtk_object_set_data(GTK_OBJECT(offline_item), "expanded", (gpointer)0);
  lst = g_list_append(lst, offline_item);
  if (conf->offline_group)
    gtk_widget_show_all(offline_item);
  gtk_signal_connect(GTK_OBJECT(offline_item), "enter_notify_event",
		     GTK_SIGNAL_FUNC(on_item_enter_notify),
		     (gpointer)Contacts);
  gtk_signal_connect(GTK_OBJECT(offline_item), "button_press_event",
		     GTK_SIGNAL_FUNC(on_offline_tree_button_press), (gpointer)NULL);
  /* skin */
  gtk_widget_set_name(offline_item, "group");
  gtk_widget_set_name(GTK_LIST_ITEM(offline_item)->item.bin.child, SKIN_GROUP_TOKEN);
  /* fill group */
  while (buddy)
    {
      item = contacts_UICreateBuddy(((buddy_t *)buddy->data)->login, ((buddy_t *)buddy->data)->alias, 1);
      gtk_tooltips_set_tip(tooltips, item, "Never logged in", NULL);
      gtk_object_set_data(GTK_OBJECT(item), "buddy", buddy->data);
      gtk_object_set_data(GTK_OBJECT(item), "type", TYPE_BUDDY);

      gtk_signal_connect(GTK_OBJECT(item), "button_press_event",
			 GTK_SIGNAL_FUNC(menu_show), (gpointer)menu_buddy);
      if (((buddy_t *)buddy->data)->alerte)
	gtk_widget_show(gtk_object_get_data(GTK_OBJECT(item), "alert"));
      if (listFind(conf->ignore, ((buddy_t *)buddy->data)->login, strcmp))
	gtk_widget_show(gtk_object_get_data(GTK_OBJECT(item), "block"));
      gtk_widget_hide(item);
      lst = g_list_append(lst, item);
      ((buddy_t *)buddy->data)->offline = item;
      buddy = buddy->next;
    }
  return (lst);
}

void		contacts_UIShowBuddy(buddy_t *buddy, int id)
{
  GtkWidget	*pixmap;
  GtkWidget	*label;
  int		skin_id;
  int		i;
  char		*location;
  
  gtk_tooltips_set_tip(tooltips, buddy->item, NULL, NULL);
  if (buddy->nb_log)
    gtk_widget_hide(buddy->offline);
  if (buddy->nb_log == 1 && buddy->group)
    {
      char	cnt[9];
      GtkWidget *count;

      setGroupCount(cnt, buddy->group->online_count, buddy->group->buddy_count);
      count = gtk_object_get_data(GTK_OBJECT(buddy->group->item), "count");
      gtk_label_set(GTK_LABEL(count), cnt);
    }
  pixmap = gtk_object_get_data(GTK_OBJECT(buddy->info[id].item), "pixmap");
  label = gtk_object_get_data(GTK_OBJECT(buddy->info[id].item), "label");
  /* skin */
  skin_id = skinStateToId(buddy->info[id].state);
  gtk_pixmap_set(GTK_PIXMAP(pixmap),
		 skin->icon[skin_id].pixmap,
		 skin->icon[skin_id].mask);
  gtk_widget_set_name(label, skin->state[skin_id].name);
  /* main buddy item */
  pixmap = gtk_object_get_data(GTK_OBJECT(buddy->item), "pixmap");
  label = gtk_object_get_data(GTK_OBJECT(buddy->item), "label");
  if (buddy->nb_log == 1)
    skin_id = skinStateToId(buddy->info[id].state);
  else
    skin_id = SKIN_MULTI;
  gtk_pixmap_set(GTK_PIXMAP(pixmap),
		 skin->icon[skin_id].pixmap,
		 skin->icon[skin_id].mask);
  gtk_widget_set_name(label, skin->state[skin_id].name);

  if (!buddy->group || buddy->group->expanded)
    {
      if (GTK_WIDGET_VISIBLE(buddy->item) == FALSE)
	gtk_widget_show(buddy->item);
      if (buddy->expanded && buddy->nb_log > 1)
	for (i = 0; i < MAX_LOG; i++)
	  if (buddy->info[i].id > 0 && GTK_WIDGET_VISIBLE(buddy->info[i].item) == FALSE)
	    gtk_widget_show(buddy->info[i].item);
    }
  label = gtk_object_get_data(GTK_OBJECT(buddy->info[id].item), "label");
  location = strdup(buddy->info[id].mach_loc);
  gtk_label_set_text(GTK_LABEL(label), url_decode(location));
  free(location);
}

void		contacts_UIHideBuddy(buddy_t *buddy, int id)
{
  GtkWidget	*pixmap;
  GtkWidget	*label;
  int		skin_id;

  if (!buddy->nb_log && buddy->group)
    {
      char	cnt[9];
      GtkWidget *count;

      setGroupCount(cnt, buddy->group->online_count, buddy->group->buddy_count);
      count = gtk_object_get_data(GTK_OBJECT(buddy->group->item), "count");
      gtk_label_set(GTK_LABEL(count), cnt);
    }
  pixmap = gtk_object_get_data(GTK_OBJECT(buddy->info[id].item), "pixmap");
  label = gtk_object_get_data(GTK_OBJECT(buddy->info[id].item), "label");
  /* skin */
  gtk_pixmap_set(GTK_PIXMAP(pixmap),
		 skin->icon[SKIN_OFFLINE].pixmap,
		 skin->icon[SKIN_OFFLINE].mask);
  gtk_widget_set_name(label, SKIN_OFFLINE_TOKEN);
  /* main buddy item */
  pixmap = gtk_object_get_data(GTK_OBJECT(buddy->item), "pixmap");
  label = gtk_object_get_data(GTK_OBJECT(buddy->item), "label");
  if (buddy->nb_log == 1)
    {
      int i;

      for (i = 0; i < MAX_LOG; i++)
	if (buddy->info[i].id > 0 && buddy->info[i].state)
	  {
	    gtk_widget_hide(buddy->info[i].item);
	    skin_id = skinStateToId(buddy->info[i].state);
	    break ;
	  }
    }
  else if (!buddy->nb_log)
    skin_id = SKIN_OFFLINE;
  else
    skin_id = SKIN_MULTI;
  gtk_pixmap_set(GTK_PIXMAP(pixmap),
		 skin->icon[skin_id].pixmap,
		 skin->icon[skin_id].mask);
  gtk_widget_set_name(label, skin->state[skin_id].name);

  if (!buddy->nb_log)
    {
      char *tooltext;
      int  now;

      now = time(NULL) + netsoul->time[TIME_DECAL];
      asprintf(&tooltext, "Last seen on : %.24s", ctime((time_t *)&now));
      gtk_tooltips_set_tip(tooltips, buddy->item, tooltext, NULL);
      gtk_tooltips_set_tip(tooltips, buddy->offline, tooltext, NULL);
      free(tooltext);
      if ((int)gtk_object_get_data(GTK_OBJECT(offline_item), "expanded") == 1)
	gtk_widget_show(buddy->offline);
      if (conf->offline_group)
	gtk_widget_hide(buddy->item);
    }
  gtk_widget_hide(buddy->info[id].item);
}

void		contacts_UIHideAll(list_t *buddy_list)
{
  buddy_t	*buddy;
  int		id;

  while (buddy_list)
    {
      buddy = (buddy_t *)buddy_list->data;
      for (id = 0; id < MAX_LOG; id++)
	if (buddy->info[id].id != -1)
	  {
	    contactsFreeBuddyInfo(buddy, id);
	    contacts_UIHideBuddy(buddy, id);
	  }
      buddy_list = buddy_list->next;
    }
}

void	contacts_UIRemoveBuddy(buddy_t *buddy)
{
  int	i;
  
  for (i = 0; i < MAX_LOG; i++)
    {
      if (buddy->info[i].item)
	gtk_widget_destroy(buddy->info[i].item);
      contactsFreeBuddyInfo(buddy, i);
    }
  if (buddy->group)
    {
      char	cnt[9];
      GtkWidget	*count;

      if (buddy->nb_log > 0)
	buddy->group->online_count--;
      buddy->group->buddy_count--;
      setGroupCount(cnt, buddy->group->online_count, buddy->group->buddy_count);
      count = gtk_object_get_data(GTK_OBJECT(buddy->group->item), "count");
      gtk_label_set(GTK_LABEL(count), cnt);
    }
  gtk_widget_destroy(buddy->item);
  gtk_widget_destroy(buddy->offline);
}

void		contacts_UIAlert(buddy_t *buddy, int info_id)
{
  char		*str = NULL;
  message_t	*message;
  
  buddy->alerte = FALSE;
  asprintf(&str, "%s just signed on. Send him/her an Instant Message ?", 
	   buddy->alias ? buddy->alias : buddy->login);
  if (dialog_confirm(str, SKIN_ALERT))
    {
      if (!(message = message_find_by_id(buddy->info[info_id].id)) &&
	  !(message = message_find(buddy->login)))
	message = message_new(MESSAGE_TYPE_STD, buddy->login, buddy->alias, 
			      info_id != -1 ? &buddy->info[info_id] : NULL);
      gtk_widget_show(message->window);
    }
  free(str);
  buddy->alerte = TRUE;
}

void		contacts_UIBlock(buddy_t *buddy)
{
  GtkWidget	*block;
  GtkWidget	*block_offline;
  list_t	*login;
  
  block = gtk_object_get_data(GTK_OBJECT(buddy->item), "block");
  block_offline = gtk_object_get_data(GTK_OBJECT(buddy->offline), "block");
  if (!(login = listFind(conf->ignore, buddy->login, strcmp)))
    {
      gtk_widget_show(block);
      gtk_widget_show(block_offline);
      putinlist(&conf->ignore, strdup(buddy->login));
    }
  else
    {
      gtk_widget_hide(block);
      gtk_widget_hide(block_offline);
      listRemoveItem(&conf->ignore, login->data, free);
    }
}

static void	setGroupCount(char str[9], int online, int total)
{
  sprintf(str, " (%d/%d)", online % 100, total % 100);
}
