/*
** control_panel_ui.c for  in /home/dev/xml
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Sat May 17 20:45:21 2003 Anto
** Last update Tue Dec  7 19:06:58 2004 Anto
*/

#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include "control_panel.h"
#include "conf.h"

static void		control_panel_create();
static GtkWidget	*create_Add_Contact();
static GtkWidget	*create_Add_Group();

GtkWidget		*Control_Panel = NULL;
GtkWidget		*Add_Contact = NULL;
GtkWidget		*Add_Group = NULL;
int			quit_modal = FALSE;

void	ControlPanel_UI()
{
/*   control_panel_create(); */
  create_Add_Contact();
  create_Add_Group();
}

void	ControlPanel_UIShow()
{
  if (Control_Panel == NULL || !GTK_IS_WIDGET(Control_Panel))
    {
      control_panel_create();
      ControlPanel_loadConf(conf);
    }
  gtk_widget_show_all(Control_Panel);
}

void	ControlPanel_UIHide()
{
  gtk_widget_hide_all(Control_Panel);
}

int		ControlPanel_UIEditGroup(group_t *group)
{
  GtkWidget	*entry;
  GtkWidget	*check;

  entry = gtk_object_get_data(GTK_OBJECT(Add_Group), "entry_group_name");
  check = gtk_object_get_data(GTK_OBJECT(Add_Group), "checkbutton_auto_expand");
  gtk_entry_set_text(GTK_ENTRY(entry), group->name);
  gtk_toggle_button_set_active(&(GTK_CHECK_BUTTON(check)->toggle_button), group->expand);
  gtk_widget_grab_focus(entry);
  quit_modal = FALSE;
  gtk_widget_show(Add_Group);
  while (!quit_modal)
    if (gtk_events_pending())
      gtk_main_iteration();
  if (Add_Group == NULL)
    create_Add_Group();
  gtk_widget_hide(Add_Group);
  if (quit_modal == BUTTON_CANCEL)
    return (FALSE);
  contactsUpdateGroup(group, 
		      gtk_entry_get_text(GTK_ENTRY(entry)),
		      gtk_toggle_button_get_active(&(GTK_CHECK_BUTTON(check)->toggle_button)));
  return (TRUE);
}

int		ControlPanel_UIEditBuddy(buddy_t *buddy)
{
  GtkWidget	*login;
  GtkWidget	*alias;
  GtkWidget	*expand;
  GtkWidget	*alert;

  login = gtk_object_get_data(GTK_OBJECT(Add_Contact), "entry_login");
  alias = gtk_object_get_data(GTK_OBJECT(Add_Contact), "entry_alias");
  expand = gtk_object_get_data(GTK_OBJECT(Add_Contact), "checkbutton_auto_expand");
  alert = gtk_object_get_data(GTK_OBJECT(Add_Contact), "checkbutton_alert_log_on");
  gtk_entry_set_text(GTK_ENTRY(login), buddy->login);
  gtk_entry_set_text(GTK_ENTRY(alias), buddy->alias ? buddy->alias : "");
  gtk_toggle_button_set_active(&(GTK_CHECK_BUTTON(expand)->toggle_button), buddy->expand);
  gtk_toggle_button_set_active(&(GTK_CHECK_BUTTON(alert)->toggle_button), buddy->alerte);
  gtk_widget_grab_focus(login);
  quit_modal = FALSE;
  gtk_widget_show(Add_Contact);
  while (!quit_modal)
    if (gtk_events_pending())
      gtk_main_iteration();
  if (Add_Contact == NULL)
    create_Add_Contact();
  gtk_widget_hide(Add_Contact);
  if (quit_modal == BUTTON_CANCEL)
    return (FALSE);
  contactsUpdateBuddy(buddy,
		      gtk_entry_get_text(GTK_ENTRY(login)),
		      gtk_entry_get_text(GTK_ENTRY(alias)),
		      gtk_toggle_button_get_active(&(GTK_CHECK_BUTTON(expand)->toggle_button)),
		      gtk_toggle_button_get_active(&(GTK_CHECK_BUTTON(alert)->toggle_button)));
  return (TRUE);
}

group_t		*ControlPanel_UINewGroup()
{
  GtkWidget	*entry;
  GtkWidget	*check;

  entry = gtk_object_get_data(GTK_OBJECT(Add_Group), "entry_group_name");
  check = gtk_object_get_data(GTK_OBJECT(Add_Group), "checkbutton_auto_expand");
  gtk_entry_set_text(GTK_ENTRY(entry), "");
  gtk_toggle_button_set_active(&(GTK_CHECK_BUTTON(check)->toggle_button), DEFAULT_GROUP_EXPAND);
  gtk_widget_grab_focus(entry);
  quit_modal = FALSE;
  gtk_widget_show(Add_Group);
  while (!quit_modal)
    if (gtk_events_pending())
      gtk_main_iteration();
  if (Add_Group == NULL)
    create_Add_Group();
  gtk_widget_hide(Add_Group);
  if (quit_modal == BUTTON_CANCEL)
    return (NULL);
  return (contactsNewGroup(gtk_entry_get_text(GTK_ENTRY(entry)),
			   gtk_toggle_button_get_active(&(GTK_CHECK_BUTTON(check)->toggle_button))));
}

buddy_t		*ControlPanel_UINewBuddy()
{
  GtkWidget	*login;
  GtkWidget	*alias;
  GtkWidget	*expand;
  GtkWidget	*alert;

  login = gtk_object_get_data(GTK_OBJECT(Add_Contact), "entry_login");
  alias = gtk_object_get_data(GTK_OBJECT(Add_Contact), "entry_alias");
  expand = gtk_object_get_data(GTK_OBJECT(Add_Contact), "checkbutton_auto_expand");
  alert = gtk_object_get_data(GTK_OBJECT(Add_Contact), "checkbutton_alert_log_on");
  gtk_entry_set_text(GTK_ENTRY(login), "");
  gtk_entry_set_text(GTK_ENTRY(alias), "");
  gtk_toggle_button_set_active(&(GTK_CHECK_BUTTON(expand)->toggle_button), DEFAULT_BUDDY_EXPAND);
  gtk_toggle_button_set_active(&(GTK_CHECK_BUTTON(alert)->toggle_button), DEFAULT_BUDDY_ALERTE);
  gtk_widget_grab_focus(login);
  quit_modal = FALSE;
  gtk_widget_show(Add_Contact);
  while (!quit_modal)
    if (gtk_events_pending())
      gtk_main_iteration();
  if (Add_Contact == NULL)
    create_Add_Contact();
  gtk_widget_hide(Add_Contact);
  if (quit_modal == BUTTON_CANCEL)
    return (NULL);
  return (contactsNewBuddy(gtk_entry_get_text(GTK_ENTRY(login)),
			   gtk_entry_get_text(GTK_ENTRY(alias)),
			   gtk_toggle_button_get_active(&(GTK_CHECK_BUTTON(expand)->toggle_button)),
			   gtk_toggle_button_get_active(&(GTK_CHECK_BUTTON(alert)->toggle_button))));
}

static void	control_panel_create()
{
  GtkWidget *vbox1;
  GtkWidget *notebook1;
  GtkWidget *vbox7;
  GtkWidget *frame_server;
  GtkWidget *table_server;
  GtkWidget *label_host;
  GtkWidget *label_port;
  GtkWidget *label_location;
  GtkWidget *label_user_data;
  GtkWidget *entry_port;
  GtkWidget *entry_location;
  GtkWidget *entry_user_data;
  GtkWidget *entry_host;
  GtkWidget *hbox7;
  GtkWidget *frame3;
  GtkWidget *table9;
  GtkWidget *label4;
  GtkWidget *label5;
  GtkWidget *entry_login;
  GtkWidget *entry_password;
  GtkWidget *frame_connection_option;
  GtkWidget *table_connection_option;
  GtkWidget *entry_attempt;
  GtkWidget *entry_delay;
  GtkWidget *label_attempt;
  GtkWidget *label_delay;
  GtkWidget *label_page_1;
  GtkWidget *vbox_automation;
  GtkWidget *frame_state;
  GtkWidget *table_state;
  GtkWidget *label_auto_away_delay;
  GtkWidget *entry_auto_away_delay;
  GtkWidget *frame_away_message;
  GtkWidget *table_away_message;
  GtkWidget *checkbutton_auto_answer;
  GtkWidget *entry_auto_answer;
  GtkWidget *button_remove_auto_answer;
  GtkWidget *button_add_auto_answer;
  GtkWidget *scrolledwindow_auto_answer;
  GtkWidget *viewport_auto_answer;
  GtkWidget *list_auto_answer;
  GtkWidget *label_page_2;
  GtkWidget *vbox_aspect;
  GtkWidget *frame_aspect_geometry;
  GtkWidget *table_aspect_geometry;
  GtkWidget *label_aspect_width;
  GtkWidget *label_aspect_height;
  GtkWidget *label_aspect_x;
  GtkWidget *label_aspect_y;
  GtkWidget *checkbutton_save_geometry;
  GtkWidget *entry_aspect_width;
  GtkWidget *entry_aspect_height;
  GtkWidget *entry_aspect_x;
  GtkWidget *entry_aspect_y;
  GtkWidget *frame_skin;
  GtkWidget *table_skin;
  GtkWidget *label_skin_file;
  GtkWidget *entry_skin_file;
  GtkWidget *label_page_3;
  GtkWidget *hbox_contacts;
  GtkWidget *frame_contact_list;
  GtkWidget *hbox_contact_list;
  GtkWidget *scrolledwindow_contact_list;
  GtkWidget *viewport_contact_list;
  GtkWidget *list_contact_list;
  GtkWidget *vbox_contact_list;
  GtkWidget *button_move_up;
  GtkWidget *button_move_down;
  GtkWidget *label16;
  GtkWidget *button_new_group;
  GtkWidget *button_new_contact;
  GtkWidget *button_edit_contact;
  GtkWidget *button_remove_contact;
  GtkWidget *frame_contact_option;
  GtkWidget *vbox_contact_option;
  GtkWidget *checkbutton_offline_group;
  GtkWidget *checkbutton_group_count;
  GtkWidget *checkbutton_auto_expand;
  GtkWidget *label_page_4;
  GtkWidget *hbox6;
  GtkWidget *frame_ignore;
  GtkWidget *table_ignore;
  GtkWidget *scrolledwindow_ignore;
  GtkWidget *viewport_ignore;
  GtkWidget *list_ignore;
  GtkWidget *entry_ignore_login;
  GtkWidget *button_ignore_add;
  GtkWidget *button_ignore_remove;
  GtkWidget *vbox5;
  GtkWidget *frame_ignore_answer;
  GtkWidget *hbox_ignore_answer;
  GtkWidget *label_ignore_answer;
  GtkWidget *entry_ignore_answer;
  GtkWidget *label_page_5;
  GtkWidget *vbox8;
  GtkWidget *frame4;
  GtkWidget *table12;
  GtkWidget *label12;
  GtkWidget *label13;
  GtkWidget *label14;
  GtkWidget *label15;
  GtkWidget *entry_message_width;
  GtkWidget *entry_message_height;
  GtkWidget *entry_message_x;
  GtkWidget *entry_message_y;
  GtkWidget *checkbutton_save_message_geometry;
  GtkWidget *checkbutton_expand_pict;
  GtkWidget *hbox9;
  GtkWidget *frame5;
  GtkWidget *vbox10;
  GtkWidget *checkbutton_history;
  GtkWidget *table10;
  GtkWidget *label6;
  GtkWidget *label7;
  GtkWidget *entry_history_line;
  GtkWidget *entry_history_color;
  GtkWidget *frame6;
  GtkWidget *table11;
  GtkWidget *label8;
  GtkWidget *label9;
  GtkWidget *label10;
  GtkWidget *label11;
  GtkWidget *entry_login_color;
  GtkWidget *entry_contact_color;
  GtkWidget *entry_text_color;
  GtkWidget *combo_time_format;
  GList *combo_time_format_items = NULL;
  GtkWidget *combo_entry_time_format;
  GtkWidget *label_page_6;
  GtkWidget *frame7;
  GtkWidget *vbox15;
  GtkWidget *label44;
  GtkWidget *label45;
  GtkWidget *label46;
  GtkWidget *label47;
  GtkWidget *label_page_7;
  GtkWidget *hbox_button;
  GtkWidget *btn_cancel;
  GtkWidget *btn_ok;

  GtkWidget *chkMail;
  GtkWidget *frmMail;
  GtkWidget *hboxMail;

  Control_Panel = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_object_set_data (GTK_OBJECT (Control_Panel), "Control_Panel", Control_Panel);
  gtk_window_set_title (GTK_WINDOW (Control_Panel), "Control Panel - NoSoucy");
  gtk_window_set_modal (GTK_WINDOW (Control_Panel), TRUE);
  gtk_window_set_position (GTK_WINDOW (Control_Panel), GTK_WIN_POS_CENTER);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (Control_Panel), vbox1);

  notebook1 = gtk_notebook_new ();
  gtk_widget_ref (notebook1);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "notebook1", notebook1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (notebook1);
  gtk_box_pack_start (GTK_BOX (vbox1), notebook1, TRUE, TRUE, 0);
  gtk_notebook_set_tab_vborder (GTK_NOTEBOOK (notebook1), 0);

  vbox7 = gtk_vbox_new (FALSE, 5);
  gtk_widget_ref (vbox7);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "vbox7", vbox7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox7);
  gtk_container_add (GTK_CONTAINER (notebook1), vbox7);
  gtk_container_set_border_width (GTK_CONTAINER (vbox7), 5);

  frame_server = gtk_frame_new ("Server");
  gtk_widget_ref (frame_server);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "frame_server", frame_server,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame_server);
  gtk_box_pack_start (GTK_BOX (vbox7), frame_server, FALSE, FALSE, 0);

  table_server = gtk_table_new (4, 2, FALSE);
  gtk_widget_ref (table_server);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "table_server", table_server,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table_server);
  gtk_container_add (GTK_CONTAINER (frame_server), table_server);
  gtk_container_set_border_width (GTK_CONTAINER (table_server), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table_server), 5);

  label_host = gtk_label_new ("Host : ");
  gtk_widget_ref (label_host);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label_host", label_host,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_host);
  gtk_table_attach (GTK_TABLE (table_server), label_host, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (label_host, 70, -2);
  gtk_misc_set_alignment (GTK_MISC (label_host), 0, 0.5);

  label_port = gtk_label_new ("Port : ");
  gtk_widget_ref (label_port);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label_port", label_port,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_port);
  gtk_table_attach (GTK_TABLE (table_server), label_port, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (label_port, 70, -2);
  gtk_misc_set_alignment (GTK_MISC (label_port), 0, 0.5);

  label_location = gtk_label_new ("Location : ");
  gtk_widget_ref (label_location);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label_location", label_location,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_location);
  gtk_table_attach (GTK_TABLE (table_server), label_location, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (label_location, 70, -2);
  gtk_misc_set_alignment (GTK_MISC (label_location), 0, 0.5);

  label_user_data = gtk_label_new ("User data : ");
  gtk_widget_ref (label_user_data);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label_user_data", label_user_data,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_user_data);
  gtk_table_attach (GTK_TABLE (table_server), label_user_data, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (label_user_data, 70, -2);
  gtk_misc_set_alignment (GTK_MISC (label_user_data), 0, 0.5);

  entry_port = gtk_entry_new ();
  gtk_widget_ref (entry_port);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_port", entry_port,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_port);
  gtk_table_attach (GTK_TABLE (table_server), entry_port, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_port, 100, -2);

  entry_location = gtk_entry_new ();
  gtk_widget_ref (entry_location);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_location", entry_location,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_location);
  gtk_table_attach (GTK_TABLE (table_server), entry_location, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_location, 100, -2);

  entry_user_data = gtk_entry_new ();
  gtk_widget_ref (entry_user_data);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_user_data", entry_user_data,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_user_data);
  gtk_table_attach (GTK_TABLE (table_server), entry_user_data, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_user_data, 100, -2);

  entry_host = gtk_entry_new ();
  gtk_widget_ref (entry_host);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_host", entry_host,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_host);
  gtk_table_attach (GTK_TABLE (table_server), entry_host, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_host, 100, -2);

  hbox7 = gtk_hbox_new (FALSE, 5);
  gtk_widget_ref (hbox7);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "hbox7", hbox7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox7);
  gtk_box_pack_start (GTK_BOX (vbox7), hbox7, FALSE, FALSE, 0);

  frame3 = gtk_frame_new ("Authentification");
  gtk_widget_ref (frame3);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "frame3", frame3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame3);
  gtk_box_pack_start (GTK_BOX (hbox7), frame3, TRUE, TRUE, 0);

  table9 = gtk_table_new (2, 2, FALSE);
  gtk_widget_ref (table9);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "table9", table9,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table9);
  gtk_container_add (GTK_CONTAINER (frame3), table9);
  gtk_container_set_border_width (GTK_CONTAINER (table9), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table9), 5);

  label4 = gtk_label_new ("Login : ");
  gtk_widget_ref (label4);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label4", label4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label4);
  gtk_table_attach (GTK_TABLE (table9), label4, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (label4, 70, -2);
  gtk_misc_set_alignment (GTK_MISC (label4), 0, 0.5);

  label5 = gtk_label_new ("Password : ");
  gtk_widget_ref (label5);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label5", label5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label5);
  gtk_table_attach (GTK_TABLE (table9), label5, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (label5, 70, -2);
  gtk_misc_set_alignment (GTK_MISC (label5), 0, 0.5);

  entry_login = gtk_entry_new ();
  gtk_widget_ref (entry_login);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_login", entry_login,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_login);
  gtk_table_attach (GTK_TABLE (table9), entry_login, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_login, 100, -2);

  entry_password = gtk_entry_new ();
  gtk_widget_ref (entry_password);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_password", entry_password,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_password);
  gtk_table_attach (GTK_TABLE (table9), entry_password, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_password, 100, -2);
  gtk_entry_set_visibility (GTK_ENTRY (entry_password), FALSE);

  frame_connection_option = gtk_frame_new ("Connection option");
  gtk_widget_ref (frame_connection_option);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "frame_connection_option", frame_connection_option,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame_connection_option);
  gtk_box_pack_start (GTK_BOX (hbox7), frame_connection_option, TRUE, TRUE, 0);

  table_connection_option = gtk_table_new (2, 2, FALSE);
  gtk_widget_ref (table_connection_option);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "table_connection_option", table_connection_option,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table_connection_option);
  gtk_container_add (GTK_CONTAINER (frame_connection_option), table_connection_option);
  gtk_container_set_border_width (GTK_CONTAINER (table_connection_option), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table_connection_option), 5);

  entry_attempt = gtk_entry_new ();
  gtk_widget_ref (entry_attempt);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_attempt", entry_attempt,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_attempt);
  gtk_table_attach (GTK_TABLE (table_connection_option), entry_attempt, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_attempt, 100, -2);

  entry_delay = gtk_entry_new ();
  gtk_widget_ref (entry_delay);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_delay", entry_delay,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_delay);
  gtk_table_attach (GTK_TABLE (table_connection_option), entry_delay, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_delay, 100, -2);

  label_attempt = gtk_label_new ("Attempt : ");
  gtk_widget_ref (label_attempt);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label_attempt", label_attempt,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_attempt);
  gtk_table_attach (GTK_TABLE (table_connection_option), label_attempt, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (label_attempt, 70, -2);
  gtk_misc_set_alignment (GTK_MISC (label_attempt), 0, 0.5);

  label_delay = gtk_label_new ("Delay : ");
  gtk_widget_ref (label_delay);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label_delay", label_delay,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_delay);
  gtk_table_attach (GTK_TABLE (table_connection_option), label_delay, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (label_delay, 70, -2);
  gtk_misc_set_alignment (GTK_MISC (label_delay), 0, 0.5);

  label_page_1 = gtk_label_new ("Connection");
  gtk_widget_ref (label_page_1);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label_page_1", label_page_1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_page_1);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 0), label_page_1);

  vbox_automation = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox_automation);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "vbox_automation", vbox_automation,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox_automation);
  gtk_container_add (GTK_CONTAINER (notebook1), vbox_automation);
  gtk_container_set_border_width (GTK_CONTAINER (vbox_automation), 5);

  hboxMail = gtk_hbox_new (TRUE, 5);
  gtk_widget_ref (hboxMail);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "hboxMail", hboxMail,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hboxMail);
  gtk_box_pack_start (GTK_BOX (vbox_automation), hboxMail, FALSE, TRUE, 0);

  frame_state = gtk_frame_new ("State");
  gtk_widget_ref (frame_state);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "frame_state", frame_state,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame_state);
  gtk_box_pack_start (GTK_BOX (hboxMail), frame_state, FALSE, TRUE, 0);

  frmMail = gtk_frame_new ("Mail");
  gtk_widget_ref (frmMail);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "frmMail", frmMail,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frmMail);
  gtk_box_pack_start (GTK_BOX (hboxMail), frmMail, FALSE, TRUE, 0);

  chkMail = gtk_check_button_new_with_label ("Popup on new mail");
  gtk_widget_ref (chkMail);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "chkMail", chkMail,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (chkMail);
  gtk_container_add (GTK_CONTAINER (frmMail), chkMail);
  
  table_state = gtk_table_new (1, 2, FALSE);
  gtk_widget_ref (table_state);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "table_state", table_state,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table_state);
  gtk_container_add (GTK_CONTAINER (frame_state), table_state);
  gtk_container_set_border_width (GTK_CONTAINER (table_state), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table_state), 5);

  label_auto_away_delay = gtk_label_new ("Auto away delay : ");
  gtk_widget_ref (label_auto_away_delay);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label_auto_away_delay", label_auto_away_delay,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_auto_away_delay);
  gtk_table_attach (GTK_TABLE (table_state), label_auto_away_delay, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_auto_away_delay), 0, 0.5);

  entry_auto_away_delay = gtk_entry_new_with_max_length (3);
  gtk_widget_ref (entry_auto_away_delay);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_auto_away_delay", entry_auto_away_delay,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_auto_away_delay);
  gtk_table_attach (GTK_TABLE (table_state), entry_auto_away_delay, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_auto_away_delay, 30, -2);

  frame_away_message = gtk_frame_new ("Away Message");
  gtk_widget_ref (frame_away_message);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "frame_away_message", frame_away_message,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame_away_message);
  gtk_box_pack_start (GTK_BOX (vbox_automation), frame_away_message, TRUE, TRUE, 0);

  table_away_message = gtk_table_new (3, 3, FALSE);
  gtk_widget_ref (table_away_message);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "table_away_message", table_away_message,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table_away_message);
  gtk_container_add (GTK_CONTAINER (frame_away_message), table_away_message);
  gtk_container_set_border_width (GTK_CONTAINER (table_away_message), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table_away_message), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table_away_message), 5);

  checkbutton_auto_answer = gtk_check_button_new_with_label ("Auto answer");
  gtk_widget_ref (checkbutton_auto_answer);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "checkbutton_auto_answer", checkbutton_auto_answer,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_auto_answer);
  gtk_table_attach (GTK_TABLE (table_away_message), checkbutton_auto_answer, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  entry_auto_answer = gtk_entry_new ();
  gtk_widget_ref (entry_auto_answer);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_auto_answer", entry_auto_answer,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_auto_answer);
  gtk_table_attach (GTK_TABLE (table_away_message), entry_auto_answer, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  button_remove_auto_answer = gtk_button_new_with_label ("Remove");
  gtk_widget_ref (button_remove_auto_answer);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "button_remove_auto_answer", button_remove_auto_answer,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_remove_auto_answer);
  gtk_table_attach (GTK_TABLE (table_away_message), button_remove_auto_answer, 2, 3, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (button_remove_auto_answer, 50, -2);

  button_add_auto_answer = gtk_button_new_with_label ("Add");
  gtk_widget_ref (button_add_auto_answer);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "button_add_auto_answer", button_add_auto_answer,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_add_auto_answer);
  gtk_table_attach (GTK_TABLE (table_away_message), button_add_auto_answer, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (button_add_auto_answer, 50, -2);

  scrolledwindow_auto_answer = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow_auto_answer);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "scrolledwindow_auto_answer", scrolledwindow_auto_answer,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow_auto_answer);
  gtk_table_attach (GTK_TABLE (table_away_message), scrolledwindow_auto_answer, 0, 3, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow_auto_answer), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  viewport_auto_answer = gtk_viewport_new (NULL, NULL);
  gtk_widget_ref (viewport_auto_answer);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "viewport_auto_answer", viewport_auto_answer,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (viewport_auto_answer);
  gtk_container_add (GTK_CONTAINER (scrolledwindow_auto_answer), viewport_auto_answer);

  list_auto_answer = gtk_list_new ();
  gtk_widget_ref (list_auto_answer);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "list_auto_answer", list_auto_answer,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (list_auto_answer);
  gtk_container_add (GTK_CONTAINER (viewport_auto_answer), list_auto_answer);

  label_page_2 = gtk_label_new ("Automation");
  gtk_widget_ref (label_page_2);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label_page_2", label_page_2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_page_2);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 1), label_page_2);

  vbox_aspect = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox_aspect);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "vbox_aspect", vbox_aspect,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox_aspect);
  gtk_container_add (GTK_CONTAINER (notebook1), vbox_aspect);
  gtk_container_set_border_width (GTK_CONTAINER (vbox_aspect), 5);

  frame_aspect_geometry = gtk_frame_new ("Geometry");
  gtk_widget_ref (frame_aspect_geometry);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "frame_aspect_geometry", frame_aspect_geometry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame_aspect_geometry);
  gtk_box_pack_start (GTK_BOX (vbox_aspect), frame_aspect_geometry, FALSE, FALSE, 0);

  table_aspect_geometry = gtk_table_new (3, 4, FALSE);
  gtk_widget_ref (table_aspect_geometry);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "table_aspect_geometry", table_aspect_geometry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table_aspect_geometry);
  gtk_container_add (GTK_CONTAINER (frame_aspect_geometry), table_aspect_geometry);
  gtk_container_set_border_width (GTK_CONTAINER (table_aspect_geometry), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table_aspect_geometry), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table_aspect_geometry), 5);

  label_aspect_width = gtk_label_new ("Width : ");
  gtk_widget_ref (label_aspect_width);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label_aspect_width", label_aspect_width,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_aspect_width);
  gtk_table_attach (GTK_TABLE (table_aspect_geometry), label_aspect_width, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (label_aspect_width, 50, -2);
  gtk_misc_set_alignment (GTK_MISC (label_aspect_width), 0, 0.5);

  label_aspect_height = gtk_label_new ("Height : ");
  gtk_widget_ref (label_aspect_height);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label_aspect_height", label_aspect_height,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_aspect_height);
  gtk_table_attach (GTK_TABLE (table_aspect_geometry), label_aspect_height, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (label_aspect_height, 50, -2);
  gtk_misc_set_alignment (GTK_MISC (label_aspect_height), 0, 0.5);

  label_aspect_x = gtk_label_new ("X : ");
  gtk_widget_ref (label_aspect_x);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label_aspect_x", label_aspect_x,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_aspect_x);
  gtk_table_attach (GTK_TABLE (table_aspect_geometry), label_aspect_x, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (label_aspect_x, 25, -2);
  gtk_misc_set_alignment (GTK_MISC (label_aspect_x), 0, 0.5);

  label_aspect_y = gtk_label_new ("Y : ");
  gtk_widget_ref (label_aspect_y);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label_aspect_y", label_aspect_y,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_aspect_y);
  gtk_table_attach (GTK_TABLE (table_aspect_geometry), label_aspect_y, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (label_aspect_y, 25, -2);
  gtk_misc_set_alignment (GTK_MISC (label_aspect_y), 0, 0.5);

  checkbutton_save_geometry = gtk_check_button_new_with_label ("Save geometry on exit");
  gtk_widget_ref (checkbutton_save_geometry);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "checkbutton_save_geometry", checkbutton_save_geometry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_save_geometry);
  gtk_table_attach (GTK_TABLE (table_aspect_geometry), checkbutton_save_geometry, 0, 4, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  entry_aspect_width = gtk_entry_new_with_max_length (4);
  gtk_widget_ref (entry_aspect_width);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_aspect_width", entry_aspect_width,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_aspect_width);
  gtk_table_attach (GTK_TABLE (table_aspect_geometry), entry_aspect_width, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_aspect_width, 75, -2);

  entry_aspect_height = gtk_entry_new_with_max_length (4);
  gtk_widget_ref (entry_aspect_height);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_aspect_height", entry_aspect_height,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_aspect_height);
  gtk_table_attach (GTK_TABLE (table_aspect_geometry), entry_aspect_height, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_aspect_height, 75, -2);

  entry_aspect_x = gtk_entry_new_with_max_length (4);
  gtk_widget_ref (entry_aspect_x);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_aspect_x", entry_aspect_x,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_aspect_x);
  gtk_table_attach (GTK_TABLE (table_aspect_geometry), entry_aspect_x, 3, 4, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_aspect_x, 75, -2);

  entry_aspect_y = gtk_entry_new_with_max_length (4);
  gtk_widget_ref (entry_aspect_y);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_aspect_y", entry_aspect_y,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_aspect_y);
  gtk_table_attach (GTK_TABLE (table_aspect_geometry), entry_aspect_y, 3, 4, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_aspect_y, 75, -2);

  frame_skin = gtk_frame_new ("Skin");
  gtk_widget_ref (frame_skin);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "frame_skin", frame_skin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame_skin);
  gtk_box_pack_start (GTK_BOX (vbox_aspect), frame_skin, FALSE, TRUE, 0);

  table_skin = gtk_table_new (1, 2, FALSE);
  gtk_widget_ref (table_skin);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "table_skin", table_skin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table_skin);
  gtk_container_add (GTK_CONTAINER (frame_skin), table_skin);
  gtk_container_set_border_width (GTK_CONTAINER (table_skin), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table_skin), 5);

  label_skin_file = gtk_label_new ("Skin file : ");
  gtk_widget_ref (label_skin_file);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label_skin_file", label_skin_file,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_skin_file);
  gtk_table_attach (GTK_TABLE (table_skin), label_skin_file, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_skin_file), 0, 0.5);

  entry_skin_file = gtk_entry_new ();
  gtk_widget_ref (entry_skin_file);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_skin_file", entry_skin_file,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_skin_file);
  gtk_table_attach (GTK_TABLE (table_skin), entry_skin_file, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label_page_3 = gtk_label_new ("Aspect");
  gtk_widget_ref (label_page_3);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label_page_3", label_page_3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_page_3);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 2), label_page_3);

  hbox_contacts = gtk_hbox_new (FALSE, 5);
  gtk_widget_ref (hbox_contacts);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "hbox_contacts", hbox_contacts,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox_contacts);
  gtk_container_add (GTK_CONTAINER (notebook1), hbox_contacts);
  gtk_container_set_border_width (GTK_CONTAINER (hbox_contacts), 5);

  frame_contact_list = gtk_frame_new ("Contact list");
  gtk_widget_ref (frame_contact_list);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "frame_contact_list", frame_contact_list,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame_contact_list);
  gtk_box_pack_start (GTK_BOX (hbox_contacts), frame_contact_list, FALSE, TRUE, 0);

  hbox_contact_list = gtk_hbox_new (FALSE, 5);
  gtk_widget_ref (hbox_contact_list);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "hbox_contact_list", hbox_contact_list,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox_contact_list);
  gtk_container_add (GTK_CONTAINER (frame_contact_list), hbox_contact_list);
  gtk_container_set_border_width (GTK_CONTAINER (hbox_contact_list), 5);

  scrolledwindow_contact_list = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow_contact_list);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "scrolledwindow_contact_list", scrolledwindow_contact_list,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow_contact_list);
  gtk_box_pack_start (GTK_BOX (hbox_contact_list), scrolledwindow_contact_list, TRUE, TRUE, 0);
  gtk_widget_set_usize (scrolledwindow_contact_list, 125, -2);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow_contact_list), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

  viewport_contact_list = gtk_viewport_new (NULL, NULL);
  gtk_widget_ref (viewport_contact_list);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "viewport_contact_list", viewport_contact_list,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (viewport_contact_list);
  gtk_container_add (GTK_CONTAINER (scrolledwindow_contact_list), viewport_contact_list);

  list_contact_list = gtk_list_new ();
  gtk_widget_ref (list_contact_list);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "list_contact_list", list_contact_list,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (list_contact_list);
  gtk_container_add (GTK_CONTAINER (viewport_contact_list), list_contact_list);

  vbox_contact_list = gtk_vbox_new (FALSE, 5);
  gtk_widget_ref (vbox_contact_list);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "vbox_contact_list", vbox_contact_list,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox_contact_list);
  gtk_box_pack_start (GTK_BOX (hbox_contact_list), vbox_contact_list, FALSE, TRUE, 0);

  button_move_up = gtk_button_new_with_label ("Move up");
  gtk_widget_ref (button_move_up);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "button_move_up", button_move_up,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_move_up);
  gtk_box_pack_start (GTK_BOX (vbox_contact_list), button_move_up, FALSE, FALSE, 0);

  button_move_down = gtk_button_new_with_label ("Move down");
  gtk_widget_ref (button_move_down);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "button_move_down", button_move_down,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_move_down);
  gtk_box_pack_start (GTK_BOX (vbox_contact_list), button_move_down, FALSE, FALSE, 0);

  label16 = gtk_label_new ("");
  gtk_widget_ref (label16);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label16", label16,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label16);
  gtk_box_pack_start (GTK_BOX (vbox_contact_list), label16, TRUE, FALSE, 0);

  button_new_group = gtk_button_new_with_label ("New group");
  gtk_widget_ref (button_new_group);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "button_new_group", button_new_group,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_new_group);
  gtk_box_pack_start (GTK_BOX (vbox_contact_list), button_new_group, FALSE, FALSE, 0);

  button_new_contact = gtk_button_new_with_label ("New contact");
  gtk_widget_ref (button_new_contact);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "button_new_contact", button_new_contact,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_new_contact);
  gtk_box_pack_start (GTK_BOX (vbox_contact_list), button_new_contact, FALSE, FALSE, 0);

  button_edit_contact = gtk_button_new_with_label ("Edit");
  gtk_widget_ref (button_edit_contact);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "button_edit_contact", button_edit_contact,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_edit_contact);
  gtk_box_pack_start (GTK_BOX (vbox_contact_list), button_edit_contact, FALSE, FALSE, 0);

  button_remove_contact = gtk_button_new_with_label ("Remove");
  gtk_widget_ref (button_remove_contact);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "button_remove_contact", button_remove_contact,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_remove_contact);
  gtk_box_pack_start (GTK_BOX (vbox_contact_list), button_remove_contact, FALSE, FALSE, 0);

  frame_contact_option = gtk_frame_new ("Contact Option");
  gtk_widget_ref (frame_contact_option);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "frame_contact_option", frame_contact_option,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame_contact_option);
  gtk_box_pack_start (GTK_BOX (hbox_contacts), frame_contact_option, FALSE, TRUE, 0);

  vbox_contact_option = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox_contact_option);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "vbox_contact_option", vbox_contact_option,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox_contact_option);
  gtk_container_add (GTK_CONTAINER (frame_contact_option), vbox_contact_option);
  gtk_container_set_border_width (GTK_CONTAINER (vbox_contact_option), 5);

  checkbutton_offline_group = gtk_check_button_new_with_label ("Offline group");
  gtk_widget_ref (checkbutton_offline_group);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "checkbutton_offline_group", checkbutton_offline_group,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_offline_group);
  gtk_box_pack_start (GTK_BOX (vbox_contact_option), checkbutton_offline_group, FALSE, FALSE, 0);

  checkbutton_group_count = gtk_check_button_new_with_label ("Group count");
  gtk_widget_ref (checkbutton_group_count);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "checkbutton_group_count", checkbutton_group_count,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_group_count);
  gtk_box_pack_start (GTK_BOX (vbox_contact_option), checkbutton_group_count, FALSE, FALSE, 0);

  checkbutton_auto_expand = gtk_check_button_new_with_label ("Auto Expand all group");
  gtk_widget_ref (checkbutton_auto_expand);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "checkbutton_auto_expand", checkbutton_auto_expand,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_auto_expand);
  gtk_box_pack_start (GTK_BOX (vbox_contact_option), checkbutton_auto_expand, FALSE, FALSE, 0);

  label_page_4 = gtk_label_new ("Contacts");
  gtk_widget_ref (label_page_4);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label_page_4", label_page_4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_page_4);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 3), label_page_4);

  hbox6 = gtk_hbox_new (FALSE, 5);
  gtk_widget_ref (hbox6);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "hbox6", hbox6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox6);
  gtk_container_add (GTK_CONTAINER (notebook1), hbox6);
  gtk_container_set_border_width (GTK_CONTAINER (hbox6), 5);

  frame_ignore = gtk_frame_new ("Ignore List");
  gtk_widget_ref (frame_ignore);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "frame_ignore", frame_ignore,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame_ignore);
  gtk_box_pack_start (GTK_BOX (hbox6), frame_ignore, TRUE, TRUE, 0);

  table_ignore = gtk_table_new (3, 2, FALSE);
  gtk_widget_ref (table_ignore);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "table_ignore", table_ignore,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table_ignore);
  gtk_container_add (GTK_CONTAINER (frame_ignore), table_ignore);
  gtk_container_set_border_width (GTK_CONTAINER (table_ignore), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table_ignore), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table_ignore), 5);

  scrolledwindow_ignore = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow_ignore);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "scrolledwindow_ignore", scrolledwindow_ignore,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow_ignore);
  gtk_table_attach (GTK_TABLE (table_ignore), scrolledwindow_ignore, 0, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_widget_set_usize (scrolledwindow_ignore, 125, -2);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow_ignore), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  viewport_ignore = gtk_viewport_new (NULL, NULL);
  gtk_widget_ref (viewport_ignore);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "viewport_ignore", viewport_ignore,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (viewport_ignore);
  gtk_container_add (GTK_CONTAINER (scrolledwindow_ignore), viewport_ignore);
  gtk_widget_set_usize (viewport_ignore, 10, -2);

  list_ignore = gtk_list_new ();
  gtk_widget_ref (list_ignore);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "list_ignore", list_ignore,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (list_ignore);
  gtk_container_add (GTK_CONTAINER (viewport_ignore), list_ignore);

  entry_ignore_login = gtk_entry_new ();
  gtk_widget_ref (entry_ignore_login);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_ignore_login", entry_ignore_login,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_ignore_login);
  gtk_table_attach (GTK_TABLE (table_ignore), entry_ignore_login, 0, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_ignore_login, 125, -2);

  button_ignore_add = gtk_button_new_with_label ("Add");
  gtk_widget_ref (button_ignore_add);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "button_ignore_add", button_ignore_add,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_ignore_add);
  gtk_table_attach (GTK_TABLE (table_ignore), button_ignore_add, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (button_ignore_add, 50, -2);

  button_ignore_remove = gtk_button_new_with_label ("Remove");
  gtk_widget_ref (button_ignore_remove);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "button_ignore_remove", button_ignore_remove,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_ignore_remove);
  gtk_table_attach (GTK_TABLE (table_ignore), button_ignore_remove, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (button_ignore_remove, 50, -2);

  vbox5 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox5);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "vbox5", vbox5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox5);
  gtk_box_pack_start (GTK_BOX (hbox6), vbox5, TRUE, TRUE, 0);

  frame_ignore_answer = gtk_frame_new ("Ignore answer");
  gtk_widget_ref (frame_ignore_answer);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "frame_ignore_answer", frame_ignore_answer,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame_ignore_answer);
  gtk_box_pack_start (GTK_BOX (vbox5), frame_ignore_answer, FALSE, TRUE, 0);

  hbox_ignore_answer = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox_ignore_answer);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "hbox_ignore_answer", hbox_ignore_answer,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox_ignore_answer);
  gtk_container_add (GTK_CONTAINER (frame_ignore_answer), hbox_ignore_answer);
  gtk_container_set_border_width (GTK_CONTAINER (hbox_ignore_answer), 5);

  label_ignore_answer = gtk_label_new ("Answer with : ");
  gtk_widget_ref (label_ignore_answer);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label_ignore_answer", label_ignore_answer,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_ignore_answer);
  gtk_box_pack_start (GTK_BOX (hbox_ignore_answer), label_ignore_answer, FALSE, FALSE, 0);

  entry_ignore_answer = gtk_entry_new ();
  gtk_widget_ref (entry_ignore_answer);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_ignore_answer", entry_ignore_answer,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_ignore_answer);
  gtk_box_pack_start (GTK_BOX (hbox_ignore_answer), entry_ignore_answer, TRUE, TRUE, 0);
  gtk_widget_set_usize (entry_ignore_answer, 125, -2);

  label_page_5 = gtk_label_new ("Ignore");
  gtk_widget_ref (label_page_5);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label_page_5", label_page_5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_page_5);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 4), label_page_5);

  vbox8 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox8);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "vbox8", vbox8,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox8);
  gtk_container_add (GTK_CONTAINER (notebook1), vbox8);
  gtk_container_set_border_width (GTK_CONTAINER (vbox8), 5);

  frame4 = gtk_frame_new ("Window");
  gtk_widget_ref (frame4);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "frame4", frame4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame4);
  gtk_box_pack_start (GTK_BOX (vbox8), frame4, TRUE, TRUE, 0);

  table12 = gtk_table_new (2, 5, FALSE);
  gtk_widget_ref (table12);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "table12", table12,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table12);
  gtk_container_add (GTK_CONTAINER (frame4), table12);
  gtk_container_set_border_width (GTK_CONTAINER (table12), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table12), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table12), 5);

  label12 = gtk_label_new ("Width : ");
  gtk_widget_ref (label12);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label12", label12,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label12);
  gtk_table_attach (GTK_TABLE (table12), label12, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (label12, 50, -2);
  gtk_misc_set_alignment (GTK_MISC (label12), 0, 0.5);

  label13 = gtk_label_new ("Height : ");
  gtk_widget_ref (label13);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label13", label13,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label13);
  gtk_table_attach (GTK_TABLE (table12), label13, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (label13, 50, -2);
  gtk_misc_set_alignment (GTK_MISC (label13), 0, 0.5);

  label14 = gtk_label_new ("X : ");
  gtk_widget_ref (label14);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label14", label14,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label14);
  gtk_table_attach (GTK_TABLE (table12), label14, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (label14, 25, -2);
  gtk_misc_set_alignment (GTK_MISC (label14), 0, 0.5);

  label15 = gtk_label_new ("Y : ");
  gtk_widget_ref (label15);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label15", label15,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label15);
  gtk_table_attach (GTK_TABLE (table12), label15, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (label15, 25, -2);
  gtk_misc_set_alignment (GTK_MISC (label15), 0, 0.5);

  entry_message_width = gtk_entry_new_with_max_length (4);
  gtk_widget_ref (entry_message_width);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_message_width", entry_message_width,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_message_width);
  gtk_table_attach (GTK_TABLE (table12), entry_message_width, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_message_width, 75, -2);

  entry_message_height = gtk_entry_new_with_max_length (4);
  gtk_widget_ref (entry_message_height);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_message_height", entry_message_height,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_message_height);
  gtk_table_attach (GTK_TABLE (table12), entry_message_height, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_message_height, 75, -2);

  entry_message_x = gtk_entry_new_with_max_length (4);
  gtk_widget_ref (entry_message_x);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_message_x", entry_message_x,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_message_x);
  gtk_table_attach (GTK_TABLE (table12), entry_message_x, 3, 4, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_message_x, 75, -2);

  entry_message_y = gtk_entry_new_with_max_length (4);
  gtk_widget_ref (entry_message_y);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_message_y", entry_message_y,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_message_y);
  gtk_table_attach (GTK_TABLE (table12), entry_message_y, 3, 4, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_message_y, 75, -2);

  checkbutton_save_message_geometry = gtk_check_button_new_with_label ("Save geometry");
  gtk_widget_ref (checkbutton_save_message_geometry);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "checkbutton_save_message_geometry", checkbutton_save_message_geometry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_save_message_geometry);
  gtk_table_attach (GTK_TABLE (table12), checkbutton_save_message_geometry, 4, 5, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  checkbutton_expand_pict = gtk_check_button_new_with_label ("Expand pict");
  gtk_widget_ref (checkbutton_expand_pict);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "checkbutton_expand_pict", checkbutton_expand_pict,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_expand_pict);
  gtk_table_attach (GTK_TABLE (table12), checkbutton_expand_pict, 4, 5, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  hbox9 = gtk_hbox_new (FALSE, 5);
  gtk_widget_ref (hbox9);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "hbox9", hbox9,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox9);
  gtk_box_pack_start (GTK_BOX (vbox8), hbox9, TRUE, TRUE, 0);

  frame5 = gtk_frame_new ("History");
  gtk_widget_ref (frame5);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "frame5", frame5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame5);
  gtk_box_pack_start (GTK_BOX (hbox9), frame5, FALSE, FALSE, 0);

  vbox10 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox10);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "vbox10", vbox10,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox10);
  gtk_container_add (GTK_CONTAINER (frame5), vbox10);
  gtk_container_set_border_width (GTK_CONTAINER (vbox10), 5);

  checkbutton_history = gtk_check_button_new_with_label ("Enable");
  gtk_widget_ref (checkbutton_history);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "checkbutton_history", checkbutton_history,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_history);
  gtk_box_pack_start (GTK_BOX (vbox10), checkbutton_history, FALSE, FALSE, 0);

  table10 = gtk_table_new (2, 2, FALSE);
  gtk_widget_ref (table10);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "table10", table10,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table10);
  gtk_box_pack_start (GTK_BOX (vbox10), table10, TRUE, TRUE, 0);
  gtk_table_set_row_spacings (GTK_TABLE (table10), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table10), 5);

  label6 = gtk_label_new ("History line :");
  gtk_widget_ref (label6);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label6", label6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label6);
  gtk_table_attach (GTK_TABLE (table10), label6, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label6), 0, 0.5);

  label7 = gtk_label_new ("History color :");
  gtk_widget_ref (label7);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label7", label7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label7);
  gtk_table_attach (GTK_TABLE (table10), label7, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label7), 0, 0.5);

  entry_history_line = gtk_entry_new ();
  gtk_widget_ref (entry_history_line);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_history_line", entry_history_line,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_history_line);
  gtk_table_attach (GTK_TABLE (table10), entry_history_line, 1, 2, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_history_line, 75, -2);

  entry_history_color = gtk_entry_new ();
  gtk_widget_ref (entry_history_color);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_history_color", entry_history_color,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_history_color);
  gtk_table_attach (GTK_TABLE (table10), entry_history_color, 1, 2, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_history_color, 75, -2);

  frame6 = gtk_frame_new ("Misc");
  gtk_widget_ref (frame6);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "frame6", frame6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame6);
  gtk_box_pack_start (GTK_BOX (hbox9), frame6, TRUE, TRUE, 0);

  table11 = gtk_table_new (4, 2, FALSE);
  gtk_widget_ref (table11);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "table11", table11,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table11);
  gtk_container_add (GTK_CONTAINER (frame6), table11);
  gtk_container_set_border_width (GTK_CONTAINER (table11), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table11), 5);

  label8 = gtk_label_new ("Time format : ");
  gtk_widget_ref (label8);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label8", label8,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label8);
  gtk_table_attach (GTK_TABLE (table11), label8, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label8), 0, 0.5);

  label9 = gtk_label_new ("Login color : ");
  gtk_widget_ref (label9);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label9", label9,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label9);
  gtk_table_attach (GTK_TABLE (table11), label9, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label9), 0, 0.5);

  label10 = gtk_label_new ("Contact color : ");
  gtk_widget_ref (label10);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label10", label10,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label10);
  gtk_table_attach (GTK_TABLE (table11), label10, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label10), 0, 0.5);

  label11 = gtk_label_new ("Text color : ");
  gtk_widget_ref (label11);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label11", label11,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label11);
  gtk_table_attach (GTK_TABLE (table11), label11, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label11), 0, 0.5);

  entry_login_color = gtk_entry_new ();
  gtk_widget_ref (entry_login_color);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_login_color", entry_login_color,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_login_color);
  gtk_table_attach (GTK_TABLE (table11), entry_login_color, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_login_color, 75, -2);

  entry_contact_color = gtk_entry_new ();
  gtk_widget_ref (entry_contact_color);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_contact_color", entry_contact_color,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_contact_color);
  gtk_table_attach (GTK_TABLE (table11), entry_contact_color, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_contact_color, 75, -2);

  entry_text_color = gtk_entry_new ();
  gtk_widget_ref (entry_text_color);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "entry_text_color", entry_text_color,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_text_color);
  gtk_table_attach (GTK_TABLE (table11), entry_text_color, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_text_color, 75, -2);

  combo_time_format = gtk_combo_new ();
  gtk_widget_ref (combo_time_format);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "combo_time_format", combo_time_format,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_time_format);
  gtk_table_attach (GTK_TABLE (table11), combo_time_format, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_widget_set_usize (combo_time_format, 80, -2);
  combo_time_format_items = g_list_append (combo_time_format_items, (gpointer) "None");
  combo_time_format_items = g_list_append (combo_time_format_items, (gpointer) "HH/MM");
  combo_time_format_items = g_list_append (combo_time_format_items, (gpointer) "HH/MM/SS");
  gtk_combo_set_popdown_strings (GTK_COMBO (combo_time_format), combo_time_format_items);
  g_list_free (combo_time_format_items);

  combo_entry_time_format = GTK_COMBO (combo_time_format)->entry;
  gtk_widget_ref (combo_entry_time_format);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "combo_entry_time_format", combo_entry_time_format,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_entry_time_format);
  gtk_entry_set_editable (GTK_ENTRY (combo_entry_time_format), FALSE);
  gtk_entry_set_text (GTK_ENTRY (combo_entry_time_format), "HH/MM/SS");

  label_page_6 = gtk_label_new ("Message");
  gtk_widget_ref (label_page_6);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label_page_6", label_page_6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_page_6);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 5), label_page_6);

  frame7 = gtk_frame_new ("About NoSoucy");
  gtk_widget_ref (frame7);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "frame7", frame7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame7);
  gtk_container_add (GTK_CONTAINER (notebook1), frame7);
  gtk_container_set_border_width (GTK_CONTAINER (frame7), 5);

  vbox15 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox15);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "vbox15", vbox15,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox15);
  gtk_container_add (GTK_CONTAINER (frame7), vbox15);

  label44 = gtk_label_new (NOSOUCY_VERSION);
  gtk_widget_ref (label44);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label44", label44,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label44);
  gtk_box_pack_start (GTK_BOX (vbox15), label44, FALSE, FALSE, 0);
  gtk_widget_set_usize (label44, -2, 50);

  label45 = gtk_label_new ("");
  gtk_label_parse_uline (GTK_LABEL (label45),
                         "Made by herrer__a");
  gtk_widget_ref (label45);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label45", label45,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label45);
  gtk_box_pack_start (GTK_BOX (vbox15), label45, FALSE, FALSE, 0);
  gtk_widget_set_usize (label45, -2, 25);

  label46 = gtk_label_new ("");
  gtk_label_parse_uline (GTK_LABEL (label46),
                         "Bug report : herrer__a@epita.fr");
  gtk_widget_ref (label46);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label46", label46,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label46);
  gtk_box_pack_start (GTK_BOX (vbox15), label46, FALSE, FALSE, 0);
  gtk_widget_set_usize (label46, -2, 25);

  label47 = gtk_label_new ("Web site : http://wcube.epitech.net/~herrer_a/NoSoucy/");
  gtk_widget_ref (label47);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label47", label47,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label47);
  gtk_box_pack_start (GTK_BOX (vbox15), label47, FALSE, FALSE, 0);
  gtk_widget_set_usize (label47, -2, 25);

  label_page_7 = gtk_label_new ("?");
  gtk_widget_ref (label_page_7);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "label_page_7", label_page_7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_page_7);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 6), label_page_7);

  hbox_button = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox_button);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "hbox_button", hbox_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox_button);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox_button, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox_button), 5);

  btn_cancel = gtk_button_new_with_label ("Cancel");
  gtk_widget_ref (btn_cancel);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "btn_cancel", btn_cancel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (btn_cancel);
  gtk_box_pack_end (GTK_BOX (hbox_button), btn_cancel, FALSE, FALSE, 5);
  gtk_widget_set_usize (btn_cancel, 75, -2);

  btn_ok = gtk_button_new_with_label ("OK");
  gtk_widget_ref (btn_ok);
  gtk_object_set_data_full (GTK_OBJECT (Control_Panel), "btn_ok", btn_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (btn_ok);
  gtk_box_pack_end (GTK_BOX (hbox_button), btn_ok, FALSE, FALSE, 5);
  gtk_widget_set_usize (btn_ok, 75, -2);

  gtk_signal_connect (GTK_OBJECT (button_remove_auto_answer), "clicked",
                      GTK_SIGNAL_FUNC (on_button_remove_auto_answer_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (button_add_auto_answer), "clicked",
                      GTK_SIGNAL_FUNC (on_button_add_auto_answer_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (button_move_up), "clicked",
                      GTK_SIGNAL_FUNC (on_button_move_up_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (button_move_down), "clicked",
                      GTK_SIGNAL_FUNC (on_button_move_down_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (button_new_group), "clicked",
                      GTK_SIGNAL_FUNC (on_button_new_group_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (button_new_contact), "clicked",
                      GTK_SIGNAL_FUNC (on_button_new_contact_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (button_edit_contact), "clicked",
                      GTK_SIGNAL_FUNC (on_button_edit_contact_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (button_remove_contact), "clicked",
                      GTK_SIGNAL_FUNC (on_button_remove_contact_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (button_ignore_add), "clicked",
                      GTK_SIGNAL_FUNC (on_button_ignore_add_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (button_ignore_remove), "clicked",
                      GTK_SIGNAL_FUNC (on_button_ignore_remove_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (btn_cancel), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_cancel_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (btn_ok), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_ok_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (Control_Panel), "destroy",
                      GTK_SIGNAL_FUNC (on_Control_Panel_destroy),
                      NULL);
}

static GtkWidget*	create_Add_Contact(void)
{
  GtkWidget *vbox3;
  GtkWidget *frame1;
  GtkWidget *table6;
  GtkWidget *label1;
  GtkWidget *label2;
  GtkWidget *entry_login;
  GtkWidget *entry_alias;
  GtkWidget *hbox3;
  GtkWidget *checkbutton_auto_expand;
  GtkWidget *checkbutton_alert_log_on;
  GtkWidget *hbox2;
  GtkWidget *button_ok;
  GtkWidget *button_cancel;

  Add_Contact = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_object_set_data (GTK_OBJECT (Add_Contact), "Add_Contact", Add_Contact);
  gtk_container_set_border_width (GTK_CONTAINER (Add_Contact), 5);
  gtk_window_set_title (GTK_WINDOW (Add_Contact), "Add contact");
  gtk_window_set_position (GTK_WINDOW (Add_Contact), GTK_WIN_POS_CENTER);
  gtk_window_set_modal (GTK_WINDOW (Add_Contact), TRUE);
  gtk_window_set_policy (GTK_WINDOW (Add_Contact), FALSE, FALSE, FALSE);

  vbox3 = gtk_vbox_new (FALSE, 5);
  gtk_widget_ref (vbox3);
  gtk_object_set_data_full (GTK_OBJECT (Add_Contact), "vbox3", vbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox3);
  gtk_container_add (GTK_CONTAINER (Add_Contact), vbox3);

  frame1 = gtk_frame_new ("Add contact");
  gtk_widget_ref (frame1);
  gtk_object_set_data_full (GTK_OBJECT (Add_Contact), "frame1", frame1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame1);
  gtk_box_pack_start (GTK_BOX (vbox3), frame1, TRUE, TRUE, 0);

  table6 = gtk_table_new (3, 2, FALSE);
  gtk_widget_ref (table6);
  gtk_object_set_data_full (GTK_OBJECT (Add_Contact), "table6", table6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table6);
  gtk_container_add (GTK_CONTAINER (frame1), table6);
  gtk_container_set_border_width (GTK_CONTAINER (table6), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table6), 5);

  label1 = gtk_label_new ("Login : ");
  gtk_widget_ref (label1);
  gtk_object_set_data_full (GTK_OBJECT (Add_Contact), "label1", label1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label1);
  gtk_table_attach (GTK_TABLE (table6), label1, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label1), 0, 0.5);

  label2 = gtk_label_new ("Alias : ");
  gtk_widget_ref (label2);
  gtk_object_set_data_full (GTK_OBJECT (Add_Contact), "label2", label2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label2);
  gtk_table_attach (GTK_TABLE (table6), label2, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label2), 0, 0.5);

  entry_login = gtk_entry_new ();
  gtk_widget_ref (entry_login);
  gtk_object_set_data_full (GTK_OBJECT (Add_Contact), "entry_login", entry_login,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_login);
  gtk_table_attach (GTK_TABLE (table6), entry_login, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  entry_alias = gtk_entry_new ();
  gtk_widget_ref (entry_alias);
  gtk_object_set_data_full (GTK_OBJECT (Add_Contact), "entry_alias", entry_alias,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_alias);
  gtk_table_attach (GTK_TABLE (table6), entry_alias, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  hbox3 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox3);
  gtk_object_set_data_full (GTK_OBJECT (Add_Contact), "hbox3", hbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox3);
  gtk_table_attach (GTK_TABLE (table6), hbox3, 0, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  checkbutton_auto_expand = gtk_check_button_new_with_label ("Auto expand");
  gtk_widget_ref (checkbutton_auto_expand);
  gtk_object_set_data_full (GTK_OBJECT (Add_Contact), "checkbutton_auto_expand", checkbutton_auto_expand,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_auto_expand);
  gtk_box_pack_start (GTK_BOX (hbox3), checkbutton_auto_expand, FALSE, FALSE, 0);

  checkbutton_alert_log_on = gtk_check_button_new_with_label ("Alert log on");
  gtk_widget_ref (checkbutton_alert_log_on);
  gtk_object_set_data_full (GTK_OBJECT (Add_Contact), "checkbutton_alert_log_on", checkbutton_alert_log_on,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_alert_log_on);
  gtk_box_pack_start (GTK_BOX (hbox3), checkbutton_alert_log_on, FALSE, FALSE, 0);

  hbox2 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox2);
  gtk_object_set_data_full (GTK_OBJECT (Add_Contact), "hbox2", hbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox2, FALSE, TRUE, 0);

  button_ok = gtk_button_new_with_label ("OK");
  gtk_widget_ref (button_ok);
  gtk_object_set_data_full (GTK_OBJECT (Add_Contact), "button_ok", button_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_ok);
  gtk_box_pack_start (GTK_BOX (hbox2), button_ok, FALSE, FALSE, 0);
  gtk_widget_set_usize (button_ok, 75, -2);

  button_cancel = gtk_button_new_with_label ("Cancel");
  gtk_widget_ref (button_cancel);
  gtk_object_set_data_full (GTK_OBJECT (Add_Contact), "button_cancel", button_cancel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_cancel);
  gtk_box_pack_start (GTK_BOX (hbox2), button_cancel, FALSE, FALSE, 0);
  gtk_widget_set_usize (button_cancel, 75, -2);

  gtk_signal_connect_object (GTK_OBJECT (button_ok), "clicked",
                             GTK_SIGNAL_FUNC (on_button_ok_clicked),
                             GTK_OBJECT (Add_Contact));
  gtk_signal_connect_object (GTK_OBJECT (button_cancel), "clicked",
                             GTK_SIGNAL_FUNC (on_button_cancel_clicked),
                             GTK_OBJECT (Add_Contact));
  gtk_signal_connect (GTK_OBJECT (Add_Contact), "destroy",
                      GTK_SIGNAL_FUNC (on_Add_Contact_destroy),
                      NULL);

  gtk_widget_grab_focus (entry_login);
  return Add_Contact;
}

static GtkWidget	*create_Add_Group(void)
{
  GtkWidget *vbox4;
  GtkWidget *frame2;
  GtkWidget *table7;
  GtkWidget *label3;
  GtkWidget *entry_group_name;
  GtkWidget *checkbutton_auto_expand;
  GtkWidget *hbox5;
  GtkWidget *button_ok;
  GtkWidget *button_cancel;

  Add_Group = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_object_set_data (GTK_OBJECT (Add_Group), "Add_Group", Add_Group);
  gtk_container_set_border_width (GTK_CONTAINER (Add_Group), 5);
  gtk_window_set_title (GTK_WINDOW (Add_Group), "Add group");
  gtk_window_set_position (GTK_WINDOW (Add_Group), GTK_WIN_POS_CENTER);
  gtk_window_set_modal (GTK_WINDOW (Add_Group), TRUE);
  gtk_window_set_policy (GTK_WINDOW (Add_Group), FALSE, FALSE, FALSE);

  vbox4 = gtk_vbox_new (FALSE, 5);
  gtk_widget_ref (vbox4);
  gtk_object_set_data_full (GTK_OBJECT (Add_Group), "vbox4", vbox4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox4);
  gtk_container_add (GTK_CONTAINER (Add_Group), vbox4);

  frame2 = gtk_frame_new ("Add group");
  gtk_widget_ref (frame2);
  gtk_object_set_data_full (GTK_OBJECT (Add_Group), "frame2", frame2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame2);
  gtk_box_pack_start (GTK_BOX (vbox4), frame2, TRUE, TRUE, 0);

  table7 = gtk_table_new (2, 2, FALSE);
  gtk_widget_ref (table7);
  gtk_object_set_data_full (GTK_OBJECT (Add_Group), "table7", table7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table7);
  gtk_container_add (GTK_CONTAINER (frame2), table7);
  gtk_container_set_border_width (GTK_CONTAINER (table7), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table7), 5);

  label3 = gtk_label_new ("Name : ");
  gtk_widget_ref (label3);
  gtk_object_set_data_full (GTK_OBJECT (Add_Group), "label3", label3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label3);
  gtk_table_attach (GTK_TABLE (table7), label3, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label3), 0, 0.5);

  entry_group_name = gtk_entry_new ();
  gtk_widget_ref (entry_group_name);
  gtk_object_set_data_full (GTK_OBJECT (Add_Group), "entry_group_name", entry_group_name,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_group_name);
  gtk_table_attach (GTK_TABLE (table7), entry_group_name, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  checkbutton_auto_expand = gtk_check_button_new_with_label ("Auto expand");
  gtk_widget_ref (checkbutton_auto_expand);
  gtk_object_set_data_full (GTK_OBJECT (Add_Group), "checkbutton_auto_expand", checkbutton_auto_expand,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_auto_expand);
  gtk_table_attach (GTK_TABLE (table7), checkbutton_auto_expand, 0, 2, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  hbox5 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox5);
  gtk_object_set_data_full (GTK_OBJECT (Add_Group), "hbox5", hbox5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox5);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox5, FALSE, TRUE, 0);

  button_ok = gtk_button_new_with_label ("OK");
  gtk_widget_ref (button_ok);
  gtk_object_set_data_full (GTK_OBJECT (Add_Group), "button_ok", button_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_ok);
  gtk_box_pack_start (GTK_BOX (hbox5), button_ok, FALSE, FALSE, 0);
  gtk_widget_set_usize (button_ok, 75, -2);

  button_cancel = gtk_button_new_with_label ("Cancel");
  gtk_widget_ref (button_cancel);
  gtk_object_set_data_full (GTK_OBJECT (Add_Group), "button_cancel", button_cancel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_cancel);
  gtk_box_pack_start (GTK_BOX (hbox5), button_cancel, FALSE, FALSE, 0);
  gtk_widget_set_usize (button_cancel, 75, -2);

  gtk_signal_connect_object (GTK_OBJECT (button_ok), "clicked",
                             GTK_SIGNAL_FUNC (on_button_ok_clicked),
                             GTK_OBJECT (Add_Group));
  gtk_signal_connect_object (GTK_OBJECT (button_cancel), "clicked",
                             GTK_SIGNAL_FUNC (on_button_cancel_clicked),
                             GTK_OBJECT (Add_Group));
  gtk_signal_connect (GTK_OBJECT (Add_Group), "destroy",
                      GTK_SIGNAL_FUNC (on_Add_Group_destroy),
                      NULL);

  gtk_widget_grab_focus (entry_group_name);
  return Add_Group;
}

