/*
** control_panel_load.c for  in /root/c/NoSoucy-0.2
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Wed May 21 06:26:44 2003 Anto
** Last update Sat May 17 20:36:56 2003 Anto
*/

#include <gtk/gtk.h>
#include "conf.h"
#include "control_panel.h"

void	ControlPanel_load(conf_t *conf)
{
  ControlPanel_setHost(conf->server_name);
  ControlPanel_setPort(conf->server_port);
  ControlPanel_setLogin(conf->login);
  ControlPanel_setPassword(conf->passwd);
  ControlPanel_setLocation(conf->location);
  ControlPanel_setUserData(conf->user_data);
  ControlPanel_setAttempt(conf->attempt_nbr);
  ControlPanel_setDelay(conf->attempt_delay);

  ControlPanel_setAutoAwayDelay(conf->away_delay);
  ControlPanel_setAutoAnswerList(conf->auto_msg);

  ControlPanel_setAspectWidth(conf->width);
  ControlPanel_setAspectHeight(conf->height);
  ControlPanel_setAspectX(conf->pos_x);
  ControlPanel_setAspectY(conf->pos_y);
  ControlPanel_setSkinFile(conf->skin);
}

/* CONNECTION PAGE - SET */
void	ControlPanel_setHost(char *host)
{
  gtk_entry_set_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_host")),
		     host);
}

void	ControlPanel_setPort(short port)
{
  char	str[10];

  snprintf(str, 10, "%i", port);
  gtk_entry_set_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_port")),
		     str);
}

void	ControlPanel_setLogin(char *login)
{
  gtk_entry_set_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_login")),
		     login);
}

void	ControlPanel_setPassword(char *passwd)
{
  gtk_entry_set_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_password")),
		     passwd);
}

void	ControlPanel_setLocation(char *location)
{
  gtk_entry_set_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_location")),
		     location);
}

void	ControlPanel_setUserData(char *user_data)
{
  gtk_entry_set_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_user_data")),
		     user_data);
}

void	ControlPanel_setAttempt(int attempt)
{
  char	str[10];
  
  snprintf(str, 10, "%i", attempt);
  gtk_entry_set_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_attempt")),
		     str);
}

void	ControlPanel_setDelay(int delay)
{
  char	str[10];

  snprintf(str, 10, "%i", delay);
  gtk_entry_set_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_delay")),
		     str);
}

/* CONNECTION PAGE - GET */
char	*ControlPanel_getHost()
{
  return (gtk_entry_get_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_host"))));
}

short	ControlPanel_getPort()
{
  return (atoi(gtk_entry_get_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_port")))));
}

char	*ControlPanel_getLogin()
{
  return (gtk_entry_get_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_login"))));
}

char	*ControlPanel_getPassword()
{
  return (gtk_entry_get_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_password"))));
}

char	*ControlPanel_getLocation()
{
  return (gtk_entry_get_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_location"))));
}

char	*ControlPanel_getUserData()
{
  return (gtk_entry_get_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_user_data"))));
}

int	ControlPanel_getAttempt()
{
  return (atoi(gtk_entry_get_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_attempt")))));
}

int	ControlPanel_getDelay()
{
  return (atoi(gtk_entry_get_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_delay")))));
}


/* AUTOMATION PAGE - SET */
void	ControlPanel_setAutoAwayDelay(int delay)
{
  char	str[10];
  
  snprintf(str, 10, "%i", delay);
  gtk_entry_set_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_auto_away_delay")),
		     str);
}

void		ControlPanel_setAutoAnswerList(list_t *msg)
{
  GList		*lst = NULL;
  GtkWidget	*item;

  while (msg)
    {
      lst = g_list_prepend(lst, item = gtk_list_item_new_with_label(msg->login));
      gtk_widget_show_all(item);
      msg = msg->next;
    }
  gtk_list_append_items(GTK_LIST(gtk_object_get_data(GTK_OBJECT(Control_Panel), "list_auto_answer")), 
			lst);
}

/* AUTOMATION PAGE - GET */
int	ControlPanel_getAutoAwayDelay()
{
  return (atoi(gtk_entry_get_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_auto_away_delay")))));
}

list_t		*ControlPanel_getAutoAnswerList()
{
  list_t	*last = NULL;
  GList		*glist = NULL;
  GtkWidget	*list;
  char		*item;

  list = gtk_object_get_data(GTK_OBJECT(Control_Panel), "list_auto_answer");
  glist = GTK_LIST(list)->children;
  while (glist)
    {
      item = GTK_LABEL(GTK_LIST_ITEM(glist->data)->item.bin.child)->label;
      put_in_list(&last, strdup(item));
      glist = g_list_next(glist);
    }
  return (last);
}


/* ASPECT PAGE - SET */
void	ControlPanel_setAspectWidth(int	width)
{
  char	str[10];

  snprintf(str, 10, "%i", width);
  gtk_entry_set_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_aspect_width")),
		     str);
}

void	ControlPanel_setAspectHeight(int height)
{
  char	str[10];

  snprintf(str, 10, "%i", height);
  gtk_entry_set_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_aspect_height")),
		     str);
}

void	ControlPanel_setAspectX(int x)
{
  char	str[10];

  snprintf(str, 10, "%i", x);
  gtk_entry_set_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_aspect_x")),
		     str);
}

void	ControlPanel_setAspectY(int y)
{
  char	str[10];

  snprintf(str, 10, "%i", y);
  gtk_entry_set_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_aspect_y")),
		     str);
}

void	ControlPanel_setSkinFile(char *skin_file)
{
  gtk_entry_set_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_skin_file")),
		     skin_file);
}

/* ASPECT PAGE - GET */
int	ControlPanel_getAspectWidth()
{
  return (atoi(gtk_entry_get_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_aspect_width")))));
}

int	ControlPanel_getAspectHeight()
{
  return (atoi(gtk_entry_get_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_aspect_height")))));
}

int	ControlPanel_getAspectX()
{
  return (atoi(gtk_entry_get_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_aspect_x")))));
}

int	ControlPanel_getAspectY()
{
  return (atoi(gtk_entry_get_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_aspect_y")))));
}

char	*ControlPanel_getSkinFile()
{
  return (gtk_entry_get_text(GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(Control_Panel), "entry_skin_file"))));
}
