/*
** skin.h for  in /home/dev/NoSoucy
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Sun May 18 15:11:20 2003 Anto
** Last update Sun Jan  4 12:44:21 2004 Anto
*/

#ifndef _SKIN_H_
#define _SKIN_H_

#include <gtk/gtk.h>

#define SKIN_NO_ICON		-1

/* state icon id */
#define SKIN_ONLINE		0
#define SKIN_AWAY		1
#define SKIN_LOCK		2
#define	SKIN_IDLE		3
#define	SKIN_CONNECTION		4
#define	SKIN_SERVER		5
#define SKIN_UNKNOWN		6
#define SKIN_OFFLINE		7
#define SKIN_MULTI		8
/* icon */
#define SKIN_PREFERENCES	9
#define SKIN_SEND_MESSAGE	10
#define SKIN_MAIL		11
#define SKIN_MAIL_ALERT		12
#define SKIN_MAIL_BIG		13
#define SKIN_MAIL_BIG_ALERT	14
#define SKIN_NO			15
#define SKIN_MESSAGE_DIALOG	16
#define SKIN_SCROLLBAR		17
#define	SKIN_ADD		18
#define	SKIN_ALERT		19
#define	SKIN_BLOCK		20
#define	SKIN_REMOVE		21
#define	SKIN_RENAME		22
#define	SKIN_SEND_FILE		23
#define	SKIN_SHOW_LOG		24
#define SKIN_CONNECT		25
#define SKIN_DISCONNECT		26
#define SKIN_NOSOUCY		27
#define SKIN_TYPING		28

#define SKIN_MAX_STATE		9
#define SKIN_MAX_ICON		29

#define SKIN_ACTIF_TOKEN	"actif"
#define SKIN_AWAY_TOKEN		"away"
#define SKIN_LOCK_TOKEN		"lock"
#define	SKIN_CONNECTION_TOKEN	"connection"
#define	SKIN_IDLE_TOKEN		"idle"
#define	SKIN_SERVER_TOKEN	"server"
#define SKIN_UNKNOWN_TOKEN	"unknown"
#define SKIN_OFFLINE_TOKEN	"offline"
#define SKIN_MULTI_TOKEN	"multi"
#define SKIN_GROUP_TOKEN	"group"

#define SKIN_PREFERENCES_TOKEN		"preferences"
#define SKIN_SEND_MESSAGE_TOKEN		"send_message"
#define SKIN_MAIL_TOKEN			"mail"
#define SKIN_MAIL_ALERT_TOKEN		"mail_alert"
#define SKIN_MAIL_BIG_TOKEN		"mail_big"
#define SKIN_MAIL_BIG_ALERT_TOKEN	"mail_big_alert"
#define SKIN_NO_TOKEN			"no"
#define SKIN_MESSAGE_DIALOG_TOKEN	"message_dialog"
#define SKIN_SCROLLBAR_TOKEN		"scrollbar"
#define SKIN_ADD_TOKEN			"add"
#define SKIN_ALERT_TOKEN		"alert"
#define SKIN_BLOCK_TOKEN		"block"
#define SKIN_REMOVE_TOKEN		"remove"
#define SKIN_RENAME_TOKEN		"rename"
#define SKIN_SEND_FILE_TOKEN		"send_file"
#define SKIN_SHOW_LOG_TOKEN		"show_log"
#define SKIN_CONNECT_TOKEN		"connect"
#define SKIN_DISCONNECT_TOKEN		"disconnect"
#define SKIN_NOSOUCY_TOKEN		"NoSoucy"
#define SKIN_TYPING_TOKEN		"typing"

typedef struct	pixmap_s
{
  const char	*token;
  char		*filename;
  char		**data;
  GdkPixmap	*pixmap;
  GdkBitmap	*mask;
}		pixmap_t;

typedef struct	skin_g_s
{
  char		*name;
  char		*font;
  char		*color;
}		skin_g_t;

typedef struct	skin_s
{
  skin_g_t	state[SKIN_MAX_STATE];
  skin_g_t	group;
  pixmap_t	icon[SKIN_MAX_ICON];
  char		*highlight_buddy_color;
  char		*highlight_group_color;
  char		*background_color;
  char		*path;
}		skin_t;

#define SKIN_DEFAULT_HIGHLIGHT_BUDDY_COLOR	"#8899BB"
#define SKIN_DEFAULT_HIGHLIGHT_GROUP_COLOR	"#687898"
#define SKIN_DEFAULT_BACKGROUND_COLOR		"#FFFFFF"

skin_t	*skinParseDoc(char *);
int	skinStateToId(char *);

extern skin_t	*skin;

#endif /* _SKIN_H_ */

