/*
** message_callback.c for  in /home/dev/NoSoucy-0.3
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Sun Aug 24 03:14:25 2003 Anto
** Last update Sun Jan  4 19:38:41 2004 Anto
*/

#include "url.h"
#include "list.h"
#include "netsoul.h"
#include "request.h"
#include "message.h"
#include "contacts.h"
#include "conf.h"
#include "skin.h"
#include <stdlib.h>
#include <gdk/gdkkeysyms.h>
#include <gdk/gdkprivate.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void		message_paint(GtkWidget *widget, GdkRectangle *area, gpointer data)
{
  GdkGC		*gc;
  int		i;
  int		width, height;
  GdkPixmap	*pixmap;
  message_t	*message;

  message = (message_t *)data;

  gdk_window_get_size(widget->window, &width, &height);
  pixmap = gdk_pixmap_new(widget->window, width, height, 
			  gdk_window_get_visual(widget->window)->depth);
  
  gc = gdk_gc_new(pixmap);
  /* TOP LEFT */
  gdk_draw_pixmap(pixmap, gc, skin->icon[SKIN_MESSAGE_DIALOG].pixmap, 0, 0, 0, 0, 28, 44);
  /* TOP */
  for (i = 0; i <= (width - 56) / 192; i++)
    gdk_draw_pixmap(pixmap, gc, skin->icon[SKIN_MESSAGE_DIALOG].pixmap,
		    29, 0, (i * 192) + 28, 0, 192, 44);
  /* TOP RIGHT */
  gdk_draw_pixmap(pixmap, gc, skin->icon[SKIN_MESSAGE_DIALOG].pixmap, 
		  222, 0, width - 28, 0, 28, 44);
  /* MIDDLE LEFT */
  for (i = 0; i <= (height - 114) / 15; i++)
    gdk_draw_pixmap(pixmap, gc, skin->icon[SKIN_MESSAGE_DIALOG].pixmap,
		    0, 45, 0, (i * 15) + 44, 6, 15);
  if (message->log.pict)
    {
      /* MIDDLE */
      for (i = 0; i <= (width - 66) / 182; i++)
	gdk_draw_pixmap(pixmap, gc, skin->icon[SKIN_MESSAGE_DIALOG].pixmap,
			7, 61, (i * 182) + 6, height - 70, 182, 5);
      /* BOTTOM LEFT */
      gdk_draw_pixmap(pixmap, gc, skin->icon[SKIN_MESSAGE_DIALOG].pixmap,
		      0, 61, 0, height - 70, 6, 70);
      /* BOTTOM */
      for (i = 0; i <= (width - 66) / 182; i++)
	gdk_draw_pixmap(pixmap, gc, skin->icon[SKIN_MESSAGE_DIALOG].pixmap,
			7, 101, (i * 182) + 6, height - 30, 182, 30);
      /* BOTTOM RIGHT */
      gdk_draw_pixmap(pixmap, gc, skin->icon[SKIN_MESSAGE_DIALOG].pixmap,
		      190, 61, width - 60, height - 70, 60, 70);
    }
  else
    {
      /* MIDDLE */
      for (i = 0; i <= (width - 11) / 237; i++)
	gdk_draw_pixmap(pixmap, gc, skin->icon[SKIN_MESSAGE_DIALOG].pixmap,
			7, 132, (i * 237) + 6, height - 70, 237, 5);
      /* BOTTOM LEFT */
      gdk_draw_pixmap(pixmap, gc, skin->icon[SKIN_MESSAGE_DIALOG].pixmap, 
		      0, 132, 0, height - 70, 6, 70);
      /* BOTTOM */
      for (i = 0; i <= (width - 11) / 237; i++)
	gdk_draw_pixmap(pixmap, gc, skin->icon[SKIN_MESSAGE_DIALOG].pixmap,
			7, 172, (i * 237) + 6, height - 30, 237, 30);
      /* BOTTOM RIGHT */
      gdk_draw_pixmap(pixmap, gc, skin->icon[SKIN_MESSAGE_DIALOG].pixmap,
		      245, 132, width - 5, height - 70, 5, 70);
      gdk_rgb_gc_set_foreground(gc, 0xFFFFFF);
      gdk_draw_rectangle(pixmap, gc, TRUE, width - 10, height - 65, 5, 35);
    }
  gdk_window_copy_area(widget->window, gc, 
		       area->x, area->y, pixmap, 
		       area->x, area->y, area->width, area->height);
  
  gdk_gc_destroy(gc);
  gdk_pixmap_unref(pixmap);
}

void	on_Message_button_draw(GtkWidget       *widget,
			       GdkRectangle    *area,
			       gpointer         user_data)
{
  GdkGC	*gc;
  int	x;
  int	decal;

  x = (int)user_data;
  gc = gdk_gc_new(widget->window);
  decal = GTK_WIDGET_STATE(widget) == GTK_STATE_NORMAL ? 0 : 19;
  gdk_draw_pixmap(widget->window, gc, skin->icon[SKIN_MESSAGE_DIALOG].pixmap,
		  area->x + x, area->y + 212 + decal, area->x, area->y, area->width, area->height);
  gdk_gc_destroy(gc);
}

gboolean	on_Message_button_expose_event(GtkWidget       *widget,
					       GdkEventExpose  *event,
					       gpointer         user_data)
{
  on_Message_button_draw(widget, &event->area, user_data);
  return FALSE;
}

void		on_Message_destroy(GtkWidget *widget, gpointer user_data)
{
  list_t	*item;
  message_t	*message;

  message = (message_t *)user_data;
  message_log_save(message->login, &message->log);
  if (!listFind(conf->buddy, message->login, contactsCmpBuddy))
    if ((item = listFind(netsoul->watchlog, message->login, strcmp)))
      {
	listRemoveItem(&netsoul->watchlog, item->data, free);
	request_watch_log(netsoul->watchlog);
      }
  listRemoveItem(&message_list, message, message_free);
}

gboolean	on_Message_delete_event(GtkWidget *widget,
					GdkEvent *event, gpointer user_data)
{
  message_t	*message;

  message = (message_t *)user_data;
  message->log.width = ((GdkWindowPrivate *)message->window->window)->width;
  message->log.height = ((GdkWindowPrivate *)message->window->window)->height;
  message->log.x = ((GdkWindowPrivate *)message->window->window)->x;
  message->log.y = ((GdkWindowPrivate *)message->window->window)->y;
  return (FALSE);
}

void	fake_draw_focus(GtkStyle	*style,
			GdkWindow	*window,
			GdkRectangle	*area,
			GtkWidget	*widget,
			gchar		*detail,
			gint		x,
			gint		y,
			gint		width,
			gint		height)
{
}

void	fake_draw_shadow(GtkStyle	*style,
			 GdkWindow	*window,
			 GtkStateType	state_type,
			 GtkShadowType	shadow_type,
			 GdkRectangle	*area,
			 GtkWidget	*widget,
			 gchar		*detail,
			 gint		x,
			 gint		y,
			 gint		width,
			 gint		height)
{
}

gboolean	on_Message_typing(GtkWidget *widget, GdkEventKey *event,
				  gpointer user_data)
{
  message_t	*message;
  GtkWidget	*lblTyping;
  GtkWidget	*txtSend;
  char		*txt;
  
  message = (message_t *)user_data;
  lblTyping = gtk_object_get_data(GTK_OBJECT(message->window), "lblTyping");
  txtSend = gtk_object_get_data(GTK_OBJECT(message->window), "txtSend");
  
  txt = gtk_editable_get_chars(&GTK_TEXT(txtSend)->editable, 0, -2);
  if (strlen(txt) > 0 && message->typing == FALSE)
    {
      message->typing = TRUE;
      request_cmd_typing(message->login, "start", message->id);
    }
  else if (!strlen(txt) && message->typing == TRUE)
    {
      message->typing = FALSE;
      request_cmd_typing(message->login, "end", message->id);
    }
  return (gtk_true());
}

gboolean	on_Message_key_press(GtkWidget *widget, GdkEventKey *event,
				     gpointer user_data)
{
  message_t	*message;
  GtkWidget	*txtSend;
  char		*txt;
  
  message = (message_t *)user_data;
  txtSend = gtk_object_get_data(GTK_OBJECT(message->window), "txtSend");
  if (GTK_WIDGET_HAS_FOCUS(txtSend))
    {
      if ((event->keyval == GDK_s && event->state & GDK_MOD1_MASK) ||
	  (event->keyval == GDK_Return && !(event->state & GDK_CONTROL_MASK)))
	{
	  txt = gtk_editable_get_chars(&GTK_TEXT(txtSend)->editable, 0, -2);
	  message_insert_out(message, txt);
	  gtk_text_set_point(GTK_TEXT(txtSend), strlen(txt));
	  gtk_text_backward_delete(GTK_TEXT(txtSend), strlen(txt));
	  gtk_signal_emit_stop_by_name(GTK_OBJECT(widget), "key-press-event");
	  message->typing = FALSE;
	  request_cmd_typing(message->login, "end", message->id);
	  request_cmd_msg(message->login, txt, message->id);
	}
      else if (event->keyval == GDK_Return && event->state & GDK_CONTROL_MASK)
	gtk_text_insert(GTK_TEXT(txtSend), NULL, NULL, NULL, "\n", 1);
    }
  if (event->keyval == GDK_Escape)
    gtk_widget_hide(message->window);
  return (gtk_true());
}

void	on_Message_show(GtkWidget *widget, gpointer user_data)
{
  message_t	*message;

  message = (message_t *)user_data;
  gdk_window_move_resize(message->window->window,
			 message->log.x, message->log.y,
			 message->log.width, message->log.height);
}

void		on_Message_hide(GtkWidget *widget, gpointer user_data)
{
  message_t	*message;

  message = (message_t *)user_data;
  message->log.width = ((GdkWindowPrivate *)message->window->window)->width;
  message->log.height = ((GdkWindowPrivate *)message->window->window)->height;
  message->log.x = ((GdkWindowPrivate *)message->window->window)->x;
  message->log.y = ((GdkWindowPrivate *)message->window->window)->y;
  message_log_save(message->login, &message->log);
  listFree(message->log.history, free);
  message->log.history = NULL;
}

void		on_message_history(GtkWidget *widget, gpointer user_data)
{
  message_t	*message;

  message = (message_t *)user_data;
  message_log_show(message->login, message->alias);
}

void		on_message_block(GtkWidget *widget, gpointer user_data)
{
  message_t	*message;
  list_t	*list;

  message = (message_t *)user_data;
  if ((list = listFind(conf->buddy, message->login, contactsCmpBuddy)))
    contacts_UIBlock(list->data);
  else
    {
      if ((list = listFind(conf->ignore, message->login, strcmp)))
	listRemoveItem(&conf->ignore, list->data, free);
      else
	putinlist(&conf->ignore, strdup(message->login));
    }
}

void		on_message_expand(GtkWidget *widget, gpointer user_data)
{
  message_t	*message;
  GtkWidget	*btnExpand;
  GtkWidget	*btnCollapse;
  GtkWidget	*pixmap;
  GtkWidget	*table;

  message = (message_t *)user_data;
  btnExpand = gtk_object_get_data(GTK_OBJECT(message->window), "btnExpand");
  btnCollapse = gtk_object_get_data(GTK_OBJECT(message->window), "btnCollapse");
  pixmap = gtk_object_get_data(GTK_OBJECT(message->window), "pixmap");
  table = gtk_object_get_data(GTK_OBJECT(message->window), "table");
  gtk_widget_show(btnCollapse);
  gtk_widget_hide(btnExpand);
  gtk_widget_show(pixmap);
  gtk_widget_queue_draw(table);
  message->log.pict ^= 1;
}

void		on_message_collapse(GtkWidget *widget, gpointer user_data)
{
  message_t	*message;
  GtkWidget	*btnExpand;
  GtkWidget	*btnCollapse;
  GtkWidget	*pixmap;
  GtkWidget	*table;

  message = (message_t *)user_data;
  btnExpand = gtk_object_get_data(GTK_OBJECT(message->window), "btnExpand");
  btnCollapse = gtk_object_get_data(GTK_OBJECT(message->window), "btnCollapse");
  pixmap = gtk_object_get_data(GTK_OBJECT(message->window), "pixmap");
  table = gtk_object_get_data(GTK_OBJECT(message->window), "table");
  gtk_widget_hide(btnCollapse);
  gtk_widget_show(btnExpand);  
  gtk_widget_hide(pixmap);
  gtk_widget_queue_draw(table);
  message->log.pict ^= 1;
}
