# Copyright 1999-2015 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Id$

EAPI=5
PYTHON_COMPAT=( python2_7 )

EGIT_REPO_URI="git://github.com/garbados/flask-browserid.git"

[[ ${PV} == 9999 ]] && SCM=git-r3

inherit distutils-r1 ${SCM}

MY_PN="Flask-BrowserID"
DESCRIPTION="Flask support for BrowserID authentication"
HOMEPAGE="http://pypi.python.org/pypi/Flask-BrowserID"

if [ ${PV} != 9999 ]; then
	SRC_URI="mirror://pypi/${MY_PN:0:1}/${MY_PN}/${MY_PN}-${PV}.tar.gz"
fi

LICENSE="MIT"
SLOT="0"
KEYWORDS="~amd64 ~x86"
IUSE="doc test"

S="${WORKDIR}/${MY_PN}-${PV}"

DEPEND="doc? ( dev-python/sphinx[${PYTHON_USEDEP}] ) "
RDEPEND=">=dev-python/flask-0.9[${PYTHON_USEDEP}]
		>=dev-python/flask-login-0.1.3[${PYTHON_USEDEP}]
		dev-python/requests[${PYTHON_USEDEP}]
		dev-python/setuptools[${PYTHON_USEDEP}]"

python_compile_all() {
	if use doc; then
		einfo "Generation of documentation"
		cd docs
		emake html || die "Generation of documentation failed"
	fi
}

python_install_all() {
	use doc && local HTML_DOCS=( doc/_build/html/. )

	distutils-r1_python_install_all
}

python_test() {
	esetup.py test
}
