/*
** skinedvbox.c for  in /home/dev/NoSoucy-0.3b
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Fri Dec 19 09:41:58 2003 Anto
** Last update Sun Jan  4 18:59:22 2004 Anto
*/

#include "skinedvbox.h"

static void	skined_vbox_init(SkinedVBox *);
static void	skined_vbox_class_init(SkinedVBoxClass *);
static void	skined_vbox_draw(GtkWidget *, GdkRectangle *);
static gint	skined_vbox_expose(GtkWidget *, GdkEventExpose *);

GtkType			skined_vbox_get_type(void)
{
  static GtkType	skined_vbox_type = 0;
  
  if (!skined_vbox_type)
    {
      static const GtkTypeInfo vbox_info =
	{
	  "SkinedVBox",
	  sizeof (SkinedVBox),
	  sizeof (SkinedVBoxClass),
	  (GtkClassInitFunc) skined_vbox_class_init,
	  (GtkObjectInitFunc) skined_vbox_init,
	  /* reserved_1 */ NULL,
	  /* reserved_2 */ NULL,
	  (GtkClassInitFunc) NULL,
	};
      skined_vbox_type = gtk_type_unique(GTK_TYPE_VBOX, &vbox_info);
    }
  return (skined_vbox_type);
}

static void		skined_vbox_class_init(SkinedVBoxClass *class)
{
  GtkWidgetClass	*widget_class;

  widget_class = (GtkWidgetClass *)class;
  widget_class->draw = skined_vbox_draw;
  widget_class->expose_event = skined_vbox_expose;
}

static void	skined_vbox_init(SkinedVBox *vbox)
{
  vbox->paint = NULL;
}

GtkWidget	*skined_vbox_new(gboolean homogeneous,
				 gint spacing,
				 void (*paint)(GtkWidget *, GdkRectangle *, gpointer),
				 gpointer data)
{
  SkinedVBox	*vbox;
  
  vbox = gtk_type_new(SKINED_TYPE_VBOX);
  vbox->paint = paint;
  vbox->user_data = data;

  GTK_BOX(vbox)->spacing = spacing;
  GTK_BOX(vbox)->homogeneous = homogeneous ? TRUE : FALSE;

  return GTK_WIDGET(vbox);
}

static void	skined_vbox_draw(GtkWidget *widget, GdkRectangle *area)
{
  GtkBox	*box;
  GtkBoxChild	*child;
  GdkRectangle	child_area;
  GList		*children;
     
  if (GTK_WIDGET_DRAWABLE(widget))
    {
      if (SKINED_VBOX(widget)->paint)
	SKINED_VBOX(widget)->paint(widget, area, SKINED_VBOX(widget)->user_data);
      box = GTK_BOX(widget);
      children = box->children;
      while (children)
	{
	  child = children->data;
	  children = children->next;
	  if (GTK_WIDGET_DRAWABLE(child->widget) &&
	      gtk_widget_intersect(child->widget, area, &child_area))
	    gtk_widget_draw(child->widget, &child_area);
	}
    }
}

static gint		skined_vbox_expose(GtkWidget *widget, GdkEventExpose *event)
{
  GtkBox		*box;
  GtkBoxChild		*child;
  GdkEventExpose	child_event;
  GList			*children;

  if (GTK_WIDGET_DRAWABLE(widget))
    {
      if (SKINED_VBOX(widget)->paint)
	SKINED_VBOX(widget)->paint(widget, &event->area, SKINED_VBOX(widget)->user_data);
      box = GTK_BOX(widget);
      child_event = *event;
      children = box->children;
      while (children)
	{
	  child = children->data;
	  children = children->next;
	  if (GTK_WIDGET_DRAWABLE(child->widget) &&
	      GTK_WIDGET_NO_WINDOW(child->widget) &&
	      gtk_widget_intersect(child->widget, &event->area, &child_event.area))
	    gtk_widget_event(child->widget, (GdkEvent*) &child_event);
	}
    }
  return (FALSE);
}
