/*
** netsoul.h for  in /home/dev/NoSoucy-0.3
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Mon May 19 07:35:33 2003 Anto
** Last update Sun Jan  4 21:58:29 2004 Anto
*/

#ifndef _NETSOUL_H_
#define _NETSOUL_H_

#include "list.h"

typedef	struct	ns_s
{
  int		type;
  int		sock;
  int		output;
  int		attempt;
  int		delay;
  int		time[3];
  char		*pass_set;
  /**/
  int		id;
  int		tag;
  list_t	*watchlog;
  list_t	*log;
}		ns_t;

#define NETSOUL_DISCONNECT	3

#define NETSOUL_TYPE_CONNECTING	42	
#define NETSOUL_TYPE_ATTEMPT	-1	
#define NETSOUL_TYPE_DISC	0	
#define NETSOUL_TYPE_INT	1
#define NETSOUL_TYPE_EXT	2
#define NETSOUL_TYPE_FINAL	3

#define	NETSOUL_CMD_SALUT_ARG	6
#define	NETSOUL_CMD_REP_ARG	2

#define	NETSOUL_CMD_LOGIN_ARG	11
#define	NETSOUL_CMD_LOGOUT_ARG	11
#define	NETSOUL_CMD_STATE_ARG	13

#define	NETSOUL_CMD_USER_ID	1
#define	NETSOUL_CMD_USER_LOGIN	4

/* CMD_MAIL */
#define	NETSOUL_CMD_MAIL_ARG		13
#define	NETSOUL_CMD_MAIL_FROM		10
#define	NETSOUL_CMD_MAIL_DOM		11
#define	NETSOUL_CMD_MAIL_SUBJECT	12

/* CMD_MSG */
#define	NETSOUL_CMD_MSG_ARG		12
#define	NETSOUL_CMD_MSG_ID		1
#define	NETSOUL_CMD_MSG_AUTH_USER	2
#define	NETSOUL_CMD_MSG_AUTH_AG		3
#define	NETSOUL_CMD_MSG_LOGIN		4
#define	NETSOUL_CMD_MSG_IP		5
#define	NETSOUL_CMD_MSG_MACH_FUNC	6
#define	NETSOUL_CMD_MSG_MACH_LOC	7
#define	NETSOUL_CMD_MSG_GROUP		8
#define	NETSOUL_CMD_MSG_MESSAGE		11

/* CMD_WHO */
#define	NETSOUL_CMD_WHO_INT_ARG		24
#define	NETSOUL_CMD_WHO_ARG		13
#define	NETSOUL_CMD_WHO_ID		0
#define	NETSOUL_CMD_WHO_LOGIN		1
#define	NETSOUL_CMD_WHO_IP		2
#define	NETSOUL_CMD_WHO_TIME_LOGIN	3
#define	NETSOUL_CMD_WHO_TIME_IDLE	4
#define	NETSOUL_CMD_WHO_AUTH_USER	5
#define	NETSOUL_CMD_WHO_AUTH_AG		6
#define	NETSOUL_CMD_WHO_MACH_FUNC	7
#define	NETSOUL_CMD_WHO_MACH_LOC	8
#define	NETSOUL_CMD_WHO_GROUP		9
#define	NETSOUL_CMD_WHO_STATE		10
#define	NETSOUL_CMD_WHO_TIME_STATE	11
#define	NETSOUL_CMD_WHO_USER_DATA	12

#define TIME_SERVER		0
#define TIME_CLIENT		1
#define TIME_DECAL		2

#define NETSOUL_LOG_LINE	200

void	netsoulNew();
void	netsoulFree();
int	netsoulConnect(void *);
void	netsoulConnected();
void	netsoulRestart(int);
void	netsoulInput(void *, int, int);
void	netsoulLog(const char *, ...);

extern ns_t	*netsoul;

#endif /* _NETSOUL_H_ */
