# Copyright 1999-2015 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Id$

EAPI=5

DESCRIPTION="An awesome Android emulator"
HOMEPAGE="http://www.genymotion.com"
SRC_URI="amd64? ( http://files2.genymotion.com/${PN}/${P}/${P}_x64.bin )
		 x86? ( http://files2.genymotion.com/${PN}/${P}/${P}_x86.bin )"

LICENSE="GENYMOTION"
SLOT="0"
KEYWORDS="~amd64 ~x86"
IUSE="system-qt"

inherit pax-utils

DEPEND=""
RDEPEND="|| ( app-emulation/virtualbox
		    app-emulation/virtualbox-bin )
		 system-qt? (
			=dev-qt/qtcore-4.8.5*
			=dev-qt/qtgui-4.8.5*
			=dev-qt/qtscript-4.8.5*
			=dev-qt/qtsql-4.8.5*
			=dev-qt/qtgui-4.8.5*
			=dev-qt/qtwebkit-4.8.5*
		 )"

		 # other dependencies
		 # libav protobuf qca

QA_PRESTRIPPED="
	/opt/genymotion/libQtSvg.so.4
	/opt/genymotion/genymotion
	/opt/genymotion/player
	/opt/genymotion/sqldrivers/libqsqlite.so
	/opt/genymotion/device-upgrade
	/opt/genymotion/libQtScript.so.4
	/opt/genymotion/libQtSql.so.4
	/opt/genymotion/libswscale.so.2
	/opt/genymotion/libavutil.so.51
	/opt/genymotion/libQtNetwork.so.4
	/opt/genymotion/lib64OpenglRender.so
	/opt/genymotion/imageformats/libqtga.so
	/opt/genymotion/imageformats/libqtiff.so
	/opt/genymotion/imageformats/libqico.so
	/opt/genymotion/imageformats/libqsvg.so
	/opt/genymotion/imageformats/libqjpeg.so
	/opt/genymotion/imageformats/libqgif.so
	/opt/genymotion/imageformats/libqmng.so
	/opt/genymotion/libQtGui.so.4
	/opt/genymotion/libQtWebKit.so.4
	/opt/genymotion/genymotion-tool
	/opt/genymotion/libQtCore.so.4
	/opt/genymotion/libQtXml.so.4
	/opt/genymotion/libqca.so.2
	/opt/genymotion/lib64GLES_CM_translator.so
	/opt/genymotion/genyshell
	/opt/genymotion/lib64GLES_V2_translator.so
	/opt/genymotion/plugins/libvboxmanage.so.1.0.0
	/opt/genymotion/lib64EGL_translator.so
	/opt/genymotion/crypto/libqca-ossl.so
	/opt/genymotion/tools/aapt
	/opt/genymotion/tools/adb "

src_unpack() {
	mkdir "${S}"
	skip=$(awk '/^__TARFILE_FOLLOWS__/ { print NR + 1; exit 0; }' "${DISTDIR}/${A}")
	tail -n +$skip "${DISTDIR}/${A}" | tar -xj -C "${S}"
}

src_install() {
	dodir "/opt/genymotion"
	if use system-qt ; then
		rm libQtCore.so.4 libQtGui.so.4 libQtNetwork.so.4 libQtScript.so.4 \
			libQtSql.so.4 libQtSvg.so.4 libQtWebKit.so.4 libQtXml.so.4
	fi
	cp -R "${S}/*" "${D}/opt/genymotion"
	pax-mark -m "${D}/opt/genymotion/genymotion"

	dodir "/opt/bin"
	dosym "/opt/genymotion/genymotion" "/opt/bin/genymotion"
	dosym "/opt/genymotion/genymotion-shell" "/opt/bin/genymotion-shell"
	dosym "/opt/genymotion/gmtool" "/opt/bin/gmtool"
}
