# Copyright 1999-2015 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: $

EAPI=5
PYTHON_COMPAT=( python2_7 )

inherit distutils-r1

DESCRIPTION="A Python implementation of JSON Web Token"
HOMEPAGE="http://pypi.python.org/pypi/PyJWT"
SRC_URI="mirror://pypi/${PN:0:1}/${PN}/${P}.tar.gz"

LICENSE="|| ( GPL-3 Apache-2.0 )"
SLOT="0"
KEYWORDS="~amd64 ~x86"
IUSE="test"

COMMON_DEPS="dev-python/setuptools[${PYTHON_USEDEP}]
	dev-python/requests[${PYTHON_USEDEP}]"

DEPEND="test? ( dev-python/nose[${PYTHON_USEDEP}] )
		${COMMON_DEPS}"
RDEPEND="${COMMON_DEPS}"

src_prepare() {
	epatch "${FILESDIR}/${PN}-fix-setup.patch"
}

python_test() {
	nosetests || die "Tests fail with ${EPYTHON}"
}
