# Copyright 2020 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

DESCRIPTION="The cluster manager from Hashicorp"
HOMEPAGE="http://nomadproject.io"

#RESTRICT="strip test"

LICENSE="MPL-2.0"
SLOT="0"
KEYWORDS="~amd64"
IUSE=""

DEPEND="dev-go/go-bindata dev-go/go-bindata-assetfs"
RDEPEND="${DEPEND}
		acct-group/nomad
		acct-user/nomad
		"
GO_DEPEND=">=dev-lang/go-1.14.1"
EGO_PN="github.com/hashicorp/${PN}"
EGO_VENDOR=(
	"github.com/kardianos/govendor e31350db9750308ce016ebef8350a8ff1e0a37d0"
)

inherit golang-vcs-snapshot golang-build

SRC_URI="https://github.com/hashicorp/${PN}/archive/v${PV}.tar.gz -> ${P}.tar.gz
		$EGO_VENDOR_URI"

src_compile() {
	ego_pn_check
	# for now disable nvidia support
	GOPATH="${WORKDIR}/${P}:$(get_golibdir_gopath)" \
	GO_TAGS="nonvidia ui release" \
	emake -C "${S}/src/${EGO_PN}" "pkg/linux_amd64/${PN}"
}

src_install() {
	dobin "${S}/src/${EGO_PN}/pkg/linux_amd64/${PN}"

	local x
	for x in /var/{lib,log}/${PN}; do
		keepdir "${x}"
		fowners ${PN}:${PN} "${x}"
	done
	keepdir "/etc/nomad.d/"

	newinitd "${FILESDIR}/${PN}.initd" "${PN}"
	newconfd "${FILESDIR}/${PN}.confd" "${PN}"
}
