# Copyright 1999-2016 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Id$

EAPI=6

DESCRIPTION="An awesome Android emulator"
HOMEPAGE="http://www.genymotion.com"
SRC_URI="https://dl.genymotion.com/releases/${P}/${P}-linux_x64.bin"

LICENSE="GENYMOTION"
SLOT="0"
KEYWORDS="~amd64"
IUSE="unbundled-libs"

inherit pax-utils

DEPEND=""
# note if you compile protobuf with >=gcc-5.1 you need to disable the new c++11 abi
# -D_GLIBCXX_USE_CXX11_ABI=0  to your CXXFLAGS for protobuf
RDEPEND="|| ( app-emulation/virtualbox
		    app-emulation/virtualbox-bin )
		 unbundled-libs? (
		 	dev-libs/openssl:0
			dev-qt/qtcore:5[icu]
			dev-qt/qtgui:5
			dev-qt/qtnetwork:5
			dev-qt/qtopengl:5
			dev-qt/qtprintsupport:5
			dev-qt/qtquickcontrols:5
			dev-qt/qtsql:5
			dev-qt/qtsvg:5
			dev-qt/qtwebkit:5
			dev-qt/qtwebsockets:5
			dev-qt/qtwidgets:5
			dev-qt/qtx11extras:5
			dev-qt/qtgraphicaleffects:5
		 	=dev-libs/protobuf-2.6*
		 )"

# don't unbundle libav to avoid downgrade
#		 	media-video/libav:0/9

QA_PRESTRIPPED="
	/opt/genymotion/device-upgrade
	/opt/genymotion/genymotion
	/opt/genymotion/genymotion-tool
	/opt/genymotion/genymotionadbtunneld
	/opt/genymotion/genyshell
	/opt/genymotion/gmtool
	/opt/genymotion/imageformats/libqsvg.so
	/opt/genymotion/imageformats/libqgif.so
	/opt/genymotion/imageformats/libqjpeg.so
	/opt/genymotion/lib64EGL_translator.so
	/opt/genymotion/lib64GLES_CM_translator.so
	/opt/genymotion/lib64GLES_V2_translator.so
	/opt/genymotion/lib64OpenglRender.so
	/opt/genymotion/libavutil.so.51
	/opt/genymotion/libcrypto.so.1.0.0
	/opt/genymotion/libicudata.so.53
	/opt/genymotion/libicui18n.so.53
	/opt/genymotion/libicuuc.so.53
	/opt/genymotion/libminicrypt.so.1.0.0
	/opt/genymotion/libprotobuf.so.9
	/opt/genymotion/libQt5Concurrent.so.5
	/opt/genymotion/libQt5Core.so.5
	/opt/genymotion/libQt5DBus.so.5
	/opt/genymotion/libQt5Gui.so.5
	/opt/genymotion/libQt5Network.so.5
	/opt/genymotion/libQt5OpenGL.so.5
	/opt/genymotion/libQt5PrintSupport.so.5
	/opt/genymotion/libQt5Qml.so.5
	/opt/genymotion/libQt5Quick.so.5
	/opt/genymotion/libQt5Sql.so.5
	/opt/genymotion/libQt5Svg.so.5
	/opt/genymotion/libQt5WebKit.so.5
	/opt/genymotion/libQt5WebKitWidgets.so.5
	/opt/genymotion/libQt5Widgets.so.5
	/opt/genymotion/libswscale.so.2
	/opt/genymotion/platforms/libqxcb.so
	/opt/genymotion/player
	/opt/genymotion/plugins/libvboxmanage.so.1.0.0
	/opt/genymotion/sqldrivers/libqsqlite.so
	/opt/genymotion/tools/aapt
	/opt/genymotion/tools/adb
	/opt/genymotion/tools/glewinfo "

EMBEDDED_LIBS="
			   libharfbuzz.so.0
			   libXrender.so.1
			   libXcomposite.so.1
			   libxslt.so.1
			   libxml2.so.2
			   libsqlite3.so.0
			   libfreetype.so.6
			   libgraphite2.so.3
			   libexpat.so.1
			   libxcb-dri3.so.0
			   libxcb-present.so.0
			   libxcb-sync.so.1
			   libxshmfence.so.1
			   libglapi.so.0
			   libXext.so.6
			   libXdamage.so.1
			   libXfixes.so.3
			   libX11-xcb.so.1
			   libxcb.so.1
			   libxcb-glx.so.0
			   libxcb-dri2.so.0
			   libXxf86vm.so.1
			   libdrm.so.2
			   libicuuc.so.52
			   libpng12.so.0
			   libXau.so.6
			   libXdmcp.so.6
			   libicudata.so.52
			   libQt5WebKitWidgets.so.5
			   libQt5WebSockets.so.5
			   libQt5Concurrent.so.5
			   libQt5Svg.so.5
			   libQt5Gui.so.5
			   libQt5Core.so.5
			   libQt5Network.so.5
			   libQt5Widgets.so.5
			   libQt5Sql.so.5
			   libQt5WebKit.so.5
			   libQt5X11Extras.so.5
			   libQt5PrintSupport.so.5
			   libQt5OpenGL.so.5
			   libQt5Quick.so.5
			   libQt5Qml.so.5
			   libQt5DBus.so.5
			   libjpeg.so.8
			   libicui18n.so.52
			   libgstreamer-1.0.so.0
			   libgstapp-1.0.so.0
			   libgstbase-1.0.so.0
			   libgstpbutils-1.0.so.0
			   libgstvideo-1.0.so.0
			   libgstaudio-1.0.so.0
			   libffi.so.6
			   liborc-0.4.so.0
			   libgsttag-1.0.so.0
			   libdouble-conversion.so.1
			   libXi.so.6
			   libxcb-render-util.so.0
			   libSM.so.6
			   libICE.so.6
			   libxcb-render.so.0
			   libxcb-image.so.0
			   libxcb-icccm.so.4
			   libxcb-xfixes.so.0
			   libxcb-shm.so.0
			   libxcb-randr.so.0
			   libxcb-shape.so.0
			   libxcb-keysyms.so.1
			   libxcb-xkb.so.1
			   libxkbcommon-x11.so.0
			   libxkbcommon.so.0
			   libfontconfig.so.1
			   libuuid.so.1
			   libxcb-util.so.0
			   libssl.so.1.0.0
			   libcrypto.so.1.0.0
			   libpcre.so.3
			   libdbus-1.so.3
			   libprotobuf.so.9
"
# don't unbundle libav
#			   libavutil.so.51
#			   libswscale.so.2

src_unpack() {
	mkdir "${S}"
	skip=$(awk '/^__TARFILE_FOLLOWS__/ { print NR + 1; exit 0; }' "${DISTDIR}/${A}")
	tail -n +$skip "${DISTDIR}/${A}" | tar -xj -C "${S}"
}

src_install() {
	dodir "/opt/genymotion"
	if use unbundled-libs ; then
		rm -r sqldrivers || die
		rm -r platforms || die
		rm -r QtGraphicalEffects || die
		rm -r QtQuick || die
		rm -r QtQuick.2 || die
		# should be deleted and use the system one provided by qtsvg
		# but it does not work
		# rm -r imageformats || die
		# delete all other qt dependencies
		rm $EMBEDDED_LIBS || die
		rm qt.conf || die
	fi

	cp -R "${S}"/* "${D}opt/genymotion"
	pax-mark -m "${D}opt/genymotion/genymotion"
	pax-mark -m "${D}opt/genymotion/gmtool"

	dodir "/opt/bin"
	dosym "/opt/genymotion/genymotion" "/opt/bin/genymotion"
	dosym "/opt/genymotion/genymotion-shell" "/opt/bin/genymotion-shell"
	dosym "/opt/genymotion/gmtool" "/opt/bin/gmtool"
}
