/*
** env.c for  in /home/dev/NoSoucy-0.3
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Wed May 21 16:02:37 2003 Anto
** Last update Thu Mar 11 15:56:40 2004 Anto
*/

#include "env.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <pwd.h>
#include <fcntl.h>
#include <sys/stat.h>

static int	env_test_file_dir(char *);

env_t	*env = NULL;

env_t		*envNew()
{
  struct passwd	*user;

  env = calloc(1, sizeof(env_t));
  if ((user = getpwuid(getuid())))
    {
      env->login = strdup(user->pw_name);
      env->homedir = strdup(user->pw_dir);
    }
  else
    {
      char	*str;

      if (!(str = getenv("LOGNAME")))
	str = DEFAULT_ENV_LOGIN;
      env->login = strdup(str);
      if (!(str = getenv("HOME")))
	str = DEFAULT_ENV_HOMEDIR;
      env->homedir = strdup(str);
    }
  asprintf(&env->NoSoucy, "%s/"DEFAULT_ENV_NOSOUCY, env->homedir);
  asprintf(&env->conf, "%s/"DEFAULT_ENV_NOSOUCY"/"DEFAULT_ENV_CONF, env->homedir);
  asprintf(&env->cache, "%s/"DEFAULT_ENV_NOSOUCY"/"DEFAULT_ENV_CACHE, env->homedir);
  asprintf(&env->log, "%s/"DEFAULT_ENV_NOSOUCY"/"DEFAULT_ENV_LOG, env->homedir);
  asprintf(&env->ns, "%s/"DEFAULT_ENV_NS"/", env->homedir);
  asprintf(&env->ns_link, "%s/"DEFAULT_ENV_NS"/%s", env->homedir, getenv("NS_USER_LINK"));

  env_test_file_dir(env->NoSoucy);
  env_test_file_dir(env->cache);
  env_test_file_dir(env->log);

  return (env);
}

static int	env_test_file_dir(char *name)
{
  struct stat	sb;
  int		re;

  if (stat(name, &sb) == -1)
    if ((re = mkdir(name, 0700)) == -1)
      perror("NoSoucy: env");
  return (re);
}

void	envFree()
{
  if (!env)
    return ;
  free(env->login);
  free(env->homedir);
  free(env->NoSoucy);
  free(env->log);
  free(env->cache);
  free(env->conf);
  free(env);
  env = NULL;
}
