# Copyright 1999-2016 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Id$

EAPI=5

DESCRIPTION="An awesome Android emulator"
HOMEPAGE="http://www.genymotion.com"
SRC_URI="amd64? ( http://files2.genymotion.com/${PN}/${P}/${P}-linux_x64.bin )
		 x86? ( http://files2.genymotion.com/${PN}/${P}/${P}-linux_x86.bin )"

LICENSE="GENYMOTION"
SLOT="0"
KEYWORDS="~amd64 ~x86"
IUSE="system-qt"

inherit pax-utils

DEPEND=""
RDEPEND="|| ( app-emulation/virtualbox
		    app-emulation/virtualbox-bin )
		 dev-libs/openssl:0
		 =dev-libs/protobuf-2.4.1
		 media-video/libav
		 system-qt? (
			dev-qt/qtcore:5[icu]
			dev-qt/qtgui:5
			dev-qt/qtnetwork:5
			dev-qt/qtopengl:5
			dev-qt/qtpositioning:5
			dev-qt/qtprintsupport:5
			dev-qt/qtquickcontrols:5
			dev-qt/qtscript:5
			dev-qt/qtsensors:5
			dev-qt/qtsql:5
			dev-qt/qtsvg:5
			dev-qt/qtwebchannel:5
			dev-qt/qtwebkit:5
			dev-qt/qtwidgets:5
		 )"

		 # other dependencies
		 # libav

QA_PRESTRIPPED="
	/opt/genymotion/device-upgrade
	/opt/genymotion/genymotion
	/opt/genymotion/genymotion-tool
	/opt/genymotion/genyshell
	/opt/genymotion/gmtool
	/opt/genymotion/imageformats/libqsvg.so
	/opt/genymotion/lib64EGL_translator.so
	/opt/genymotion/lib64GLES_CM_translator.so
	/opt/genymotion/lib64GLES_V2_translator.so
	/opt/genymotion/lib64OpenglRender.so
	/opt/genymotion/libavutil.so.51
	/opt/genymotion/libcrypto.so.1.0.0
	/opt/genymotion/libicudata.so.53
	/opt/genymotion/libicui18n.so.53
	/opt/genymotion/libicuuc.so.53
	/opt/genymotion/libminicrypt.so.1.0.0
	/opt/genymotion/libprotobuf.so.7
	/opt/genymotion/libQt5Concurrent.so.5
	/opt/genymotion/libQt5Core.so.5
	/opt/genymotion/libQt5DBus.so.5
	/opt/genymotion/libQt5Gui.so.5
	/opt/genymotion/libQt5Multimedia.so.5
	/opt/genymotion/libQt5MultimediaWidgets.so.5
	/opt/genymotion/libQt5Network.so.5
	/opt/genymotion/libQt5OpenGL.so.5
	/opt/genymotion/libQt5Positioning.so.5
	/opt/genymotion/libQt5PrintSupport.so.5
	/opt/genymotion/libQt5Qml.so.5
	/opt/genymotion/libQt5Quick.so.5
	/opt/genymotion/libQt5Script.so.5
	/opt/genymotion/libQt5Sensors.so.5
	/opt/genymotion/libQt5Sql.so.5
	/opt/genymotion/libQt5Svg.so.5
	/opt/genymotion/libQt5WebChannel.so.5
	/opt/genymotion/libQt5WebKit.so.5
	/opt/genymotion/libQt5WebKitWidgets.so.5
	/opt/genymotion/libQt5Widgets.so.5
	/opt/genymotion/libswscale.so.2
	/opt/genymotion/platforms/libqxcb.so
	/opt/genymotion/player
	/opt/genymotion/plugins/libvboxmanage.so.1.0.0
	/opt/genymotion/sqldrivers/libqsqlite.so
	/opt/genymotion/tools/aapt
	/opt/genymotion/tools/adb
	/opt/genymotion/tools/glewinfo "

src_unpack() {
	mkdir "${S}"
	skip=$(awk '/^__TARFILE_FOLLOWS__/ { print NR + 1; exit 0; }' "${DISTDIR}/${A}")
	tail -n +$skip "${DISTDIR}/${A}" | tar -xj -C "${S}"
}

src_install() {
	dodir "/opt/genymotion"
	if use system-qt ; then
		rm libQt5*.so.5 || die
		rm -r sqldrivers || die
		# should be deleted and use the system one provided by qtsvg
		# but it does not work
		#rm -r imageformats || die
	fi

	# use system ssl
	rm libssl.so.1.0.0 libcrypto.so.1.0.0 || die

	cp -R "${S}"/* "${D}opt/genymotion"
	pax-mark -m "${D}opt/genymotion/genymotion"
	pax-mark -m "${D}opt/genymotion/gmtool"

	dodir "/opt/bin"
	dosym "/opt/genymotion/genymotion" "/opt/bin/genymotion"
	dosym "/opt/genymotion/genymotion-shell" "/opt/bin/genymotion-shell"
	dosym "/opt/genymotion/gmtool" "/opt/bin/gmtool"
}
