/*
** netsoul_connect.c for  in /home/dev/NoSoucy-0.3
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Wed May 21 17:22:03 2003 Anto
** Last update Thu Apr 22 14:09:18 2004 Anto
*/

#include "netsoul.h"
#include "conf.h"
#include "env.h"
#include "skin.h"
#include "NoSoucy.h"
#include "request.h"
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#ifdef MIN
#	undef MIN
#endif
#ifdef MAX
#	undef MAX
#endif
#include <arpa/inet.h>
#include <netdb.h>
#include <fcntl.h>
#include <unistd.h>
#include <time.h>
#include <sys/un.h>
#include <sys/param.h>
#include <stdlib.h>

#ifndef __DEV
static int	connect_intern()
{
  struct sockaddr_un	sun;
  int			sock;
  char			cwd[MAXPATHLEN];
  char			realns[MAXPATHLEN];

  getcwd(cwd, MAXPATHLEN);
  realpath(env->ns, realns);
  if (cwd && realns && !strcmp(cwd, realns))
    return (0);
  sun.sun_family = AF_LOCAL;
  strcpy(sun.sun_path, env->ns_link);
  if ((sock = socket(PF_LOCAL, SOCK_STREAM, 0)) == -1)
    return (-1);
  if (connect(sock, (const struct sockaddr *)&sun, sizeof(sun)) == -1)
    return (-1);
  return (sock);
}

static int		connect_extern()
{
  struct sockaddr_in	addr;
  struct hostent	*ipserv;
  int			sock;

  addr.sin_family = PF_INET;
  addr.sin_port = htons(conf->port);
  if (!(ipserv = gethostbyname(conf->host)))
    return (-1);
  addr.sin_addr.s_addr =
    inet_addr(inet_ntoa(*((struct in_addr *)ipserv->h_addr)));  
  if ((sock = socket(PF_INET, SOCK_STREAM, 0)) == -1)
    return (-1);
  if (connect(sock, (const struct sockaddr *)&addr,
	      sizeof (struct sockaddr)) == -1)
    return (-1);
  return (sock);
}
#endif

int	netsoulConnect(void *data)
{
#ifndef __DEV
  if (netsoul->attempt > conf->attempt)
    {
      netsoul->attempt = 1;
      netsoul->delay = conf->delay;
      netsoulLog("[info] : Connection Failed\n");
      netsoul->type = NETSOUL_TYPE_DISC;
      return (FALSE);
    }
  if (netsoul->delay > 0)
    {
      netsoul->type = NETSOUL_TYPE_ATTEMPT;
      netsoulLog("[info] : Attempt %d, connect in %d sec\n", netsoul->attempt, netsoul->delay);
      netsoul->delay--;
      return (TRUE);
    }
  netsoulLog("[info] : Connecting ...\n");
  netsoul->attempt++;
  netsoul->delay = conf->delay;
  netsoul->type = NETSOUL_TYPE_CONNECTING;
  /* connection */
  if ((netsoul->output = netsoul->sock = connect_intern()) != -1)
    {
      if (!netsoul->sock)
	netsoul->output = 1;
      netsoul->type = NETSOUL_TYPE_INT;
      netsoulConnected();
      netsoulLog("[info] : Your are logged in intern\n");
    }
  else if ((netsoul->output = netsoul->sock = connect_extern()) == -1)
    return (TRUE);
#else
  netsoul->type = NETSOUL_TYPE_EXT;
  netsoul->output = 1;
  netsoul->sock = 0;
  netsoulLog("[info] : Connecting for dev ...\n");
  netsoulConnected();
#endif
  netsoul->tag = NoSoucy_UIAddInput(netsoul->sock, (GdkInputFunction)netsoulInput);
  return (FALSE);
}

void	netsoulConnected()
{
  if (netsoul->type == NETSOUL_TYPE_EXT)
    request_state(SKIN_ACTIF_TOKEN, time(NULL));
  NoSoucy_UISetState(SKIN_ACTIF_TOKEN);
  request_cmd_user_data(conf->user_data);
  request_watch_log(netsoul->watchlog);
  request_cmd_who_list(netsoul->watchlog);
  NoSoucy_UIAddTimer(1000 * 120, request_ping);
}

void	netsoulRestart(int restart)
{
  if (netsoul->type > NETSOUL_TYPE_DISC)
    NoSoucy_UIRemoveInput(netsoul->tag);
#ifndef __DEV
  if (netsoul->type != NETSOUL_TYPE_INT && netsoul->sock != -1)
    close(netsoul->sock);
#endif
  netsoul->type = NETSOUL_TYPE_DISC;
  netsoul->sock = -1;
  if (restart == TRUE)
    netsoul->attempt = 1;
  NoSoucy_UISetState(SKIN_OFFLINE_TOKEN);
  if (restart == NETSOUL_DISCONNECT)
    netsoul->attempt = conf->attempt + 1;
  else
    NoSoucy_UIAddTimer(1000, netsoulConnect);
}
