/*
** photo.c for  in /root/c/NoSoucy-0.2
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Sat Mar 29 17:52:59 2003 Anto
** Last update Sun Jan  4 16:44:23 2004 Anto
*/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define TRUE	1
#define FALSE	0

static int		photo_connect(char *login)
{
  struct sockaddr_in	addr;
  struct hostent	*ipserv;
  int			sock;
  char			*req;

  addr.sin_family = PF_INET;
  addr.sin_port = htons(80);
  if (!(ipserv = gethostbyname("www.epitech.net")))
    return (-1);
  addr.sin_addr.s_addr = 
    inet_addr(inet_ntoa(*((struct in_addr *)ipserv->h_addr)));
  if ((sock = socket(PF_INET, SOCK_STREAM, 0)) == -1)
    return (-1);
  if (connect(sock, (const struct sockaddr *)&addr,
	      sizeof (struct sockaddr)) == -1)
    return (-1);
  asprintf(&req, "GET /intra/photo.php?login=%s HTTP/1.0\n\n", login);
  write(sock, req, strlen(req));
  free(req);
  return (sock);
}

static int	photo_receive(int sock, char *path)
{
  unsigned char	buff[1024];
  int		fd;
  int		br, bn;
  int		size;
  
  if ((fd = open(path, O_WRONLY | O_CREAT | O_TRUNC, 0600)) == -1)
    return (FALSE);
  br = bn = 0;
  while (42)
    {
      if (!read(sock, buff, 1))
	break ;
      if (buff[0] == '\r')
	br = (buff[0] == '\r' && !bn);
      else if (buff[0] == '\n')
	bn = (buff[0] == '\n' && br);
      else
	bn = br = 0;
      if (!bn && buff[0] == '\n')
	{
	  while ((size = read(sock, buff, 1024)))
	    write(fd, buff, size);
	  break ;
	}
    }
  lseek(fd, 0, SEEK_SET);
  if (!lseek(fd, 0, SEEK_END))
    {
      close(fd);
      remove(path);
      return (FALSE);
    }
  close(fd);
  return (TRUE);
}

static int	photo_exist(char *path)
{
  int		fd;

  if ((fd = open(path, O_RDONLY)) == -1)
    return (FALSE);
  close(fd);
  return (TRUE);
}

int			photo_get(char *login, char *path)
{
  int			ret;
  int			sock;
  fd_set		fdset;	
  struct timeval	tv;
  
  if (photo_exist(path))
    return (TRUE);
  if ((sock = photo_connect(login)) == -1)
    return (FALSE);
  tv.tv_sec = 5;
  tv.tv_usec = 0;
  FD_ZERO(&fdset);
  FD_SET(sock, &fdset);
  ret = select(sock + 1, &fdset, NULL, NULL, &tv);
  if (ret > 0 && FD_ISSET(sock, &fdset))
    ret = photo_receive(sock, path);
  close(sock);
  return (ret > 0);
}

