/*
** mail.c for  in /home/dev/NoSoucy-0.3
** 
** Made by Anto
** Login   <root@epita.fr>
** 
** Started on  Wed Jul 23 12:17:11 2003 Anto
** Last update Thu Jul 31 13:17:13 2003 Anto
*/

#include <gtk/gtk.h>
#include <gdk/gdkprivate.h>
#include <stdlib.h>
#include <string.h>
#include "mail.h"
#include "NoSoucy.h"
#include "skin.h"
#include "list.h"
#include "utils.h"

static GtkWidget	*create_mail(const char *, const char *);
static GdkBitmap	*create_mask_window(GdkWindow *, pixmap_t *);
static gboolean		on_mail_button_release_event(GtkWidget *, GdkEventButton *, gpointer);
static gint		mail_timeout(gpointer);
static void		mail_set_pos_and_size(mail_t *, const char *, const char *);

static list_t	*mail_list = NULL;

void		mail_new(const char *from, const char *subject)
{
  mail_t	*mail;
  
  mail = calloc(1, sizeof(mail_t));
  mail->state = 0;
  mail->timeout_tag = -1;
  mail->window = create_mail(from, subject);
  mail_set_pos_and_size(mail, from, subject);
  gtk_widget_realize(mail->window);
  gdk_window_set_override_redirect(mail->window->window, TRUE);
  mail->mask = create_mask_window(mail->window->window, &skin->icon[SKIN_MAIL_BIG]);
  mail->mask_alert = create_mask_window(mail->window->window, &skin->icon[SKIN_MAIL_BIG_ALERT]);
  gdk_window_shape_combine_mask(mail->window->window, mail->mask, 0, 0);
  gtk_signal_connect(GTK_OBJECT(gtk_object_get_data(GTK_OBJECT(mail->window), "eventbox")), 
		     "button_release_event",
		     GTK_SIGNAL_FUNC(on_mail_button_release_event), mail);
  mail->timeout_tag = gtk_timeout_add(MAIL_ALERT_TIMEOUT, mail_timeout, mail);
  gtk_widget_show(mail->window);
  putinlist(&mail_list, mail);
}

static void	mail_set_pos_and_size(mail_t *mail, const char *from, const char *subject)
{
  int		from_width;
  int		subject_width;
  list_t	*list;
  int		pos_x = 0;

  from_width = gdk_string_width(mail->window->style->font, from);
  subject_width = gdk_string_width(mail->window->style->font, subject);
  mail->width = (from_width > subject_width ? from_width : subject_width) + 65;
  mail->width += mail->width % 2;
  gtk_widget_set_usize(mail->window, mail->width, -2);  
  for (list = mail_list; list; list = list->next)
    pos_x += ((mail_t *)list->data)->width + 3;
  gtk_widget_set_uposition(mail->window, pos_x, 0);
}

static GdkBitmap	*create_mask_window(GdkWindow *mail_window, pixmap_t *pixmap)
{
  GdkGC			*gc;
  GdkBitmap		*mask;
  GdkColor		mask_pattern;
  int			window_width;
  int			window_height;
  int			pixmap_width;
  int			pixmap_height;

  window_width = ((GdkWindowPrivate *)mail_window)->width;
  window_height = ((GdkWindowPrivate *)mail_window)->height;
  pixmap_width = ((GdkPixmapPrivate *)pixmap->pixmap)->width;
  pixmap_height = ((GdkPixmapPrivate *)pixmap->pixmap)->height;

  mask = gdk_pixmap_new(mail_window, window_width, window_height, 1);
  gdk_bitmap_ref(mask);
  gc = gdk_gc_new(mask);

  mask_pattern.pixel = 0;
  gdk_gc_set_foreground(gc, &mask_pattern);
  gdk_draw_rectangle(mask, gc, TRUE, 0, 0, -1, -1);
  mask_pattern.pixel = 1;
  gdk_gc_set_foreground(gc, &mask_pattern);

  gdk_draw_pixmap(mask, gc, pixmap->mask, 
		  0, 0, 
		  (window_width - pixmap_width) / 2, 2, 
		  pixmap_width, pixmap_height);

  gdk_draw_rectangle(mask, gc, TRUE, 0, 52, window_width, window_height - 52);

  gdk_gc_destroy(gc);
  return (mask);
}

static GtkWidget	*create_mail(const char *from, const char *subject)
{
  GtkWidget		*mail;
  GtkWidget		*vbox14;
  GtkWidget		*xpmMail;
  GtkWidget		*table13;
  GtkWidget		*labelsubject;
  GtkWidget		*lblFrom;
  GtkWidget		*lblSubject;
  GtkWidget		*labelfrom;
  GtkWidget		*eventbox;

  mail = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_object_set_data (GTK_OBJECT (mail), "mail", mail);
  gtk_widget_set_usize (mail, -2, 84);
  gtk_window_set_title (GTK_WINDOW (mail), "Mail alert");
  gtk_window_set_policy (GTK_WINDOW (mail), FALSE, FALSE, FALSE);
  utils_setBackground(mail, MAIL_INFO_BACKGROUND);

  vbox14 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox14);
  gtk_object_set_data_full (GTK_OBJECT (mail), "vbox14", vbox14,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox14);
  gtk_container_add (GTK_CONTAINER (mail), vbox14);

  eventbox = gtk_event_box_new ();
  gtk_widget_ref (eventbox);
  gtk_object_set_data_full (GTK_OBJECT (mail), "eventbox", eventbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (eventbox);
  gtk_box_pack_start (GTK_BOX (vbox14), eventbox, TRUE, TRUE, 0);

  xpmMail = gtk_pixmap_new(skin->icon[SKIN_MAIL_BIG].pixmap, skin->icon[SKIN_MAIL_BIG].mask);
  gtk_widget_ref (xpmMail);
  gtk_object_set_data_full (GTK_OBJECT (mail), "xpmMail", xpmMail,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (xpmMail);
  gtk_container_add (GTK_CONTAINER (eventbox), xpmMail);
  gtk_widget_set_usize (xpmMail, -2, 52);

  table13 = gtk_table_new (2, 2, FALSE);
  gtk_widget_ref (table13);
  gtk_object_set_data_full (GTK_OBJECT (mail), "table13", table13,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table13);
  gtk_box_pack_start (GTK_BOX (vbox14), table13, FALSE, TRUE, 0);

  labelsubject = gtk_label_new ("Subject : ");
  gtk_widget_ref (labelsubject);
  gtk_object_set_data_full (GTK_OBJECT (mail), "labelsubject", labelsubject,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labelsubject);
  gtk_table_attach (GTK_TABLE (table13), labelsubject, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (labelsubject, 60, -2);
  gtk_label_set_justify (GTK_LABEL (labelsubject), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (labelsubject), 0.15, 0.5);

  lblFrom = gtk_label_new (from);
  gtk_widget_ref (lblFrom);
  gtk_object_set_data_full (GTK_OBJECT (mail), "lblFrom", lblFrom,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lblFrom);
  gtk_table_attach (GTK_TABLE (table13), lblFrom, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (lblFrom), 0, 0.5);

  lblSubject = gtk_label_new (subject);
  gtk_widget_ref (lblSubject);
  gtk_object_set_data_full (GTK_OBJECT (mail), "lblSubject", lblSubject,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lblSubject);
  gtk_table_attach (GTK_TABLE (table13), lblSubject, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (lblSubject), 0, 0.5);

  labelfrom = gtk_label_new ("From : ");
  gtk_widget_ref (labelfrom);
  gtk_object_set_data_full (GTK_OBJECT (mail), "labelfrom", labelfrom,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labelfrom);
  gtk_table_attach (GTK_TABLE (table13), labelfrom, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (labelfrom, 60, -2);
  gtk_label_set_justify (GTK_LABEL (labelfrom), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (labelfrom), 0.15, 0.5);

  return mail;
}

static gboolean	on_mail_button_release_event(GtkWidget *widget,
					     GdkEventButton *event,
					     gpointer user_data)
{
  mail_t	*mail;
  int		pos_x = 0;
  list_t	*list;

  mail = (mail_t *)user_data;
  gtk_timeout_remove(mail->timeout_tag);
  gtk_widget_destroy(mail->window);
  gdk_bitmap_unref(mail->mask);
  gdk_bitmap_unref(mail->mask_alert);
  listRemoveItem(&mail_list, mail, free);
  for (list = mail_list; list; list = list->next)
    {
      gtk_widget_set_uposition(((mail_t *)list->data)->window, pos_x, 0);
      pos_x += ((mail_t *)list->data)->width + 3;
    }
  return FALSE;
}

static gint	mail_timeout(gpointer data)
{
  mail_t	*mail;
  GtkWidget	*xpmMail;
  pixmap_t	*pixmap;

  mail = (mail_t *)data;
  xpmMail = gtk_object_get_data(GTK_OBJECT(mail->window), "xpmMail");
  if (mail->state)
    {
      pixmap = &skin->icon[SKIN_MAIL_BIG];
      gdk_window_shape_combine_mask(mail->window->window, mail->mask, 0, 0);
    }
  else
    {
      pixmap = &skin->icon[SKIN_MAIL_BIG_ALERT];
      gdk_window_shape_combine_mask(mail->window->window, mail->mask_alert, 0, 0);
    }
  gtk_pixmap_set(GTK_PIXMAP(xpmMail), pixmap->pixmap, pixmap->mask);
  mail->state ^= 1;
  return (gtk_true());
}

void		mail_delete_all()
{
  mail_t	*mail;

  while (mail_list != NULL)
    {
      mail = (mail_t *)mail_list->data;
      gtk_timeout_remove(mail->timeout_tag);
      gtk_widget_destroy(mail->window);
      gdk_bitmap_unref(mail->mask);
      gdk_bitmap_unref(mail->mask_alert);
      listRemoveItem(&mail_list, mail, free);
    }
}
