EAPI="3"
PYTHON_DEPEND="2:2.5"
SUPPORT_PYTHON_ABIS="1"
RESTRICT_PYTHON_ABIS="2.4 3.*"

inherit distutils git-2

EGIT_REPO_URI="git://github.com/garbados/flask-browserid.git"

MY_PN="Flask-BrowserID"

DESCRIPTION="Flask support for BrowserID authentication"
HOMEPAGE="http://pypi.python.org/pypi/Flask-BrowserID"

LICENSE="MIT"
SLOT="0"
KEYWORDS="~amd64 ~x86"
IUSE="doc"

RDEPEND=">=dev-python/flask-0.9
		>=dev-python/flask-login-0.1.3
		dev-python/requests
		doc? ( dev-python/sphinx ) "
DEPEND="${RDEPEND}
	dev-python/setuptools"

S="${WORKDIR}/${MY_P}"

PYTHON_MODNAME="flaskext/browserid"

src_compile() {
	distutils_src_compile

	if use doc; then
		einfo "Generation of documentation"
		cd docs
		PYTHONPATH=".." emake html || die "Generation of documentation failed"
	fi
}

src_install() {
	distutils_src_install

	if use doc; then
		dohtml -r docs/_build/html/* || die "Installation of documentation failed"
	fi
}
