# Copyright 1999-2011 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: $

EAPI=3

inherit qt4-r2 git-2 

DESCRIPTION="Tool suite used to flash firmware (aka ROMs) onto Samsung Galaxy S devices."
HOMEPAGE="http://www.glassechidna.com.au/products/heimdall/"
SRC_URI=""

EGIT_REPO_URI="git://github.com/Benjamin-Dobell/Heimdall.git"

LICENSE=""
SLOT="0"
KEYWORDS=""
IUSE="X"

DEPEND="virtual/libusb:1
	X? ( x11-libs/qt-core
		 x11-libs/qt-gui
		)"

src_prepare() {
	cd ${PN}
	sed "s:sudo:#sudo:" -i Makefile.in
}

src_configure() {
	cd libpit
	econf
	cd ../heimdall
	econf
	if use X; then
		cd ../heimdall-frontend
		eqmake4 OUTPUTDIR="/usr/bin" heimdall-frontend.pro
	fi
}

src_compile() {
	cd libpit
	emake || die "emake failed"
	cd ../heimdall
	emake || die "emake failed"
	if use X; then
		cd ../heimdall-frontend
		emake || die "emake failed"
	fi
}

src_install() {
	dodoc README || die "dodoc failed"
	cd libpit
	emake DESTDIR="${D}" install || die "Install failed"
	cd ../heimdall
	emake DESTDIR="${D}" install || die "Install failed"
	if use X; then
		cd ../heimdall-frontend
		emake INSTALL_ROOT="${D}" install || die "install failed"
	fi

}
