/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.LinkedList;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.packet.Packet;

class ConnectionDetachedPacketCollector {
    private int maxPackets = SmackConfiguration.getPacketCollectorSize();
    private LinkedList<Packet> resultQueue = new LinkedList();

    public ConnectionDetachedPacketCollector() {
    }

    public ConnectionDetachedPacketCollector(int n) {
        this.maxPackets = n;
    }

    public synchronized Packet pollResult() {
        if (this.resultQueue.isEmpty()) {
            return null;
        }
        return this.resultQueue.removeLast();
    }

    public synchronized Packet nextResult() {
        while (this.resultQueue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.resultQueue.removeLast();
    }

    public synchronized Packet nextResult(long l) {
        if (this.resultQueue.isEmpty()) {
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.resultQueue.isEmpty()) {
            return null;
        }
        return this.resultQueue.removeLast();
    }

    protected synchronized void processPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        if (this.resultQueue.size() == this.maxPackets) {
            this.resultQueue.removeLast();
        }
        this.resultQueue.addFirst(packet);
        this.notifyAll();
    }
}

