/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.File;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.util.DNSUtil;

public class ConnectionConfiguration
implements Cloneable {
    private String serviceName;
    private String host;
    private int port;
    private String truststorePath;
    private String truststoreType;
    private String truststorePassword;
    private String keystorePath;
    private String keystoreType;
    private String pkcs11Library;
    private boolean verifyChainEnabled = false;
    private boolean verifyRootCAEnabled = false;
    private boolean selfSignedCertificateEnabled = false;
    private boolean expiredCertificatesCheckEnabled = false;
    private boolean notMatchingDomainCheckEnabled = false;
    private SSLContext customSSLContext;
    private boolean compressionEnabled = false;
    private boolean saslAuthenticationEnabled = true;
    private CallbackHandler callbackHandler;
    private boolean debuggerEnabled = Connection.DEBUG_ENABLED;
    private boolean reconnectionAllowed = true;
    private SocketFactory socketFactory;
    private String username;
    private String password;
    private String resource;
    private boolean sendPresence = true;
    private boolean rosterLoadedAtLogin = true;
    private SecurityMode securityMode = SecurityMode.enabled;
    protected ProxyInfo proxy;

    public ConnectionConfiguration(String string) {
        DNSUtil.HostAddress hostAddress = DNSUtil.resolveXMPPDomain(string);
        this.init(hostAddress.getHost(), hostAddress.getPort(), string, ProxyInfo.forDefaultProxy());
    }

    public ConnectionConfiguration(String string, ProxyInfo proxyInfo) {
        DNSUtil.HostAddress hostAddress = DNSUtil.resolveXMPPDomain(string);
        this.init(hostAddress.getHost(), hostAddress.getPort(), string, proxyInfo);
    }

    public ConnectionConfiguration(String string, int n, String string2) {
        this.init(string, n, string2, ProxyInfo.forDefaultProxy());
    }

    public ConnectionConfiguration(String string, int n, String string2, ProxyInfo proxyInfo) {
        this.init(string, n, string2, proxyInfo);
    }

    public ConnectionConfiguration(String string, int n) {
        this.init(string, n, string, ProxyInfo.forDefaultProxy());
    }

    public ConnectionConfiguration(String string, int n, ProxyInfo proxyInfo) {
        this.init(string, n, string, proxyInfo);
    }

    private void init(String string, int n, String string2, ProxyInfo proxyInfo) {
        this.host = string;
        this.port = n;
        this.serviceName = string2;
        this.proxy = proxyInfo;
        String string3 = System.getProperty("java.home");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3).append(File.separator).append("lib");
        stringBuilder.append(File.separator).append("security");
        stringBuilder.append(File.separator).append("cacerts");
        this.truststorePath = stringBuilder.toString();
        this.truststoreType = "jks";
        this.truststorePassword = "changeit";
        this.keystorePath = System.getProperty("javax.net.ssl.keyStore");
        this.keystoreType = "jks";
        this.pkcs11Library = "pkcs11.config";
        this.socketFactory = proxyInfo.getSocketFactory();
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public SecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public void setSecurityMode(SecurityMode securityMode) {
        this.securityMode = securityMode;
    }

    public String getTruststorePath() {
        return this.truststorePath;
    }

    public void setTruststorePath(String string) {
        this.truststorePath = string;
    }

    public String getTruststoreType() {
        return this.truststoreType;
    }

    public void setTruststoreType(String string) {
        this.truststoreType = string;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public void setTruststorePassword(String string) {
        this.truststorePassword = string;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public void setKeystorePath(String string) {
        this.keystorePath = string;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String string) {
        this.keystoreType = string;
    }

    public String getPKCS11Library() {
        return this.pkcs11Library;
    }

    public void setPKCS11Library(String string) {
        this.pkcs11Library = string;
    }

    public boolean isVerifyChainEnabled() {
        return this.verifyChainEnabled;
    }

    public void setVerifyChainEnabled(boolean bl) {
        this.verifyChainEnabled = bl;
    }

    public boolean isVerifyRootCAEnabled() {
        return this.verifyRootCAEnabled;
    }

    public void setVerifyRootCAEnabled(boolean bl) {
        this.verifyRootCAEnabled = bl;
    }

    public boolean isSelfSignedCertificateEnabled() {
        return this.selfSignedCertificateEnabled;
    }

    public void setSelfSignedCertificateEnabled(boolean bl) {
        this.selfSignedCertificateEnabled = bl;
    }

    public boolean isExpiredCertificatesCheckEnabled() {
        return this.expiredCertificatesCheckEnabled;
    }

    public void setExpiredCertificatesCheckEnabled(boolean bl) {
        this.expiredCertificatesCheckEnabled = bl;
    }

    public boolean isNotMatchingDomainCheckEnabled() {
        return this.notMatchingDomainCheckEnabled;
    }

    public void setNotMatchingDomainCheckEnabled(boolean bl) {
        this.notMatchingDomainCheckEnabled = bl;
    }

    public SSLContext getCustomSSLContext() {
        return this.customSSLContext;
    }

    public void setCustomSSLContext(SSLContext sSLContext) {
        this.customSSLContext = sSLContext;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public void setCompressionEnabled(boolean bl) {
        this.compressionEnabled = bl;
    }

    public boolean isSASLAuthenticationEnabled() {
        return this.saslAuthenticationEnabled;
    }

    public void setSASLAuthenticationEnabled(boolean bl) {
        this.saslAuthenticationEnabled = bl;
    }

    public boolean isDebuggerEnabled() {
        return this.debuggerEnabled;
    }

    public void setDebuggerEnabled(boolean bl) {
        this.debuggerEnabled = bl;
    }

    public void setReconnectionAllowed(boolean bl) {
        this.reconnectionAllowed = bl;
    }

    public boolean isReconnectionAllowed() {
        return this.reconnectionAllowed;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public void setSendPresence(boolean bl) {
        this.sendPresence = bl;
    }

    public boolean isRosterLoadedAtLogin() {
        return this.rosterLoadedAtLogin;
    }

    public void setRosterLoadedAtLogin(boolean bl) {
        this.rosterLoadedAtLogin = bl;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    String getUsername() {
        return this.username;
    }

    String getPassword() {
        return this.password;
    }

    String getResource() {
        return this.resource;
    }

    boolean isSendPresence() {
        return this.sendPresence;
    }

    void setLoginInfo(String string, String string2, String string3) {
        this.username = string;
        this.password = string2;
        this.resource = string3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SecurityMode {
        required,
        enabled,
        disabled;

    }
}

