/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.nat;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.SmackLogger;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;
import org.jivesoftware.smackx.jingle.nat.TransportResolverListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransportResolver {
    private static final SmackLogger LOGGER = SmackLogger.getLogger(TransportResolver.class);
    public Type type = Type.rawupd;
    public static final int CHECK_TIMEOUT = 3000;
    private final ArrayList<TransportResolverListener> listeners = new ArrayList();
    private boolean resolving = false;
    private boolean resolved = false;
    private boolean initialized = false;
    protected final List<TransportCandidate> candidates = new ArrayList<TransportCandidate>();

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    protected TransportResolver() {
    }

    public abstract void initialize() throws XMPPException;

    public abstract void resolve(JingleSession var1) throws XMPPException;

    public void clear() throws XMPPException {
        this.cancel();
        this.candidates.clear();
    }

    public abstract void cancel() throws XMPPException;

    public boolean isResolving() {
        return this.resolving;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public synchronized void setInitialized() {
        this.initialized = true;
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    protected synchronized void setResolveInit() {
        this.resolved = false;
        this.resolving = true;
        this.triggerResolveInit();
    }

    protected synchronized void setResolveEnd() {
        this.resolved = true;
        this.resolving = false;
        this.triggerResolveEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TransportResolverListener transportResolverListener) {
        ArrayList<TransportResolverListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(transportResolverListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(TransportResolverListener transportResolverListener) {
        ArrayList<TransportResolverListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(transportResolverListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getListenersList() {
        ArrayList<TransportResolverListener> arrayList = this.listeners;
        synchronized (arrayList) {
            return new ArrayList<TransportResolverListener>(this.listeners);
        }
    }

    protected void triggerCandidateAdded(TransportCandidate transportCandidate) {
        for (TransportResolverListener transportResolverListener : this.getListenersList()) {
            if (!(transportResolverListener instanceof TransportResolverListener.Resolver)) continue;
            TransportResolverListener.Resolver resolver = (TransportResolverListener.Resolver)transportResolverListener;
            LOGGER.debug("triggerCandidateAdded : " + transportCandidate.getLocalIp());
            resolver.candidateAdded(transportCandidate);
        }
    }

    private void triggerResolveInit() {
        for (TransportResolverListener transportResolverListener : this.getListenersList()) {
            if (!(transportResolverListener instanceof TransportResolverListener.Resolver)) continue;
            TransportResolverListener.Resolver resolver = (TransportResolverListener.Resolver)transportResolverListener;
            resolver.init();
        }
    }

    private void triggerResolveEnd() {
        for (TransportResolverListener transportResolverListener : this.getListenersList()) {
            if (!(transportResolverListener instanceof TransportResolverListener.Resolver)) continue;
            TransportResolverListener.Resolver resolver = (TransportResolverListener.Resolver)transportResolverListener;
            resolver.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCandidates() {
        List<TransportCandidate> list = this.candidates;
        synchronized (list) {
            this.candidates.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCandidate(TransportCandidate transportCandidate) {
        List<TransportCandidate> list = this.candidates;
        synchronized (list) {
            if (!this.candidates.contains(transportCandidate)) {
                this.candidates.add(transportCandidate);
            }
        }
        this.triggerCandidateAdded(transportCandidate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getCandidates() {
        List<TransportCandidate> list = this.candidates;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<TransportCandidate>(this.candidates)).iterator();
        }
    }

    public TransportCandidate getPreferredCandidate() {
        TransportCandidate transportCandidate = null;
        ArrayList arrayList = (ArrayList)this.getCandidatesList();
        if (arrayList.size() > 0) {
            Collections.sort(arrayList);
            transportCandidate = (TransportCandidate)arrayList.get(arrayList.size() - 1);
            LOGGER.debug("Result: " + transportCandidate.getIp());
        }
        return transportCandidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCandidateCount() {
        List<TransportCandidate> list = this.candidates;
        synchronized (list) {
            return this.candidates.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransportCandidate> getCandidatesList() {
        ArrayList<TransportCandidate> arrayList = null;
        List<TransportCandidate> list = this.candidates;
        synchronized (list) {
            arrayList = new ArrayList<TransportCandidate>(this.candidates);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportCandidate getCandidate(int n) {
        TransportCandidate transportCandidate;
        List<TransportCandidate> list = this.candidates;
        synchronized (list) {
            transportCandidate = this.candidates.get(n);
        }
        return transportCandidate;
    }

    public void initializeAndWait() throws XMPPException {
        this.initialize();
        try {
            LOGGER.debug("Initializing transport resolver...");
            while (!this.isInitialized()) {
                LOGGER.debug("Resolver init still pending");
                Thread.sleep(1000L);
            }
            LOGGER.debug("Transport resolved\n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected int getFreePort() {
        int n = 0;
        for (int i = 0; i < 10; ++i) {
            n = (int)(10000L + Math.round(Math.random() * 10000.0));
            n = n % 2 == 0 ? n : n + 1;
            try {
                ServerSocket serverSocket = new ServerSocket(n);
                n = serverSocket.getLocalPort();
                serverSocket.close();
                return n;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                continue;
            }
        }
        try {
            ServerSocket serverSocket = new ServerSocket(0);
            n = serverSocket.getLocalPort();
            serverSocket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        rawupd,
        ice;

    }
}

