/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.util.WriterListener;

public class ObservableWriter
extends Writer {
    Writer wrappedWriter = null;
    List listeners = new ArrayList();

    public ObservableWriter(Writer writer) {
        this.wrappedWriter = writer;
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.wrappedWriter.write(cArray, n, n2);
        String string = new String(cArray, n, n2);
        this.notifyListeners(string);
    }

    public void flush() throws IOException {
        this.wrappedWriter.flush();
    }

    public void close() throws IOException {
        this.wrappedWriter.close();
    }

    public void write(int n) throws IOException {
        this.wrappedWriter.write(n);
    }

    public void write(char[] cArray) throws IOException {
        this.wrappedWriter.write(cArray);
        String string = new String(cArray);
        this.notifyListeners(string);
    }

    public void write(String string) throws IOException {
        this.wrappedWriter.write(string);
        this.notifyListeners(string);
    }

    public void write(String string, int n, int n2) throws IOException {
        this.wrappedWriter.write(string, n, n2);
        string = string.substring(n, n + n2);
        this.notifyListeners(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(String string) {
        WriterListener[] writerListenerArray = null;
        List list = this.listeners;
        synchronized (list) {
            writerListenerArray = new WriterListener[this.listeners.size()];
            this.listeners.toArray(writerListenerArray);
        }
        for (int i = 0; i < writerListenerArray.length; ++i) {
            writerListenerArray[i].write(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWriterListener(WriterListener writerListener) {
        if (writerListener == null) {
            return;
        }
        List list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(writerListener)) {
                this.listeners.add(writerListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWriterListener(WriterListener writerListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(writerListener);
        }
    }
}

