/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sasl.client;

import org.apache.harmony.javax.security.sasl.SaslException;

class TokenParser {
    private static final int STATE_LOOKING_FOR_FIRST_TOKEN = 1;
    private static final int STATE_LOOKING_FOR_TOKEN = 2;
    private static final int STATE_SCANNING_TOKEN = 3;
    private static final int STATE_LOOKING_FOR_COMMA = 4;
    private static final int STATE_PARSING_ERROR = 5;
    private static final int STATE_DONE = 6;
    private int m_curPos;
    private int m_scanStart;
    private int m_state;
    private String m_tokens;

    TokenParser(String string) {
        this.m_tokens = string;
        this.m_curPos = 0;
        this.m_scanStart = 0;
        this.m_state = 1;
    }

    String parseToken() throws SaslException {
        String string = null;
        if (this.m_state == 6) {
            return null;
        }
        while (this.m_curPos < this.m_tokens.length() && string == null) {
            char c = this.m_tokens.charAt(this.m_curPos);
            switch (this.m_state) {
                case 1: 
                case 2: {
                    if (this.isWhiteSpace(c)) break;
                    if (this.isValidTokenChar(c)) {
                        this.m_scanStart = this.m_curPos;
                        this.m_state = 3;
                        break;
                    }
                    this.m_state = 5;
                    throw new SaslException("Invalid token character at position " + this.m_curPos);
                }
                case 3: {
                    if (this.isValidTokenChar(c)) break;
                    if (this.isWhiteSpace(c)) {
                        string = this.m_tokens.substring(this.m_scanStart, this.m_curPos);
                        this.m_state = 4;
                        break;
                    }
                    if (',' == c) {
                        string = this.m_tokens.substring(this.m_scanStart, this.m_curPos);
                        this.m_state = 2;
                        break;
                    }
                    this.m_state = 5;
                    throw new SaslException("Invalid token character at position " + this.m_curPos);
                }
                case 4: {
                    if (this.isWhiteSpace(c)) break;
                    if (c == ',') {
                        this.m_state = 2;
                        break;
                    }
                    this.m_state = 5;
                    throw new SaslException("Expected a comma, found '" + c + "' at postion " + this.m_curPos);
                }
            }
            ++this.m_curPos;
        }
        if (string == null) {
            switch (this.m_state) {
                case 3: {
                    string = this.m_tokens.substring(this.m_scanStart);
                    this.m_state = 6;
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: {
                    throw new SaslException("Trialing comma");
                }
            }
        }
        return string;
    }

    boolean isValidTokenChar(char c) {
        return !(c >= '\u0000' && c <= ' ' || c >= ':' && c <= '@' || c >= '[' && c <= ']' || ',' == c || '%' == c || '(' == c || ')' == c || '{' == c || '}' == c) && '\u007f' != c;
    }

    boolean isWhiteSpace(char c) {
        return '\t' == c || '\n' == c || '\r' == c || ' ' == c;
    }
}

