package com.beem.project.beem.ui;

import org.jivesoftware.smack.packet.Presence;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.view.View;
import android.widget.Button;

import com.beem.project.beem.BeemService;
import com.beem.project.beem.R;
import com.beem.project.beem.service.Contact;
import com.beem.project.beem.service.PresenceAdapter;
import com.beem.project.beem.service.aidl.IXmppFacade;

public class ContactDialog extends Dialog {

    public static final String TAG = "Option Dialog";
    private final Contact mContact;
    private final String mGroup;
    private final Context mContext;
    private IXmppFacade mXmppFacade = null;
    private final ServiceConnection mServConn = new BeemServiceConnection();

    public ContactDialog(final Context context, Contact curContact, String group) {
	super(context);
	mContext = context;

	setContentView(R.layout.contactdialog);
	mContact = curContact;
	mGroup = group;
	setTitle(curContact.getJID());

	Button button = (Button) findViewById(R.id.CDChat);
	button.setOnClickListener(new chatListener());
	button = (Button) findViewById(R.id.CDAlias);
	button.setOnClickListener(new aliasListener());
	button = (Button) findViewById(R.id.CDDelete);
	button.setOnClickListener(new deleteListener());
	button = (Button) findViewById(R.id.CDResend);
	button.setOnClickListener(new resendListener());
	button = (Button) findViewById(R.id.CDBlock);
	button.setOnClickListener(new blockListener());
	button = (Button) findViewById(R.id.CDInfos);
	button.setOnClickListener(new infosListener());
	button = (Button) findViewById(R.id.CDCall);
	button.setOnClickListener(new CallListener());

	mContext.bindService(new Intent(mContext, BeemService.class), mServConn, Service.BIND_AUTO_CREATE);
    }

    @Override
    public void dismiss() {
	super.dismiss();
	mContext.unbindService(mServConn);
    }

    class CallListener implements View.OnClickListener {

	@Override
	public void onClick(View v) {
	    try {
		//TODO: permettre a l'user de choisir a quel ressource il veut faire le call.
		mXmppFacade.call(mContact.getJID() + "/BEEM");
	    } catch (RemoteException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	    }
	    
	}
	
    }
    
    class aliasListener implements View.OnClickListener {

	@Override
	public void onClick(View v) {

	    ContactDialogAliasDialog dialog = new ContactDialogAliasDialog(mContext, mContact);
	    dialog.setOwnerActivity(ContactDialog.this.getOwnerActivity());
	    dialog.initService(mXmppFacade);
	    dialog.show();
	}

    }

    class blockListener implements View.OnClickListener {

	@Override
	public void onClick(View v) {
	    try {
		mXmppFacade.blockUser(mContact.getJID());
	    } catch (RemoteException e) {
		e.printStackTrace();
	    }
	    dismiss();
	}	
    }

    class chatListener implements View.OnClickListener {

	@Override
	public void onClick(View v) {
	    Activity a = ContactDialog.this.getOwnerActivity();
	    Intent i = new Intent(mContext, SendIM.class);
	    i.setData(mContact.toUri());
	    a.startActivity(i);
	    dismiss();
	}

    }

    class deleteListener implements View.OnClickListener {

	@Override
	public void onClick(View v) {
	    final Activity a = ContactDialog.this.getOwnerActivity();
	    AlertDialog.Builder builder = new AlertDialog.Builder(a);
	    builder.setMessage(a.getString(R.string.CDDelete)).setCancelable(false).setPositiveButton(
		a.getString(R.string.CDSure2DeleteYes), new DialogInterface.OnClickListener() {
		    public void onClick(DialogInterface dialog, int id) {
			try {
			    mXmppFacade.getRoster().deleteContact(mContact, mGroup);
			} catch (RemoteException e) {
			    e.printStackTrace();
			}
			dismiss();
		    }
		}).setNegativeButton(a.getString(R.string.CDSure2DeleteNo), new DialogInterface.OnClickListener() {
		    public void onClick(DialogInterface dialog, int id) {
			dialog.cancel();
		    }
		});
	    AlertDialog alert = builder.create();
	    alert.show();
	}
    }

    class infosListener implements View.OnClickListener {

	@Override
	public void onClick(View v) {
	    Activity a = ContactDialog.this.getOwnerActivity();
	    Intent i = new Intent(mContext, GroupList.class);
	    //i.setData(mContact.toUri());
	    i.putExtra("JID", mContact.getJID());
	    a.startActivity(i);
	    dismiss();
	}

    }

    class resendListener implements View.OnClickListener {

	@Override
	public void onClick(View v) {
	    Presence presencePacket = new Presence(Presence.Type.subscribe);
	    presencePacket.setTo(mContact.getJID());
	    try {
		mXmppFacade.sendPresencePacket(new PresenceAdapter(presencePacket));
	    } catch (RemoteException e) {
		Log.e(TAG, "resend subscription error", e);
	    }
	    dismiss();
	}

    }

    private class BeemServiceConnection implements ServiceConnection {

	@Override
	public void onServiceConnected(ComponentName name, IBinder service) {
	    mXmppFacade = IXmppFacade.Stub.asInterface(service);
	}

	@Override
	public void onServiceDisconnected(ComponentName name) {
	    mXmppFacade = null;
	}
    }

}
