/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.test.demo;

import de.javawi.jstun.attribute.ChangeRequest;
import de.javawi.jstun.attribute.ChangedAddress;
import de.javawi.jstun.attribute.MappedAddress;
import de.javawi.jstun.attribute.MessageAttributeException;
import de.javawi.jstun.attribute.MessageAttributeInterface;
import de.javawi.jstun.attribute.MessageAttributeParsingException;
import de.javawi.jstun.attribute.ResponseAddress;
import de.javawi.jstun.attribute.SourceAddress;
import de.javawi.jstun.attribute.UnknownAttribute;
import de.javawi.jstun.attribute.UnknownMessageAttributeException;
import de.javawi.jstun.header.MessageHeader;
import de.javawi.jstun.header.MessageHeaderInterface;
import de.javawi.jstun.header.MessageHeaderParsingException;
import de.javawi.jstun.util.Address;
import de.javawi.jstun.util.UtilityException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StunServer {
    private static final Log LOGGER = LogFactory.getLog(StunServer.class);
    Vector<DatagramSocket> sockets = new Vector();

    public StunServer(int primaryPort, InetAddress primary, int secondaryPort, InetAddress secondary) throws SocketException {
        this.sockets.add(new DatagramSocket(primaryPort, primary));
        this.sockets.add(new DatagramSocket(secondaryPort, primary));
        this.sockets.add(new DatagramSocket(primaryPort, secondary));
        this.sockets.add(new DatagramSocket(secondaryPort, secondary));
    }

    public void start() throws SocketException {
        for (DatagramSocket socket : this.sockets) {
            socket.setReceiveBufferSize(2000);
            StunServerReceiverThread ssrt = new StunServerReceiverThread(socket);
            ssrt.start();
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length != 4) {
                System.out.println("usage: java de.javawi.jstun.test.demo.StunServer PORT1 IP1 PORT2 IP2");
                System.out.println();
                System.out.println(" PORT1 - the first port that should be used by the server");
                System.out.println("   IP1 - the first ip address that should be used by the server");
                System.out.println(" PORT2 - the second port that should be used by the server");
                System.out.println("   IP2 - the second ip address that should be used by the server");
                System.exit(0);
            }
            FileHandler fh = new FileHandler("logging_server.txt");
            fh.setFormatter(new SimpleFormatter());
            Logger.getLogger("de.javawi.stun").addHandler(fh);
            Logger.getLogger("de.javawi.stun").setLevel(Level.ALL);
            StunServer ss = new StunServer(Integer.parseInt(args[0]), InetAddress.getByName(args[1]), Integer.parseInt(args[2]), InetAddress.getByName(args[3]));
            ss.start();
        }
        catch (SocketException se) {
            se.printStackTrace();
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    class StunServerReceiverThread
    extends Thread {
        private DatagramSocket receiverSocket;
        private DatagramSocket changedPort;
        private DatagramSocket changedIP;
        private DatagramSocket changedPortIP;

        StunServerReceiverThread(DatagramSocket datagramSocket) {
            this.receiverSocket = datagramSocket;
            for (DatagramSocket socket : StunServer.this.sockets) {
                if (socket.getLocalPort() != this.receiverSocket.getLocalPort() && socket.getLocalAddress().equals(this.receiverSocket.getLocalAddress())) {
                    this.changedPort = socket;
                }
                if (socket.getLocalPort() == this.receiverSocket.getLocalPort() && !socket.getLocalAddress().equals(this.receiverSocket.getLocalAddress())) {
                    this.changedIP = socket;
                }
                if (socket.getLocalPort() == this.receiverSocket.getLocalPort() || socket.getLocalAddress().equals(this.receiverSocket.getLocalAddress())) continue;
                this.changedPortIP = socket;
            }
        }

        public void run() {
            block9: while (true) {
                try {
                    while (true) {
                        DatagramPacket receive = new DatagramPacket(new byte[200], 200);
                        this.receiverSocket.receive(receive);
                        LOGGER.debug((Object)(this.receiverSocket.getLocalAddress().getHostAddress() + ":" + this.receiverSocket.getLocalPort() + " datagram received from " + receive.getAddress().getHostAddress() + ":" + receive.getPort()));
                        MessageHeader receiveMH = MessageHeader.parseHeader(receive.getData());
                        try {
                            DatagramPacket send;
                            byte[] data;
                            SourceAddress sa;
                            receiveMH.parseAttributes(receive.getData());
                            if (receiveMH.getType() != MessageHeaderInterface.MessageHeaderType.BindingRequest) continue block9;
                            LOGGER.debug((Object)(this.receiverSocket.getLocalAddress().getHostAddress() + ":" + this.receiverSocket.getLocalPort() + " Binding Request received from " + receive.getAddress().getHostAddress() + ":" + receive.getPort()));
                            ChangeRequest cr = (ChangeRequest)receiveMH.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.ChangeRequest);
                            if (cr == null) {
                                throw new MessageAttributeException("Message attribute change request is not set.");
                            }
                            ResponseAddress ra = (ResponseAddress)receiveMH.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.ResponseAddress);
                            MessageHeader sendMH = new MessageHeader(MessageHeaderInterface.MessageHeaderType.BindingResponse);
                            sendMH.setTransactionID(receiveMH.getTransactionID());
                            MappedAddress ma = new MappedAddress();
                            ma.setAddress(new Address(receive.getAddress().getAddress()));
                            ma.setPort(receive.getPort());
                            sendMH.addMessageAttribute(ma);
                            ChangedAddress ca = new ChangedAddress();
                            ca.setAddress(new Address(this.changedPortIP.getLocalAddress().getAddress()));
                            ca.setPort(this.changedPortIP.getLocalPort());
                            sendMH.addMessageAttribute(ca);
                            if (cr.isChangePort() && !cr.isChangeIP()) {
                                LOGGER.debug((Object)"Change port received in Change Request attribute");
                                sa = new SourceAddress();
                                sa.setAddress(new Address(this.changedPort.getLocalAddress().getAddress()));
                                sa.setPort(this.changedPort.getLocalPort());
                                sendMH.addMessageAttribute(sa);
                                data = sendMH.getBytes();
                                send = new DatagramPacket(data, data.length);
                                if (ra != null) {
                                    send.setPort(ra.getPort());
                                    send.setAddress(ra.getAddress().getInetAddress());
                                } else {
                                    send.setPort(receive.getPort());
                                    send.setAddress(receive.getAddress());
                                }
                                this.changedPort.send(send);
                                LOGGER.debug((Object)(this.changedPort.getLocalAddress().getHostAddress() + ":" + this.changedPort.getLocalPort() + " send Binding Response to " + send.getAddress().getHostAddress() + ":" + send.getPort()));
                                continue block9;
                            }
                            if (!cr.isChangePort() && cr.isChangeIP()) {
                                LOGGER.debug((Object)"Change ip received in Change Request attribute");
                                sa = new SourceAddress();
                                sa.setAddress(new Address(this.changedIP.getLocalAddress().getAddress()));
                                sa.setPort(this.changedIP.getLocalPort());
                                sendMH.addMessageAttribute(sa);
                                data = sendMH.getBytes();
                                send = new DatagramPacket(data, data.length);
                                if (ra != null) {
                                    send.setPort(ra.getPort());
                                    send.setAddress(ra.getAddress().getInetAddress());
                                } else {
                                    send.setPort(receive.getPort());
                                    send.setAddress(receive.getAddress());
                                }
                                this.changedIP.send(send);
                                LOGGER.debug((Object)(this.changedIP.getLocalAddress().getHostAddress() + ":" + this.changedIP.getLocalPort() + " send Binding Response to " + send.getAddress().getHostAddress() + ":" + send.getPort()));
                                continue block9;
                            }
                            if (!cr.isChangePort() && !cr.isChangeIP()) {
                                LOGGER.debug((Object)"Nothing received in Change Request attribute");
                                sa = new SourceAddress();
                                sa.setAddress(new Address(this.receiverSocket.getLocalAddress().getAddress()));
                                sa.setPort(this.receiverSocket.getLocalPort());
                                sendMH.addMessageAttribute(sa);
                                data = sendMH.getBytes();
                                send = new DatagramPacket(data, data.length);
                                if (ra != null) {
                                    send.setPort(ra.getPort());
                                    send.setAddress(ra.getAddress().getInetAddress());
                                } else {
                                    send.setPort(receive.getPort());
                                    send.setAddress(receive.getAddress());
                                }
                                this.receiverSocket.send(send);
                                LOGGER.debug((Object)(this.receiverSocket.getLocalAddress().getHostAddress() + ":" + this.receiverSocket.getLocalPort() + " send Binding Response to " + send.getAddress().getHostAddress() + ":" + send.getPort()));
                                continue block9;
                            }
                            if (!cr.isChangePort() || !cr.isChangeIP()) continue block9;
                            LOGGER.debug((Object)"Change port and ip received in Change Request attribute");
                            sa = new SourceAddress();
                            sa.setAddress(new Address(this.changedPortIP.getLocalAddress().getAddress()));
                            sa.setPort(this.changedPortIP.getLocalPort());
                            sendMH.addMessageAttribute(sa);
                            data = sendMH.getBytes();
                            send = new DatagramPacket(data, data.length);
                            if (ra != null) {
                                send.setPort(ra.getPort());
                                send.setAddress(ra.getAddress().getInetAddress());
                            } else {
                                send.setPort(receive.getPort());
                                send.setAddress(receive.getAddress());
                            }
                            this.changedPortIP.send(send);
                            LOGGER.debug((Object)(this.changedPortIP.getLocalAddress().getHostAddress() + ":" + this.changedPortIP.getLocalPort() + " send Binding Response to " + send.getAddress().getHostAddress() + ":" + send.getPort()));
                            continue block9;
                        }
                        catch (UnknownMessageAttributeException umae) {
                            umae.printStackTrace();
                            MessageHeader sendMH = new MessageHeader(MessageHeaderInterface.MessageHeaderType.BindingErrorResponse);
                            sendMH.setTransactionID(receiveMH.getTransactionID());
                            UnknownAttribute ua = new UnknownAttribute();
                            ua.addAttribute(umae.getType());
                            sendMH.addMessageAttribute(ua);
                            byte[] data = sendMH.getBytes();
                            DatagramPacket send = new DatagramPacket(data, data.length);
                            send.setPort(receive.getPort());
                            send.setAddress(receive.getAddress());
                            this.receiverSocket.send(send);
                            LOGGER.debug((Object)(this.changedPortIP.getLocalAddress().getHostAddress() + ":" + this.changedPortIP.getLocalPort() + " send Binding Error Response to " + send.getAddress().getHostAddress() + ":" + send.getPort()));
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    continue;
                }
                catch (MessageAttributeParsingException mape) {
                    mape.printStackTrace();
                    continue;
                }
                catch (MessageAttributeException mae) {
                    mae.printStackTrace();
                    continue;
                }
                catch (MessageHeaderParsingException mhpe) {
                    mhpe.printStackTrace();
                    continue;
                }
                catch (UtilityException ue) {
                    ue.printStackTrace();
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    aioobe.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

