/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.muc.ConnectionDetachedPacketCollector;

class PacketMultiplexListener
implements PacketListener {
    private static final PacketFilter MESSAGE_FILTER = new MessageTypeFilter(Message.Type.groupchat);
    private static final PacketFilter PRESENCE_FILTER = new PacketTypeFilter(Presence.class);
    private static final PacketFilter SUBJECT_FILTER = new PacketFilter(){

        public boolean accept(Packet packet) {
            Message msg = (Message)packet;
            return msg.getSubject() != null;
        }
    };
    private static final PacketFilter DECLINES_FILTER = new PacketExtensionFilter("x", "http://jabber.org/protocol/muc#user");
    private ConnectionDetachedPacketCollector messageCollector;
    private PacketListener presenceListener;
    private PacketListener subjectListener;
    private PacketListener declinesListener;

    public PacketMultiplexListener(ConnectionDetachedPacketCollector messageCollector, PacketListener presenceListener, PacketListener subjectListener, PacketListener declinesListener) {
        if (messageCollector == null) {
            throw new IllegalArgumentException("MessageCollector is null");
        }
        if (presenceListener == null) {
            throw new IllegalArgumentException("Presence listener is null");
        }
        if (subjectListener == null) {
            throw new IllegalArgumentException("Subject listener is null");
        }
        if (declinesListener == null) {
            throw new IllegalArgumentException("Declines listener is null");
        }
        this.messageCollector = messageCollector;
        this.presenceListener = presenceListener;
        this.subjectListener = subjectListener;
        this.declinesListener = declinesListener;
    }

    public void processPacket(Packet p) {
        if (PRESENCE_FILTER.accept(p)) {
            this.presenceListener.processPacket(p);
        } else if (MESSAGE_FILTER.accept(p)) {
            this.messageCollector.processPacket(p);
            if (SUBJECT_FILTER.accept(p)) {
                this.subjectListener.processPacket(p);
            }
        } else if (DECLINES_FILTER.accept(p)) {
            this.declinesListener.processPacket(p);
        }
    }
}

