package com.beem.project.beem.ui;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.AdapterView.OnItemSelectedListener;

import com.beem.project.beem.R;
import com.beem.project.beem.utils.Status;

public class ChangeStatus extends Activity {
    
    private TextView mStatusText;
    private Button mOk;
    private Button mClear;
    private Spinner mSpin;
    private String mSelectedStatus;
    private SharedPreferences mSettings;
    private ArrayAdapter<String> mAdapter;
    private Context mContext = this;
    private Toast mToast;
    private static final String[] mStatus = {"Available", "Available for chat",
	"Busy", "Away", "Unavailable", "Disconnected"};
    
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        // TODO Auto-generated method stub
        super.onCreate(savedInstanceState);
        setContentView(R.layout.changestatus);
        
        mStatusText = (TextView) findViewById(R.id.ChangeStatusText);
        mOk = (Button) findViewById(R.id.ChangeStatusOk);
        mClear = (Button) findViewById(R.id.ChangeStatusClear);
        mOk.setOnClickListener(mOnClickOk);
        mClear.setOnClickListener(mOnClickClear);
        mSettings = getSharedPreferences(getString(R.string.PreferenceFileName),
        	MODE_PRIVATE);
        
        mSpin = (Spinner) findViewById(R.id.ChangeStatusSpinner);
        mAdapter = new ArrayAdapter<String>(this,
                android.R.layout.simple_spinner_item, mStatus);
        mAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        mSpin.setAdapter(mAdapter);
        mSpin.setOnItemSelectedListener(mStatusItem);
        showSettings();
    }
    
    private OnItemSelectedListener mStatusItem = new OnItemSelectedListener () {
	@Override
	public void onNothingSelected(AdapterView<?> arg0) {
	}

	@Override
	public void onItemSelected(AdapterView<?> sp, View v, int i,
		long arg3) {
	    mSelectedStatus = (String) sp.getSelectedItem();
	}
    };
    
    private OnClickListener mOnClickOk = new OnClickListener() {
	public void onClick(View v) {
	    if (textHasChanged() || statusHasChanged()) {
		Editor edit = mSettings.edit();
		edit.putString(getString(R.string.PreferenceStatusText),
			mStatusText.getText().toString());
		edit.putInt(getString(R.string.PreferenceStatus),
			getStatusId(mSelectedStatus));
		Log.i("Selected item --->", mSelectedStatus);
		edit.commit();
		mToast = Toast.makeText(mContext, R.string.ChangeStatusOk,
			Toast.LENGTH_LONG);
		mToast.show();
	    }
	    else {
		mToast = Toast.makeText(mContext, R.string.ChangeStatusNoChange,
			Toast.LENGTH_LONG);
		mToast.show();
	    }
	}
    };
    
    private OnClickListener mOnClickClear = new OnClickListener() {
	public void onClick(View v) {
	    mStatusText.setText(null);
	}
    };
    
    private boolean textHasChanged() {
	return (!mStatusText.getText().toString().equals(
		getPreferenceString(R.string.PreferenceStatusText)));
    }
    
    private boolean statusHasChanged() {
	return (mSettings.getInt(getString(R.string.PreferenceStatus),
		Status.CONTACT_STATUS_AVAILABLE) != getStatusId(mSelectedStatus));
    }
    
    private void showSettings() {
	mStatusText.setText(getPreferenceString(R.string.PreferenceStatusText));
	mSpin.setSelection(getPreferenceStatusId());
    }
    
    private String getPreferenceString(int id) {
	return mSettings.getString(getString(id), "");
    }
    
    private int getStatusId(String status) {
	if (status.equals(mStatus[0]))
	    return Status.CONTACT_STATUS_AVAILABLE; // 500
	if (status.equals(mStatus[1]))
	    return Status.CONTACT_STATUS_AVAILABLE_FOR_CHAT; // 600
	if (status.equals(mStatus[2]))
	    return Status.CONTACT_STATUS_BUSY; // 400
	if (status.equals(mStatus[3]))
	    return Status.CONTACT_STATUS_AWAY; // 300
	if (status.equals(mStatus[4]))
	    return Status.CONTACT_STATUS_UNAVAILABLE; // 200
	if (status.equals(mStatus[5]))
	    return Status.CONTACT_STATUS_DISCONNECT; // 100
	return Status.CONTACT_STATUS_AVAILABLE;
    }
    
    private int getPreferenceStatusId() {
	switch (mSettings.getInt(getString(R.string.PreferenceStatus),
		Status.CONTACT_STATUS_AVAILABLE)) {
	    case Status.CONTACT_STATUS_DISCONNECT:
		return 5;
	    case Status.CONTACT_STATUS_UNAVAILABLE:
		return 4;
	    case Status.CONTACT_STATUS_AWAY:
		return 3;
	    case Status.CONTACT_STATUS_BUSY:
		return 2;
	    case Status.CONTACT_STATUS_AVAILABLE:
		return 0;
	    case Status.CONTACT_STATUS_AVAILABLE_FOR_CHAT:
		return 1;
	    default:
		return 0;
	}
    }
}
