/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrtp.jlibrtp;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import org.jlibrtp.jlibrtp.Participant;
import org.jlibrtp.jlibrtp.RTPSession;

public class ParticipantDatabase {
    RTPSession rtpSession = null;
    LinkedList<Participant> receivers = new LinkedList();
    ConcurrentHashMap<Long, Participant> ssrcTable = new ConcurrentHashMap();

    protected ParticipantDatabase(RTPSession parent) {
        this.rtpSession = parent;
    }

    protected int addParticipant(int cameFrom, Participant p) {
        if (this.rtpSession.mcSession) {
            return this.addParticipantMulticast(cameFrom, p);
        }
        return this.addParticipantUnicast(cameFrom, p);
    }

    private int addParticipantMulticast(int cameFrom, Participant p) {
        if (cameFrom == 0) {
            System.out.println("ParticipantDatabase.addParticipant() doesnt expect application to add participants to multicast session.");
            return -1;
        }
        if (this.ssrcTable.contains(p.ssrc)) {
            System.out.println("ParticipantDatabase.addParticipant() SSRC already known " + Long.toString(p.ssrc));
            return -2;
        }
        this.ssrcTable.put(p.ssrc, p);
        return 0;
    }

    private int addParticipantUnicast(int cameFrom, Participant p) {
        if (cameFrom == 0) {
            boolean notDone = true;
            Enumeration<Participant> enu = this.ssrcTable.elements();
            while (notDone && enu.hasMoreElements()) {
                Participant part = enu.nextElement();
                if (!part.unexpected || !part.rtcpReceivedFromAddress.equals(part.rtcpAddress.getAddress()) && !part.rtpReceivedFromAddress.equals(part.rtpAddress.getAddress())) continue;
                part.rtpAddress = p.rtpAddress;
                part.rtcpAddress = p.rtcpAddress;
                part.unexpected = false;
                Participant[] partArray = new Participant[]{part};
                this.rtpSession.appIntf.userEvent(5, partArray);
                notDone = false;
                p = part;
            }
            this.receivers.add(p);
            return 0;
        }
        boolean notDone = true;
        Iterator iter = this.receivers.iterator();
        while (notDone && iter.hasNext()) {
            Participant part = (Participant)iter.next();
            if ((cameFrom != 1 || !p.rtpReceivedFromAddress.getAddress().equals(part.rtpAddress.getAddress())) && (cameFrom != 2 || !p.rtcpReceivedFromAddress.getAddress().equals(part.rtcpAddress.getAddress()))) continue;
            part.rtpReceivedFromAddress = p.rtpReceivedFromAddress;
            part.rtcpReceivedFromAddress = p.rtcpReceivedFromAddress;
            part.ssrc = p.ssrc;
            part.cname = p.cname;
            part.name = p.name;
            part.loc = p.loc;
            part.phone = p.phone;
            part.email = p.email;
            part.note = p.note;
            part.tool = p.tool;
            part.priv = p.priv;
            this.ssrcTable.put(part.ssrc, part);
            Participant[] partArray = new Participant[]{part};
            this.rtpSession.appIntf.userEvent(5, partArray);
            return 0;
        }
        this.ssrcTable.put(p.ssrc, p);
        return 0;
    }

    protected void removeParticipant(Participant p) {
        if (!this.rtpSession.mcSession) {
            this.receivers.remove(p);
        }
        this.ssrcTable.remove(p.ssrc, p);
    }

    protected Participant getParticipant(long ssrc) {
        Participant p = null;
        p = this.ssrcTable.get(ssrc);
        return p;
    }

    protected Iterator<Participant> getUnicastReceivers() {
        if (!this.rtpSession.mcSession) {
            return this.receivers.iterator();
        }
        System.out.println("Request for ParticipantDatabase.getUnicastReceivers in multicast session");
        return null;
    }

    protected Enumeration<Participant> getParticipants() {
        return this.ssrcTable.elements();
    }

    protected void debugPrint() {
        System.out.println("   ParticipantDatabase.debugPrint()");
        Enumeration<Participant> enu = this.ssrcTable.elements();
        while (enu.hasMoreElements()) {
            Participant p = enu.nextElement();
            System.out.println("           ssrcTable ssrc:" + p.ssrc + " cname:" + p.cname + " loc:" + p.loc + " rtpAddress:" + p.rtpAddress + " rtcpAddress:" + p.rtcpAddress);
        }
        for (Participant p : this.receivers) {
            System.out.println("           receivers: " + p.rtpAddress.toString());
        }
    }
}

