package com.beem.project.beem.ui;

import java.util.List;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.widget.EditText;
import android.widget.TextView;

import com.beem.project.beem.R;
import com.beem.project.beem.service.Contact;
import com.beem.project.beem.service.Message;
import com.beem.project.beem.service.PresenceAdapter;
import com.beem.project.beem.service.aidl.IBeemRosterListener;
import com.beem.project.beem.service.aidl.IChat;
import com.beem.project.beem.service.aidl.IMessageListener;
import com.beem.project.beem.service.aidl.IRoster;
import com.beem.project.beem.service.aidl.IXmppFacade;
import com.beem.project.beem.utils.BeemBroadcastReceiver;

public class Chat extends Activity {

    private static final String TAG = "Chat";
    private static final Intent SERVICE_INTENT = new Intent();
    static {
	SERVICE_INTENT.setComponent(new ComponentName("com.beem.project.beem", "com.beem.project.beem.BeemService"));
    }
    
    private Handler _handler = new Handler();
    
    private IRoster _roster;
    private Contact _contact;

    private TextView _contactNameTextView;
    private TextView _contactStatusMsgTextView;
    private EditText _input;
    
    private final ServiceConnection _conn = new BeemServiceConnection();
    private BeemBroadcastReceiver _broadcastReceiver;
    
    
    /**
     * Constructor.
     */
    public Chat() {
	super();
    }
    
    /**
     * {@inheritDoc}.
     */
    protected void onCreate(Bundle savedBundle) {
	super.onCreate(savedBundle);
	
	_contactNameTextView = (TextView) findViewById(R.id.chat_contact_name);
	_contactStatusMsgTextView = (TextView) findViewById(R.id.chat_contact_status_msg);
	
	setContentView(R.layout.chat);
	
	_broadcastReceiver = new BeemBroadcastReceiver(_conn);
	this.registerReceiver(_broadcastReceiver, new IntentFilter(BeemBroadcastReceiver.BEEM_CONNECTION_CLOSED));
    }
    
    /**
     * {@inheritDoc}.
     */
    protected void onDestroy() {
	super.onDestroy();
	this.unregisterReceiver(_broadcastReceiver);
    }
    
    /**
     * {@inheritDoc}.
     */
    protected void onStart() {
	super.onStart();
    }
    
    /**
     * {@inheritDoc}.
     */
    protected void onStop() {	
	super.onStop();
    }
    
    protected void onNewIntent(Intent intent) {
	super.onNewIntent(intent);
	
	_contact = new Contact(intent.getData());
    }
    
    /**
     * 
     * @author Jamu
     *
     */
    private final class BeemServiceConnection implements ServiceConnection {
	
	private IXmppFacade _xmppFacade;

	@Override
	public void onServiceConnected(ComponentName name, IBinder service) {
	    _xmppFacade = IXmppFacade.Stub.asInterface(service);
	    _broadcastReceiver.setBinded(true);
	    try {
		_roster = _xmppFacade.getRoster();
	    } catch (RemoteException e) {
		Log.e(TAG, e.getMessage());
	    }
	}
	
	@Override
	public void onServiceDisconnected(ComponentName name) {
	    _xmppFacade = null;
	    _broadcastReceiver.setBinded(false);
	}
    }
    

    /**
     * 
     * @author Jamu
     *
     */
    private class BeemRosterListener extends IBeemRosterListener.Stub {

	@Override
	public void onEntriesAdded(List<String> addresses) throws RemoteException {
	    // Nothing to do
	}

	@Override
	public void onEntriesDeleted(List<String> addresses) throws RemoteException {
	    // Nothing to do
	}

	@Override
	public void onEntriesUpdated(List<String> addresses) throws RemoteException {  
	    // Nothing to do
	}

	@Override
	public void onEntryDeleteFromGroup(String group, String jid) throws RemoteException {
	    // Nothing to do
	}

	@Override
	public void onPresenceChanged(PresenceAdapter presence) throws RemoteException {
	    // TODO Auto-generated method stub
	    
	}
    }
    
    /**
     * 
     * @author Jamu
     *
     */
    private class OnMessageListener extends IMessageListener.Stub {

	@Override
	public void processMessage(IChat chat, Message msg) throws RemoteException {
	    // TODO Auto-generated method stub
	}

	@Override
	public void stateChanged(IChat chat) throws RemoteException {
	    // TODO Auto-generated method stub
	    
	}
    }
}
