/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.jivesoftware.smack.RosterGroup;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.RosterPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RosterEntry {
    private String user;
    private String name;
    private RosterPacket.ItemType type;
    private RosterPacket.ItemStatus status;
    private XMPPConnection connection;

    RosterEntry(String string, String string2, RosterPacket.ItemType itemType, RosterPacket.ItemStatus itemStatus, XMPPConnection xMPPConnection) {
        this.user = string;
        this.name = string2;
        this.type = itemType;
        this.status = itemStatus;
        this.connection = xMPPConnection;
    }

    public String getUser() {
        return this.user;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string != null && string.equals(this.name)) {
            return;
        }
        this.name = string;
        RosterPacket rosterPacket = new RosterPacket();
        rosterPacket.setType(IQ.Type.SET);
        rosterPacket.addRosterItem(RosterEntry.toRosterItem(this));
        this.connection.sendPacket(rosterPacket);
    }

    void updateState(String string, RosterPacket.ItemType itemType, RosterPacket.ItemStatus itemStatus) {
        this.name = string;
        this.type = itemType;
        this.status = itemStatus;
    }

    public Collection<RosterGroup> getGroups() {
        ArrayList<RosterGroup> arrayList = new ArrayList<RosterGroup>();
        for (RosterGroup rosterGroup : this.connection.roster.getGroups()) {
            if (!rosterGroup.contains(this)) continue;
            arrayList.add(rosterGroup);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public RosterPacket.ItemType getType() {
        return this.type;
    }

    public RosterPacket.ItemStatus getStatus() {
        return this.status;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.name != null) {
            stringBuilder.append(this.name).append(": ");
        }
        stringBuilder.append(this.user);
        Collection<RosterGroup> collection = this.getGroups();
        if (!collection.isEmpty()) {
            stringBuilder.append(" [");
            Iterator<RosterGroup> iterator = collection.iterator();
            RosterGroup rosterGroup = iterator.next();
            stringBuilder.append(rosterGroup.getName());
            while (iterator.hasNext()) {
                stringBuilder.append(", ");
                rosterGroup = iterator.next();
                stringBuilder.append(rosterGroup.getName());
            }
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof RosterEntry) {
            return this.user.equals(((RosterEntry)object).getUser());
        }
        return false;
    }

    static RosterPacket.Item toRosterItem(RosterEntry rosterEntry) {
        RosterPacket.Item item = new RosterPacket.Item(rosterEntry.getUser(), rosterEntry.getName());
        item.setItemType(rosterEntry.getType());
        item.setItemStatus(rosterEntry.getStatus());
        for (RosterGroup rosterGroup : rosterEntry.getGroups()) {
            item.addGroupName(rosterGroup.getName());
        }
        return item;
    }
}

