/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.UnknownFormatConversionException;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.packet.DataForm;
import org.jivesoftware.smackx.pubsub.FormType;
import org.jivesoftware.smackx.pubsub.PresenceState;
import org.jivesoftware.smackx.pubsub.SubscribeOptionFields;

public class SubscribeForm
extends Form {
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public SubscribeForm(DataForm dataForm) {
        super(dataForm);
    }

    public SubscribeForm(Form form) {
        super(form.getDataFormToSend());
    }

    public SubscribeForm(FormType formType) {
        super(formType.toString());
    }

    public boolean isDeliverOn() {
        return SubscribeForm.parseBoolean(this.getFieldValue(SubscribeOptionFields.deliver));
    }

    public void setDeliverOn(boolean bl) {
        this.addField(SubscribeOptionFields.deliver, "boolean");
        this.setAnswer(SubscribeOptionFields.deliver.getFieldName(), bl);
    }

    public boolean isDigestOn() {
        return SubscribeForm.parseBoolean(this.getFieldValue(SubscribeOptionFields.digest));
    }

    public void setDigestOn(boolean bl) {
        this.addField(SubscribeOptionFields.deliver, "boolean");
        this.setAnswer(SubscribeOptionFields.deliver.getFieldName(), bl);
    }

    public int getDigestFrequency() {
        return Integer.parseInt(this.getFieldValue(SubscribeOptionFields.digest_frequency));
    }

    public void setDigestFrequency(int n) {
        this.addField(SubscribeOptionFields.digest_frequency, "text-single");
        this.setAnswer(SubscribeOptionFields.digest_frequency.getFieldName(), n);
    }

    public Date getExpiry() {
        String string = this.getFieldValue(SubscribeOptionFields.expire);
        try {
            return format.parse(string);
        }
        catch (ParseException parseException) {
            UnknownFormatConversionException unknownFormatConversionException = new UnknownFormatConversionException(string);
            unknownFormatConversionException.initCause(parseException);
            throw unknownFormatConversionException;
        }
    }

    public void setExpiry(Date date) {
        this.addField(SubscribeOptionFields.expire, "text-single");
        this.setAnswer(SubscribeOptionFields.expire.getFieldName(), format.format(date));
    }

    public boolean isIncludeBody() {
        return SubscribeForm.parseBoolean(this.getFieldValue(SubscribeOptionFields.include_body));
    }

    public void setIncludeBody(boolean bl) {
        this.addField(SubscribeOptionFields.include_body, "boolean");
        this.setAnswer(SubscribeOptionFields.include_body.getFieldName(), bl);
    }

    public Iterator<PresenceState> getShowValues() {
        ArrayList<PresenceState> arrayList = new ArrayList<PresenceState>(5);
        Iterator<String> iterator = this.getFieldValues(SubscribeOptionFields.show_values);
        while (iterator.hasNext()) {
            String string = iterator.next();
            arrayList.add(PresenceState.valueOf(string));
        }
        return arrayList.iterator();
    }

    public void setShowValues(Collection<PresenceState> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (PresenceState presenceState : collection) {
            arrayList.add(presenceState.toString());
        }
        this.addField(SubscribeOptionFields.show_values, "list-multi");
        this.setAnswer(SubscribeOptionFields.show_values.getFieldName(), arrayList);
    }

    private static boolean parseBoolean(String string) {
        return "1".equals(string) || "true".equals(string);
    }

    private String getFieldValue(SubscribeOptionFields subscribeOptionFields) {
        FormField formField = this.getField(subscribeOptionFields.getFieldName());
        return formField.getValues().next();
    }

    private Iterator<String> getFieldValues(SubscribeOptionFields subscribeOptionFields) {
        FormField formField = this.getField(subscribeOptionFields.getFieldName());
        return formField.getValues();
    }

    private void addField(SubscribeOptionFields subscribeOptionFields, String string) {
        String string2 = subscribeOptionFields.getFieldName();
        if (this.getField(string2) == null) {
            FormField formField = new FormField(string2);
            formField.setType(string);
            this.addField(formField);
        }
    }
}

