/**
    BEEM is a videoconference application on the Android Platform.

    Copyright (C) 2009 by Frederic-Charles Barthelery,
                          Jean-Manuel Da Silva,
                          Nikita Kozlov,
                          Philippe Lago,
                          Jean Baptiste Vergely,
                          Vincent Véronis.

    This file is part of BEEM.

    BEEM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BEEM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BEEM.  If not, see <http://www.gnu.org/licenses/>.

    Please send bug reports with examples or suggestions to
    contact@beem-project.com or http://dev.beem-project.com/

    Epitech, hereby disclaims all copyright interest in the program “Beem”
    written by Frederic-Charles Barthelery,
               Jean-Manuel Da Silva,
               Nikita Kozlov,
               Philippe Lago,
               Jean Baptiste Vergely,
               Vincent Veronis.

    Nicolas Sadirac, November 26, 2009
    President of Epitech.

    Flavien Astraud, November 26, 2009
    Head of the EIP Laboratory.

*/
package com.beem.project.beem.jingle;

import java.net.DatagramSocket;
import java.net.SocketException;

import org.jlibrtp.jlibrtp.DataFrame;
import org.jlibrtp.jlibrtp.Participant;
import org.jlibrtp.jlibrtp.RTPAppIntf;
import org.jlibrtp.jlibrtp.RTPSession;

import com.beem.project.beem.utils.FreePort;

// TODO: Auto-generated Javadoc
/**
 * abstract RTP transmitter class.
 * @author nikita
 */
public abstract class RTPTransmitter implements Runnable, RTPAppIntf {
    /**
     * RTPSession instance.
     */
    private RTPSession mRtpSession;
    /**
     * process status manipulation.
     */
    private boolean mKillme;

    /**
     * constructor.
     * @param remoteIP receiver IP.
     * @param remotePort receiver port.
     */
    public RTPTransmitter(final String remoteIP, final int remotePort) {
	DatagramSocket rtpSocket = null;
	int rtpPort = 0;

	try {
	    rtpPort = FreePort.getFreePort();
	    rtpSocket = new DatagramSocket(rtpPort);
	} catch (SocketException e) {
	    e.printStackTrace();
	    return;
	}
	setRtpSession(new RTPSession(rtpSocket, null));
	getRtpSession().naivePktReception(true);
	getRtpSession().RTPSessionRegister(this, null, null);
	getRtpSession().addParticipant(new Participant(remoteIP, remotePort, 0));
    }

    /* (non-Javadoc)
     * @see org.jlibrtp.jlibrtp.RTPAppIntf#frameSize(int)
     */
    @Override
    public int frameSize(int payloadType) {
	return 1;
    }

    /* (non-Javadoc)
     * @see org.jlibrtp.jlibrtp.RTPAppIntf#receiveData(org.jlibrtp.jlibrtp.DataFrame, org.jlibrtp.jlibrtp.Participant)
     */
    @Override
    public void receiveData(DataFrame frame, Participant participant) {
	// On envoie uniquement
    }

    /* (non-Javadoc)
     * @see java.lang.Runnable#run()
     */
    @Override
    public void run() {
	start();
    }

    /**
     * A implementer pour chaque type d'envoi specifique.
     */
    abstract void start();

    /**
     * Stop the transmission.
     */
    public void stop() {
	mKillme = true;
    }

    /* (non-Javadoc)
     * @see org.jlibrtp.jlibrtp.RTPAppIntf#userEvent(int, org.jlibrtp.jlibrtp.Participant[])
     */
    @Override
    public void userEvent(int type, Participant[] participant) {
	// je sais pas ce que c'est

    }

    /**
     * mKillme setter.
     * @param killme the mKillme to set
     */
    public void setKillme(final boolean killme) {
	this.mKillme = killme;
    }

    /**
     * mKillme getter.
     * @return the mKillme.
     */
    public boolean isKillme() {
	return mKillme;
    }

    /**
     * mRtpSession setter.
     * @param rtpSession the mRtpSession to set.
     */
    public void setRtpSession(RTPSession rtpSession) {
	this.mRtpSession = rtpSession;
    }

    /**
     * mRtpSession getter.
     * @return the mRtpSession
     */
    public RTPSession getRtpSession() {
	return mRtpSession;
    }

}
