/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;
import security.javax.security.sasl.SaslException;

abstract class CramMD5Base {
    protected boolean completed = false;
    protected boolean aborted = false;
    protected byte[] pw;
    private static final int MD5_BLOCKSIZE = 64;
    private static final String SASL_LOGGER_NAME = "javax.security.sasl";
    protected static Logger logger;

    protected CramMD5Base() {
        CramMD5Base.initLogger();
    }

    public String getMechanismName() {
        return "CRAM-MD5";
    }

    public boolean isComplete() {
        return this.completed;
    }

    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("CRAM-MD5 supports neither integrity nor privacy");
        }
        throw new IllegalStateException("CRAM-MD5 authentication not completed");
    }

    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("CRAM-MD5 supports neither integrity nor privacy");
        }
        throw new IllegalStateException("CRAM-MD5 authentication not completed");
    }

    public Object getNegotiatedProperty(String propName) {
        if (this.completed) {
            if (propName.equals("javax.security.sasl.qop")) {
                return "auth";
            }
            return null;
        }
        throw new IllegalStateException("CRAM-MD5 authentication not completed");
    }

    public void dispose() throws SaslException {
        this.clearPassword();
    }

    protected void clearPassword() {
        if (this.pw != null) {
            int i = 0;
            while (i < this.pw.length) {
                this.pw[i] = 0;
                ++i;
            }
            this.pw = null;
        }
    }

    protected void finalize() {
        this.clearPassword();
    }

    /*
     * Unable to fully structure code
     */
    static final String HMAC_MD5(byte[] key, byte[] text) throws NoSuchAlgorithmException {
        md5 = MessageDigest.getInstance("MD5");
        if (key.length > 64) {
            key = md5.digest(key);
        }
        ipad = new byte[64];
        opad = new byte[64];
        i = 0;
        ** GOTO lbl16
        {
            ipad[i] = key[i];
            opad[i] = key[i];
            ++i;
            do {
                if (i < key.length) continue block0;
                ipad[i] = 0;
                opad[i] = 0;
                ++i;
lbl16:
                // 2 sources

            } while (i < 64);
        }
        i = 0;
        while (i < 64) {
            v0 = i;
            ipad[v0] = (byte)(ipad[v0] ^ 54);
            v1 = i++;
            opad[v1] = (byte)(opad[v1] ^ 92);
        }
        md5.update(ipad);
        md5.update(text);
        digest = md5.digest();
        md5.update(opad);
        md5.update(digest);
        digest = md5.digest();
        digestString = new StringBuffer();
        i = 0;
        while (i < digest.length) {
            if ((digest[i] & 255) < 16) {
                digestString.append("0" + Integer.toHexString(digest[i] & 255));
            } else {
                digestString.append(Integer.toHexString(digest[i] & 255));
            }
            ++i;
        }
        return digestString.toString();
    }

    private static synchronized void initLogger() {
        if (logger == null) {
            logger = Logger.getLogger(SASL_LOGGER_NAME);
        }
    }
}

