/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.NodeInformationProvider;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.commands.AdHocCommand;
import org.jivesoftware.smackx.commands.LocalCommand;
import org.jivesoftware.smackx.commands.LocalCommandFactory;
import org.jivesoftware.smackx.commands.RemoteCommand;
import org.jivesoftware.smackx.packet.AdHocCommandData;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;

public class AdHocCommandManager {
    private static final String DISCO_NAMESPACE = "http://jabber.org/protocol/commands";
    private static final String discoNode = "http://jabber.org/protocol/commands";
    private static final int SESSION_TIMEOUT = 120;
    private static Map<Connection, AdHocCommandManager> instances = new ConcurrentHashMap<Connection, AdHocCommandManager>();
    private Thread sessionsSweeper;
    private Connection connection;
    private Map<String, AdHocCommandInfo> commands = Collections.synchronizedMap(new WeakHashMap());
    private Map<String, LocalCommand> executingCommands = new ConcurrentHashMap<String, LocalCommand>();

    public static AdHocCommandManager getAddHocCommandsManager(Connection connection) {
        return instances.get(connection);
    }

    private AdHocCommandManager(Connection connection) {
        this.connection = connection;
        this.init();
    }

    public void registerCommand(String string, String string2, final Class clazz) {
        this.registerCommand(string, string2, new LocalCommandFactory(){

            @Override
            public LocalCommand getInstance() throws InstantiationException, IllegalAccessException {
                return (LocalCommand)clazz.newInstance();
            }
        });
    }

    public void registerCommand(String string, final String string2, LocalCommandFactory localCommandFactory) {
        AdHocCommandInfo adHocCommandInfo = new AdHocCommandInfo(string, string2, this.connection.getUser(), localCommandFactory);
        this.commands.put(string, adHocCommandInfo);
        ServiceDiscoveryManager.getInstanceFor(this.connection).setNodeInformationProvider(string, new NodeInformationProvider(){

            @Override
            public List<DiscoverItems.Item> getNodeItems() {
                return null;
            }

            @Override
            public List<String> getNodeFeatures() {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("http://jabber.org/protocol/commands");
                arrayList.add("jabber:x:data");
                return arrayList;
            }

            @Override
            public List<DiscoverInfo.Identity> getNodeIdentities() {
                ArrayList<DiscoverInfo.Identity> arrayList = new ArrayList<DiscoverInfo.Identity>();
                DiscoverInfo.Identity identity = new DiscoverInfo.Identity("automation", string2);
                identity.setType("command-node");
                arrayList.add(identity);
                return arrayList;
            }
        });
    }

    public DiscoverItems discoverCommands(String string) throws XMPPException {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection);
        return serviceDiscoveryManager.discoverItems(string, "http://jabber.org/protocol/commands");
    }

    public void publishCommands(String string) throws XMPPException {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection);
        DiscoverItems discoverItems = new DiscoverItems();
        Collection<AdHocCommandInfo> collection = this.getRegisteredCommands();
        for (AdHocCommandInfo adHocCommandInfo : collection) {
            DiscoverItems.Item item = new DiscoverItems.Item(adHocCommandInfo.getOwnerJID());
            item.setName(adHocCommandInfo.getName());
            item.setNode(adHocCommandInfo.getNode());
            discoverItems.addItem(item);
        }
        serviceDiscoveryManager.publishItems(string, "http://jabber.org/protocol/commands", discoverItems);
    }

    public RemoteCommand getRemoteCommand(String string, String string2) {
        return new RemoteCommand(this.connection, string2, string);
    }

    private void init() {
        instances.put(this.connection, this);
        this.connection.addConnectionListener(new ConnectionListener(){

            @Override
            public void connectionClosed() {
                instances.remove(AdHocCommandManager.this.connection);
            }

            @Override
            public void connectionClosedOnError(Exception exception) {
                instances.remove(AdHocCommandManager.this.connection);
            }

            @Override
            public void reconnectionSuccessful() {
                instances.put(AdHocCommandManager.this.connection, AdHocCommandManager.this);
            }

            @Override
            public void reconnectingIn(int n) {
            }

            @Override
            public void reconnectionFailed(Exception exception) {
            }
        });
        ServiceDiscoveryManager.getInstanceFor(this.connection).addFeature("http://jabber.org/protocol/commands");
        ServiceDiscoveryManager.getInstanceFor(this.connection).setNodeInformationProvider("http://jabber.org/protocol/commands", new NodeInformationProvider(){

            @Override
            public List<DiscoverItems.Item> getNodeItems() {
                ArrayList<DiscoverItems.Item> arrayList = new ArrayList<DiscoverItems.Item>();
                Collection collection = AdHocCommandManager.this.getRegisteredCommands();
                for (AdHocCommandInfo adHocCommandInfo : collection) {
                    DiscoverItems.Item item = new DiscoverItems.Item(adHocCommandInfo.getOwnerJID());
                    item.setName(adHocCommandInfo.getName());
                    item.setNode(adHocCommandInfo.getNode());
                    arrayList.add(item);
                }
                return arrayList;
            }

            @Override
            public List<String> getNodeFeatures() {
                return null;
            }

            @Override
            public List<DiscoverInfo.Identity> getNodeIdentities() {
                return null;
            }
        });
        PacketListener packetListener = new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                AdHocCommandData adHocCommandData = (AdHocCommandData)packet;
                AdHocCommandManager.this.processAdHocCommand(adHocCommandData);
            }
        };
        PacketTypeFilter packetTypeFilter = new PacketTypeFilter(AdHocCommandData.class);
        this.connection.addPacketListener(packetListener, packetTypeFilter);
        this.sessionsSweeper = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAdHocCommand(AdHocCommandData adHocCommandData) {
        if (adHocCommandData.getType() != IQ.Type.SET) {
            return;
        }
        AdHocCommandData adHocCommandData2 = new AdHocCommandData();
        adHocCommandData2.setTo(adHocCommandData.getFrom());
        adHocCommandData2.setPacketID(adHocCommandData.getPacketID());
        adHocCommandData2.setNode(adHocCommandData.getNode());
        adHocCommandData2.setId(adHocCommandData.getTo());
        String string = adHocCommandData.getSessionID();
        String string2 = adHocCommandData.getNode();
        if (string == null) {
            if (!this.commands.containsKey(string2)) {
                this.respondError(adHocCommandData2, XMPPError.Condition.item_not_found);
                return;
            }
            string = StringUtils.randomString(15);
            try {
                LocalCommand localCommand = this.newInstanceOfCmd(string2, string);
                adHocCommandData2.setType(IQ.Type.RESULT);
                localCommand.setData(adHocCommandData2);
                if (!localCommand.hasPermission(adHocCommandData.getFrom())) {
                    this.respondError(adHocCommandData2, XMPPError.Condition.forbidden);
                    return;
                }
                AdHocCommand.Action action = adHocCommandData.getAction();
                if (action != null && action.equals((Object)AdHocCommand.Action.unknown)) {
                    this.respondError(adHocCommandData2, XMPPError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.malformedAction);
                    return;
                }
                if (action != null && !action.equals((Object)AdHocCommand.Action.execute)) {
                    this.respondError(adHocCommandData2, XMPPError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.badAction);
                    return;
                }
                localCommand.incrementStage();
                localCommand.execute();
                if (localCommand.isLastStage()) {
                    adHocCommandData2.setStatus(AdHocCommand.Status.completed);
                } else {
                    adHocCommandData2.setStatus(AdHocCommand.Status.executing);
                    this.executingCommands.put(string, localCommand);
                    if (this.sessionsSweeper == null) {
                        this.sessionsSweeper = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                while (true) {
                                    for (String string : AdHocCommandManager.this.executingCommands.keySet()) {
                                        LocalCommand localCommand = (LocalCommand)AdHocCommandManager.this.executingCommands.get(string);
                                        if (localCommand == null) continue;
                                        long l = localCommand.getCreationDate();
                                        if (System.currentTimeMillis() - l <= 240000L) continue;
                                        AdHocCommandManager.this.executingCommands.remove(string);
                                    }
                                    try {
                                        Thread.sleep(1000L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                    }
                                }
                            }
                        });
                        this.sessionsSweeper.setDaemon(true);
                        this.sessionsSweeper.start();
                    }
                }
                this.connection.sendPacket(adHocCommandData2);
            }
            catch (XMPPException xMPPException) {
                XMPPError xMPPError = xMPPException.getXMPPError();
                if (XMPPError.Type.CANCEL.equals((Object)xMPPError.getType())) {
                    adHocCommandData2.setStatus(AdHocCommand.Status.canceled);
                    this.executingCommands.remove(string);
                }
                this.respondError(adHocCommandData2, xMPPError);
                xMPPException.printStackTrace();
            }
        } else {
            LocalCommand localCommand = this.executingCommands.get(string);
            if (localCommand == null) {
                this.respondError(adHocCommandData2, XMPPError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.badSessionid);
                return;
            }
            long l = localCommand.getCreationDate();
            if (System.currentTimeMillis() - l > 120000L) {
                this.executingCommands.remove(string);
                this.respondError(adHocCommandData2, XMPPError.Condition.not_allowed, AdHocCommand.SpecificErrorCondition.sessionExpired);
                return;
            }
            LocalCommand localCommand2 = localCommand;
            synchronized (localCommand2) {
                AdHocCommand.Action action = adHocCommandData.getAction();
                if (action != null && action.equals((Object)AdHocCommand.Action.unknown)) {
                    this.respondError(adHocCommandData2, XMPPError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.malformedAction);
                    return;
                }
                if (action == null || AdHocCommand.Action.execute.equals((Object)action)) {
                    action = localCommand.getExecuteAction();
                }
                if (!localCommand.isValidAction(action)) {
                    this.respondError(adHocCommandData2, XMPPError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.badAction);
                    return;
                }
                try {
                    adHocCommandData2.setType(IQ.Type.RESULT);
                    localCommand.setData(adHocCommandData2);
                    if (AdHocCommand.Action.next.equals((Object)action)) {
                        localCommand.incrementStage();
                        localCommand.next(new Form(adHocCommandData.getForm()));
                        if (localCommand.isLastStage()) {
                            adHocCommandData2.setStatus(AdHocCommand.Status.completed);
                        } else {
                            adHocCommandData2.setStatus(AdHocCommand.Status.executing);
                        }
                    } else if (AdHocCommand.Action.complete.equals((Object)action)) {
                        localCommand.incrementStage();
                        localCommand.complete(new Form(adHocCommandData.getForm()));
                        adHocCommandData2.setStatus(AdHocCommand.Status.completed);
                        this.executingCommands.remove(string);
                    } else if (AdHocCommand.Action.prev.equals((Object)action)) {
                        localCommand.decrementStage();
                        localCommand.prev();
                    } else if (AdHocCommand.Action.cancel.equals((Object)action)) {
                        localCommand.cancel();
                        adHocCommandData2.setStatus(AdHocCommand.Status.canceled);
                        this.executingCommands.remove(string);
                    }
                    this.connection.sendPacket(adHocCommandData2);
                }
                catch (XMPPException xMPPException) {
                    XMPPError xMPPError = xMPPException.getXMPPError();
                    if (XMPPError.Type.CANCEL.equals((Object)xMPPError.getType())) {
                        adHocCommandData2.setStatus(AdHocCommand.Status.canceled);
                        this.executingCommands.remove(string);
                    }
                    this.respondError(adHocCommandData2, xMPPError);
                    xMPPException.printStackTrace();
                }
            }
        }
    }

    private void respondError(AdHocCommandData adHocCommandData, XMPPError.Condition condition) {
        this.respondError(adHocCommandData, new XMPPError(condition));
    }

    private void respondError(AdHocCommandData adHocCommandData, XMPPError.Condition condition, AdHocCommand.SpecificErrorCondition specificErrorCondition) {
        XMPPError xMPPError = new XMPPError(condition);
        xMPPError.addExtension(new AdHocCommandData.SpecificError(specificErrorCondition));
        this.respondError(adHocCommandData, xMPPError);
    }

    private void respondError(AdHocCommandData adHocCommandData, XMPPError xMPPError) {
        adHocCommandData.setType(IQ.Type.ERROR);
        adHocCommandData.setError(xMPPError);
        this.connection.sendPacket(adHocCommandData);
    }

    private LocalCommand newInstanceOfCmd(String string, String string2) throws XMPPException {
        LocalCommand localCommand;
        AdHocCommandInfo adHocCommandInfo = this.commands.get(string);
        try {
            localCommand = adHocCommandInfo.getCommandInstance();
            localCommand.setSessionID(string2);
            localCommand.setName(adHocCommandInfo.getName());
            localCommand.setNode(adHocCommandInfo.getNode());
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            throw new XMPPException(new XMPPError(XMPPError.Condition.interna_server_error));
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            throw new XMPPException(new XMPPError(XMPPError.Condition.interna_server_error));
        }
        return localCommand;
    }

    private Collection<AdHocCommandInfo> getRegisteredCommands() {
        return this.commands.values();
    }

    static {
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(Connection connection) {
                new AdHocCommandManager(connection);
            }
        });
    }

    private static class AdHocCommandInfo {
        private String node;
        private String name;
        private String ownerJID;
        private LocalCommandFactory factory;

        public AdHocCommandInfo(String string, String string2, String string3, LocalCommandFactory localCommandFactory) {
            this.node = string;
            this.name = string2;
            this.ownerJID = string3;
            this.factory = localCommandFactory;
        }

        public LocalCommand getCommandInstance() throws InstantiationException, IllegalAccessException {
            return this.factory.getInstance();
        }

        public String getName() {
            return this.name;
        }

        public String getNode() {
            return this.node;
        }

        public String getOwnerJID() {
            return this.ownerJID;
        }
    }
}

