package com.beem.project.beem.ui;

import org.jivesoftware.smack.packet.Presence;

import android.app.Activity;
import android.app.Dialog;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.view.View;
import android.widget.Button;

import com.beem.project.beem.BeemService;
import com.beem.project.beem.R;
import com.beem.project.beem.service.Contact;
import com.beem.project.beem.service.PresenceAdapter;
import com.beem.project.beem.service.aidl.IXmppFacade;

public class ContactDialog extends Dialog {

    public static final String TAG = "Option Dialog";
    private final Contact mContact;
    private final Context mContext;
    private IXmppFacade xmppFacade = null;
    private final ServiceConnection mServConn = new BeemServiceConnection();

    public ContactDialog(final Context context, Contact curContact) {
	super(context);
	mContext = context;

	setContentView(R.layout.contactdialog);
	mContact = curContact;
	setTitle(curContact.getJID());

	Button button = (Button) findViewById(R.id.CDChat);
	button.setOnClickListener(new chatListener());
	button = (Button) findViewById(R.id.CDAlias);
	button.setOnClickListener(new aliasListener());
	button = (Button) findViewById(R.id.CDGroup);
	button.setOnClickListener(new groupListener());
	button = (Button) findViewById(R.id.CDResend);
	button.setOnClickListener(new resendListener());
	button = (Button) findViewById(R.id.CDInfos);
	button.setOnClickListener(new infosListener());
	
	mContext.bindService(new Intent(mContext, BeemService.class), mServConn, Service.BIND_AUTO_CREATE);
    }

    class aliasListener implements View.OnClickListener {

	@Override
	public void onClick(View v) {

	    ContactDialogAliasDialog dialog = new ContactDialogAliasDialog(mContext, mContact);
	    dialog.setOwnerActivity(ContactDialog.this.getOwnerActivity());
	    dialog.initService();
	    dialog.show();
	}

    }

    class chatListener implements View.OnClickListener {

	@Override
	public void onClick(View v) {
	    Activity a = ContactDialog.this.getOwnerActivity();
	    Intent i = new Intent(mContext, SendIM.class);
	    i.setData(mContact.toUri());
	    a.startActivity(i);
	    dismiss();
	}

    }

    class groupListener implements View.OnClickListener {

	@Override
	public void onClick(View v) {
	    // TODO Auto-generated method stub
	    dismiss();
	}

    }

    class infosListener implements View.OnClickListener {

	@Override
	public void onClick(View v) {
	    // TODO Auto-generated method stub
	    dismiss();
	}

    }

    class resendListener implements View.OnClickListener {

	@Override
	public void onClick(View v) {
	    Presence presencePacket = new Presence(Presence.Type.subscribe);
	    presencePacket.setTo(mContact.getJID());
	    try {
		xmppFacade.sendPresencePacket(new PresenceAdapter(presencePacket));
	    } catch (RemoteException e) {
		Log.e(TAG, "resend subscription error", e);
	    }
	    dismiss();
	}

    }

    private class BeemServiceConnection implements ServiceConnection {

	@Override
	public void onServiceConnected(ComponentName name, IBinder service) {
	    xmppFacade = IXmppFacade.Stub.asInterface(service);
	}

	@Override
	public void onServiceDisconnected(ComponentName name) {
	    xmppFacade = null;
	}
    }

}
