/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrtp.jlibrtp.core;

import org.jlibrtp.jlibrtp.core.RtcpPkt;
import org.jlibrtp.jlibrtp.core.StaticProcs;

public class RtcpPktBYE
extends RtcpPkt {
    protected long[] ssrcArray = null;
    protected byte[] reason = null;

    protected RtcpPktBYE(long[] ssrcs, byte[] aReason) {
        this.packetType = 203;
        this.reason = aReason;
        this.ssrcArray = ssrcs;
        if (ssrcs.length < 1) {
            System.out.println("RtcpBYE.RtcpPktBYE(long[] ssrcs, byte[] aReason) requires at least one SSRC!");
        }
    }

    protected RtcpPktBYE(byte[] aRawPkt, int start) {
        this.rawPkt = aRawPkt;
        if (!super.parseHeaders(start) || this.packetType != 203) {
            this.problem = -203;
        } else {
            this.ssrcArray = new long[this.itemCount];
            int i = 0;
            while (i < this.itemCount) {
                this.ssrcArray[i] = StaticProcs.bytesToUIntLong(aRawPkt, start + (i + 1) * 4);
                ++i;
            }
            if (this.length > this.itemCount + 1) {
                byte reasonLength = aRawPkt[start + (this.itemCount + 1) * 4];
                this.reason = new byte[reasonLength];
                System.arraycopy(aRawPkt, start + (this.itemCount + 1) * 4 + 1, this.reason, 0, reasonLength);
            }
        }
    }

    @Override
    protected void encode() {
        this.itemCount = this.ssrcArray.length;
        this.length = 4 * this.ssrcArray.length;
        if (this.reason != null) {
            this.length += (this.reason.length + 1) / 4;
            if ((this.reason.length + 1) % 4 != 0) {
                ++this.length;
            }
        }
        this.rawPkt = new byte[this.length * 4 + 4];
        int i = 0;
        while (i < this.ssrcArray.length) {
            byte[] someBytes = StaticProcs.uIntLongToByteWord(this.ssrcArray[i]);
            System.arraycopy(someBytes, 0, this.rawPkt, 4 + 4 * i, 4);
            ++i;
        }
        if (this.reason != null) {
            this.rawPkt[4 + 4 * this.ssrcArray.length] = (byte)this.reason.length;
            System.arraycopy(this.reason, 0, this.rawPkt, 4 + 4 * i + 1, this.reason.length);
        }
        super.writeHeaders();
    }

    public void debugPrint() {
        System.out.println("RtcpPktBYE.debugPrint() ");
        if (this.ssrcArray != null) {
            int i = 0;
            while (i < this.ssrcArray.length) {
                long anSsrc = this.ssrcArray[i];
                System.out.println("     ssrc: " + anSsrc);
                ++i;
            }
        }
        if (this.reason != null) {
            System.out.println("     Reason: " + new String(this.reason));
        }
    }
}

