/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrtp.jlibrtp.core;

import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jlibrtp.jlibrtp.core.RTPSession;
import org.jlibrtp.jlibrtp.core.RtcpPkt;
import org.jlibrtp.jlibrtp.core.RtcpPktAPP;
import org.jlibrtp.jlibrtp.core.RtcpPktBYE;
import org.jlibrtp.jlibrtp.core.RtcpPktPSFB;
import org.jlibrtp.jlibrtp.core.RtcpPktRR;
import org.jlibrtp.jlibrtp.core.RtcpPktRTPFB;
import org.jlibrtp.jlibrtp.core.RtcpPktSDES;
import org.jlibrtp.jlibrtp.core.RtcpPktSR;
import org.jlibrtp.jlibrtp.core.StaticProcs;

public class CompRtcpPkt {
    protected int problem = 0;
    protected LinkedList<RtcpPkt> rtcpPkts = new LinkedList();

    protected CompRtcpPkt() {
    }

    protected void addPacket(RtcpPkt aPkt) {
        if (aPkt.problem == 0) {
            this.rtcpPkts.add(aPkt);
        } else {
            this.problem = aPkt.problem;
        }
    }

    protected CompRtcpPkt(byte[] rawPkt, int packetSize, InetSocketAddress adr, RTPSession rtpSession) {
        int start = 0;
        while (start < packetSize && this.problem == 0) {
            int pktType;
            int length = StaticProcs.bytesToUIntInt(rawPkt, start + 2) + 1;
            if (length * 4 + start > rawPkt.length) {
                System.out.println("!!!! CompRtcpPkt.(rawPkt,..,..) length (" + (length * 4 + start) + ") exceeds size of raw packet (" + rawPkt.length + ") !");
                this.problem = -3;
            }
            if ((pktType = rawPkt[start + 1]) < 0) {
                pktType += 256;
            }
            if (start == 0) {
                if (pktType != 200 && pktType != 201) {
                    this.problem = -1;
                }
                if ((rawPkt[start] & 0x20) >>> 5 == 1) {
                    this.problem = -2;
                }
            }
            if (pktType == 200) {
                this.addPacket(new RtcpPktSR(rawPkt, start, length * 4));
            } else if (pktType == 201) {
                this.addPacket(new RtcpPktRR(rawPkt, start, -1));
            } else if (pktType == 202) {
                this.addPacket(new RtcpPktSDES(rawPkt, start, adr, rtpSession.partDb));
            } else if (pktType == 203) {
                this.addPacket(new RtcpPktBYE(rawPkt, start));
            } else if (pktType == 204) {
                this.addPacket(new RtcpPktAPP(rawPkt, start));
            } else if (pktType == 205) {
                this.addPacket(new RtcpPktRTPFB(rawPkt, start, rtpSession));
            } else if (pktType == 206) {
                this.addPacket(new RtcpPktPSFB(rawPkt, start, rtpSession));
            } else {
                System.out.println("!!!! CompRtcpPkt(byte[] rawPkt, int packetSize...) UNKNOWN RTCP PACKET TYPE:" + pktType);
            }
            start += length * 4;
        }
    }

    protected byte[] encode() {
        ListIterator iter = this.rtcpPkts.listIterator();
        byte[] rawPkt = new byte[1500];
        int index = 0;
        while (iter.hasNext()) {
            RtcpPkt pkt;
            RtcpPkt aPkt = (RtcpPkt)iter.next();
            if (aPkt.packetType == 200) {
                pkt = (RtcpPktSR)aPkt;
                ((RtcpPktSR)pkt).encode();
                System.arraycopy(((RtcpPktSR)pkt).rawPkt, 0, rawPkt, index, ((RtcpPktSR)pkt).rawPkt.length);
                index += ((RtcpPktSR)pkt).rawPkt.length;
                continue;
            }
            if (aPkt.packetType == 201) {
                pkt = (RtcpPktRR)aPkt;
                ((RtcpPktRR)pkt).encode();
                System.arraycopy(((RtcpPktRR)pkt).rawPkt, 0, rawPkt, index, ((RtcpPktRR)pkt).rawPkt.length);
                index += ((RtcpPktRR)pkt).rawPkt.length;
                continue;
            }
            if (aPkt.packetType == 202) {
                pkt = (RtcpPktSDES)aPkt;
                ((RtcpPktSDES)pkt).encode();
                System.arraycopy(((RtcpPktSDES)pkt).rawPkt, 0, rawPkt, index, ((RtcpPktSDES)pkt).rawPkt.length);
                index += ((RtcpPktSDES)pkt).rawPkt.length;
                continue;
            }
            if (aPkt.packetType == 203) {
                pkt = (RtcpPktBYE)aPkt;
                ((RtcpPktBYE)pkt).encode();
                System.arraycopy(((RtcpPktBYE)pkt).rawPkt, 0, rawPkt, index, ((RtcpPktBYE)pkt).rawPkt.length);
                index += ((RtcpPktBYE)pkt).rawPkt.length;
                continue;
            }
            if (aPkt.packetType == 204) {
                pkt = (RtcpPktAPP)aPkt;
                ((RtcpPktAPP)pkt).encode();
                System.arraycopy(((RtcpPktAPP)pkt).rawPkt, 0, rawPkt, index, ((RtcpPktAPP)pkt).rawPkt.length);
                index += ((RtcpPktAPP)pkt).rawPkt.length;
                continue;
            }
            if (aPkt.packetType == 205) {
                pkt = (RtcpPktRTPFB)aPkt;
                ((RtcpPktRTPFB)pkt).encode();
                System.arraycopy(((RtcpPktRTPFB)pkt).rawPkt, 0, rawPkt, index, ((RtcpPktRTPFB)pkt).rawPkt.length);
                index += ((RtcpPktRTPFB)pkt).rawPkt.length;
                continue;
            }
            if (aPkt.packetType == 206) {
                pkt = (RtcpPktPSFB)aPkt;
                ((RtcpPktPSFB)pkt).encode();
                System.arraycopy(((RtcpPktPSFB)pkt).rawPkt, 0, rawPkt, index, ((RtcpPktPSFB)pkt).rawPkt.length);
                index += ((RtcpPktPSFB)pkt).rawPkt.length;
                continue;
            }
            System.out.println("CompRtcpPkt aPkt.packetType:" + aPkt.packetType);
        }
        byte[] output = new byte[index];
        System.arraycopy(rawPkt, 0, output, 0, index);
        return output;
    }
}

