/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.NSEC3Record;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.base16;

public class NSEC3PARAMRecord
extends Record {
    private static final long serialVersionUID = -8689038598776316533L;
    private int hashAlg;
    private int flags;
    private int iterations;
    private byte[] salt;

    NSEC3PARAMRecord() {
    }

    @Override
    Record getObject() {
        return new NSEC3PARAMRecord();
    }

    public NSEC3PARAMRecord(Name name, int n, long l, int n2, int n3, int n4, byte[] byArray) {
        super(name, 51, n, l);
        this.hashAlg = NSEC3PARAMRecord.checkU8("hashAlg", n2);
        this.flags = NSEC3PARAMRecord.checkU8("flags", n3);
        this.iterations = NSEC3PARAMRecord.checkU16("iterations", n4);
        if (byArray != null) {
            if (byArray.length > 255) {
                throw new IllegalArgumentException("Invalid salt length");
            }
            if (byArray.length > 0) {
                this.salt = new byte[byArray.length];
                System.arraycopy(byArray, 0, this.salt, 0, byArray.length);
            }
        }
    }

    @Override
    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.hashAlg = dNSInput.readU8();
        this.flags = dNSInput.readU8();
        this.iterations = dNSInput.readU16();
        int n = dNSInput.readU8();
        this.salt = (byte[])(n > 0 ? dNSInput.readByteArray(n) : null);
    }

    @Override
    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeU8(this.hashAlg);
        dNSOutput.writeU8(this.flags);
        dNSOutput.writeU16(this.iterations);
        if (this.salt != null) {
            dNSOutput.writeU8(this.salt.length);
            dNSOutput.writeByteArray(this.salt);
        } else {
            dNSOutput.writeU8(0);
        }
    }

    @Override
    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        this.hashAlg = tokenizer.getUInt8();
        this.flags = tokenizer.getUInt8();
        this.iterations = tokenizer.getUInt16();
        String string = tokenizer.getString();
        if (string.equals("-")) {
            this.salt = null;
        } else {
            tokenizer.unget();
            this.salt = tokenizer.getHexString();
            if (this.salt.length > 255) {
                throw tokenizer.exception("salt value too long");
            }
        }
    }

    @Override
    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.hashAlg);
        stringBuffer.append(' ');
        stringBuffer.append(this.flags);
        stringBuffer.append(' ');
        stringBuffer.append(this.iterations);
        stringBuffer.append(' ');
        if (this.salt == null) {
            stringBuffer.append('-');
        } else {
            stringBuffer.append(base16.toString(this.salt));
        }
        return stringBuffer.toString();
    }

    public int getHashAlgorithm() {
        return this.hashAlg;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getIterations() {
        return this.iterations;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] hashName(Name name) throws NoSuchAlgorithmException {
        return NSEC3Record.hashName(name, this.hashAlg, this.iterations, this.salt);
    }
}

