/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.security;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAKey;
import java.util.Date;
import org.xbill.DNS.DNSSEC;
import org.xbill.DNS.KEYRecord;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.SIGRecord;
import org.xbill.DNS.security.DSASignature;
import org.xbill.DNS.security.KEYConverter;

public class SIG0Signer {
    private static final short VALIDITY = 300;
    private int algorithm;
    private PrivateKey privateKey;
    private Name name;
    private int footprint;

    public SIG0Signer(int n, PrivateKey privateKey, Name name, int n2) {
        this.algorithm = (byte)n;
        this.privateKey = privateKey;
        this.name = name;
        this.footprint = n2;
    }

    public SIG0Signer(int n, PrivateKey privateKey, Name name, PublicKey publicKey) {
        this.algorithm = (byte)n;
        this.privateKey = privateKey;
        this.name = name;
        Record record = KEYConverter.buildRecord(name, 25, 1, 0L, 0, 255, n, publicKey);
        KEYRecord kEYRecord = (KEYRecord)record;
        this.footprint = kEYRecord.getFootprint();
    }

    public void apply(Message message, byte[] byArray) throws IOException, SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        Object object;
        String string;
        int n = Options.intValue("sig0validity");
        if (n < 0) {
            n = 300;
        }
        long l = System.currentTimeMillis();
        Date date = new Date(l);
        Date date2 = new Date(l + (long)(n * 1000));
        if (this.algorithm == 3) {
            string = "SHA1withDSA";
        } else if (this.algorithm == 1) {
            string = "MD5withRSA";
        } else if (this.algorithm == 5) {
            string = "SHA1withRSA";
        } else {
            throw new NoSuchAlgorithmException("Unknown algorithm");
        }
        SIGRecord sIGRecord = new SIGRecord(Name.root, 255, 0L, 0, this.algorithm, 0L, date2, date, this.footprint, this.name, null);
        byte[] byArray2 = DNSSEC.digestMessage(sIGRecord, message, byArray);
        Signature signature = Signature.getInstance(string);
        signature.initSign(this.privateKey);
        signature.update(byArray2);
        byte[] byArray3 = signature.sign();
        if (this.algorithm == 3) {
            object = (DSAKey)((Object)this.privateKey);
            byArray3 = DSASignature.toDNS(object.getParams(), byArray3);
        }
        object = new SIGRecord(Name.root, 255, 0L, 0, this.algorithm, 0L, date2, date, this.footprint, this.name, byArray3);
        message.addRecord((Record)object, 3);
    }
}

