package com.beem.project.beem.ui;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import com.beem.project.beem.BeemService;
import com.beem.project.beem.R;
import com.beem.project.beem.service.aidl.IXmppFacade;
import com.beem.project.beem.utils.Status;

public class ChangeStatus extends Activity {

    private TextView mStatusText;
    private Toast mToast;
    private Button mOk;
    private Button mClear;
    private Spinner mSpinner;
    
    private static final String[] STATUS = { "Available for chat", "Available", "Busy", "Away", "Unavailable",
	"Disconnected" };
    private static final int DISCONNECTED_IDX = 5;
    private static final int AVAILABLE_FOR_CHAT_IDX = 0;
    private static final int AVAILABLE_IDX = 1;
    private static final int BUSY_IDX = 2;
    private static final int AWAY_IDX = 3;
    private static final int UNAVAILABLE_IDX = 4;
    
    private SharedPreferences mSettings;
    private ArrayAdapter<String> mAdapter;
    private IXmppFacade xmppFacade = null;
    private final ServiceConnection mServConn = new BeemServiceConnection();
    private final OnClickListener mOnClickOk = new MyOnClickListener();

    private int getPreferenceStatusIndex() {
	return mSettings.getInt(getString(R.string.PreferenceStatus), 0);
    }

    private String getPreferenceString(int id) {
	return mSettings.getString(getString(id), "");
    }

    private int getStatusForService(String item) {
	int res = Status.CONTACT_STATUS_AVAILABLE;
	for (int i = 0; i < ChangeStatus.STATUS.length; i++) {
	    String str = ChangeStatus.STATUS[i];
	    if (str.equals(item)) {
		switch (i) {
		    case ChangeStatus.DISCONNECTED_IDX:
			return Status.CONTACT_STATUS_DISCONNECT;
		    case ChangeStatus.AVAILABLE_FOR_CHAT_IDX:
			return Status.CONTACT_STATUS_AVAILABLE_FOR_CHAT;
		    case ChangeStatus.AVAILABLE_IDX:
			return Status.CONTACT_STATUS_AVAILABLE;
		    case ChangeStatus.AWAY_IDX:
			return Status.CONTACT_STATUS_AWAY;
		    case ChangeStatus.BUSY_IDX:
			return Status.CONTACT_STATUS_BUSY;
		    case ChangeStatus.UNAVAILABLE_IDX:
			return Status.CONTACT_STATUS_UNAVAILABLE;
		    default:
			res = Status.CONTACT_STATUS_AVAILABLE;
			break;
		}
	    }
	}
	return res;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
	super.onCreate(savedInstanceState);

	setContentView(R.layout.changestatus);
	mStatusText = (TextView) findViewById(R.id.ChangeStatusText);
	mOk = (Button) findViewById(R.id.ChangeStatusOk);
	mClear = (Button) findViewById(R.id.ChangeStatusClear);
	mOk.setOnClickListener(mOnClickOk);
	mClear.setOnClickListener(mOnClickOk);
	mSettings = getSharedPreferences(getString(R.string.settings_filename), MODE_PRIVATE);

	mSpinner = (Spinner) findViewById(R.id.ChangeStatusSpinner);
	mAdapter = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, STATUS);
	mAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
	mSpinner.setAdapter(mAdapter);
	mToast = Toast.makeText(this, R.string.ChangeStatusOk, Toast.LENGTH_LONG);
	showSettings();
    }

    @Override
    protected void onDestroy() {
	super.onDestroy();
	unbindService(mServConn);
    }

    @Override
    protected void onResume() {
	super.onResume();
	bindService(new Intent(this, BeemService.class), mServConn, BIND_AUTO_CREATE);
    }

    private void showSettings() {
	mStatusText.setText(getPreferenceString(R.string.PreferenceStatusText));
	mSpinner.setSelection(getPreferenceStatusIndex());
    }

    private class BeemServiceConnection implements ServiceConnection {

	@Override
	public void onServiceConnected(ComponentName name, IBinder service) {
	    xmppFacade = IXmppFacade.Stub.asInterface(service);
	}

	@Override
	public void onServiceDisconnected(ComponentName name) {
	    xmppFacade = null;
	}
    }

    private class MyOnClickListener implements OnClickListener {

	@Override
	public void onClick(View v) {
	    if (v == mOk) {
		if (textHasChanged() || statusHasChanged()) {
		    String msg = mStatusText.getText().toString();
		    int status = getStatusForService((String) mSpinner.getSelectedItem());
		    Editor edit = mSettings.edit();
		    edit.putString(getString(R.string.PreferenceStatusText), msg);
		    edit.putInt(getString(R.string.PreferenceStatus), mSpinner.getSelectedItemPosition());
		    edit.commit();
		    if (status == Status.CONTACT_STATUS_DISCONNECT) {
			stopService(new Intent(ChangeStatus.this, BeemService.class));
		    } else {
			try {
			    xmppFacade.changeStatus(status, msg.toString());
			} catch (RemoteException e) {
			    // TODO
			    // Auto-generated
			    // catch block
			    e.printStackTrace();
			}
			mToast.show();
		    }
		}
		ChangeStatus.this.finish();
	    } else if (v == mClear) {
		mStatusText.setText(null);
	    }
	}
	private boolean statusHasChanged() {
	    return (mSettings.getInt(getString(R.string.PreferenceStatus), 0) != mSpinner.getSelectedItemPosition());
	}

	private boolean textHasChanged() {
	    return (!mStatusText.getText().toString().equals(getPreferenceString(R.string.PreferenceStatusText)));
	}
    }

}
