/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bytestream
extends IQ {
    private String sessionID;
    private Mode mode = Mode.tcp;
    private final List<StreamHost> streamHosts = new ArrayList<StreamHost>();
    private StreamHostUsed usedHost;
    private Activate toActivate;

    public Bytestream() {
    }

    public Bytestream(String SID) {
        this.setSessionID(SID);
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public StreamHost addStreamHost(String JID, String address) {
        return this.addStreamHost(JID, address, 0);
    }

    public StreamHost addStreamHost(String JID, String address, int port) {
        StreamHost host = new StreamHost(JID, address);
        host.setPort(port);
        this.addStreamHost(host);
        return host;
    }

    public void addStreamHost(StreamHost host) {
        this.streamHosts.add(host);
    }

    public Collection<StreamHost> getStreamHosts() {
        return Collections.unmodifiableCollection(this.streamHosts);
    }

    public StreamHost getStreamHost(String JID) {
        if (JID == null) {
            return null;
        }
        for (StreamHost host : this.streamHosts) {
            if (!host.getJID().equals(JID)) continue;
            return host;
        }
        return null;
    }

    public int countStreamHosts() {
        return this.streamHosts.size();
    }

    public void setUsedHost(String JID) {
        this.usedHost = new StreamHostUsed(JID);
    }

    public StreamHostUsed getUsedHost() {
        return this.usedHost;
    }

    public Activate getToActivate() {
        return this.toActivate;
    }

    public void setToActivate(String targetID) {
        this.toActivate = new Activate(targetID);
    }

    @Override
    public String getChildElementXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<query xmlns=\"http://jabber.org/protocol/bytestreams\"");
        if (this.getType().equals(IQ.Type.SET)) {
            if (this.getSessionID() != null) {
                buf.append(" sid=\"").append(this.getSessionID()).append("\"");
            }
            if (this.getMode() != null) {
                buf.append(" mode = \"").append((Object)this.getMode()).append("\"");
            }
            buf.append(">");
            if (this.getToActivate() == null) {
                for (StreamHost streamHost : this.getStreamHosts()) {
                    buf.append(streamHost.toXML());
                }
            } else {
                buf.append(this.getToActivate().toXML());
            }
        } else if (this.getType().equals(IQ.Type.RESULT)) {
            buf.append(">");
            if (this.getUsedHost() != null) {
                buf.append(this.getUsedHost().toXML());
            } else if (this.countStreamHosts() > 0) {
                for (StreamHost host : this.streamHosts) {
                    buf.append(host.toXML());
                }
            }
        } else {
            return null;
        }
        buf.append("</query>");
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        tcp,
        udp;


        public static Mode fromName(String name) {
            Mode mode;
            try {
                mode = Mode.valueOf(name);
            }
            catch (Exception ex) {
                mode = tcp;
            }
            return mode;
        }
    }

    public static class Activate
    implements PacketExtension {
        public String NAMESPACE = "";
        public static String ELEMENTNAME = "activate";
        private final String target;

        public Activate(String target) {
            this.target = target;
        }

        public String getTarget() {
            return this.target;
        }

        public String getNamespace() {
            return this.NAMESPACE;
        }

        public String getElementName() {
            return ELEMENTNAME;
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<").append(this.getElementName()).append(">");
            buf.append(this.getTarget());
            buf.append("</").append(this.getElementName()).append(">");
            return buf.toString();
        }
    }

    public static class StreamHostUsed
    implements PacketExtension {
        public String NAMESPACE = "";
        public static String ELEMENTNAME = "streamhost-used";
        private final String JID;

        public StreamHostUsed(String JID) {
            this.JID = JID;
        }

        public String getJID() {
            return this.JID;
        }

        public String getNamespace() {
            return this.NAMESPACE;
        }

        public String getElementName() {
            return ELEMENTNAME;
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<").append(this.getElementName()).append(" ");
            buf.append("jid=\"").append(this.getJID()).append("\" ");
            buf.append("/>");
            return buf.toString();
        }
    }

    public static class StreamHost
    implements PacketExtension {
        public static String NAMESPACE = "";
        public static String ELEMENTNAME = "streamhost";
        private final String JID;
        private final String addy;
        private int port = 0;

        public StreamHost(String JID, String address) {
            this.JID = JID;
            this.addy = address;
        }

        public String getJID() {
            return this.JID;
        }

        public String getAddress() {
            return this.addy;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public int getPort() {
            return this.port;
        }

        public String getNamespace() {
            return NAMESPACE;
        }

        public String getElementName() {
            return ELEMENTNAME;
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<").append(this.getElementName()).append(" ");
            buf.append("jid=\"").append(this.getJID()).append("\" ");
            buf.append("host=\"").append(this.getAddress()).append("\" ");
            if (this.getPort() != 0) {
                buf.append("port=\"").append(this.getPort()).append("\"");
            } else {
                buf.append("zeroconf=\"_jabber.bytestreams\"");
            }
            buf.append("/>");
            return buf.toString();
        }
    }
}

