/**
 *
 */
package com.beem.project.beem.jingle;

import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.media.JingleMediaSession;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;

/**
 * @author nikita
 */
public class RTPMediaSession extends JingleMediaSession {

    private RTPTransmitter mTransmitter;
    private RTPReceiver mReceiver;

    /**
     * @param payloadType
     * @param remote
     * @param local
     * @param mediaLocator
     * @param jingleSession
     */
    public RTPMediaSession(PayloadType payloadType, TransportCandidate remote, TransportCandidate local,
	String mediaLocator, JingleSession jingleSession) {
	super(payloadType, remote, local, mediaLocator, jingleSession);

	mTransmitter = new MicroRTPTransmitter(remote.getIp(), getRemote().getPort());
	mReceiver = new MicroRTPReceiver(getLocal().getPort());
    }

    @Override
    public void initialize() {
	// TODO Auto-generated method stub

    }

    @Override
    public void setTrasmit(boolean active) {
    }

    @Override
    public void startReceive() {

    }

    @Override
    public void startTrasmit() {

    }

    @Override
    public void stopReceive() {
	if (mReceiver != null) {
	    mReceiver.stop();
	}
    }

    @Override
    public void stopTrasmit() {
	if (mTransmitter != null) {
	    mTransmitter.stop();
	}
    }
}
