/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.javax.security.auth.login;

import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppConfigurationEntry {
    private final Map<String, ?> options;
    private final LoginModuleControlFlag controlFlag;
    private final String loginModuleName;

    public AppConfigurationEntry(String string, LoginModuleControlFlag loginModuleControlFlag, Map<String, ?> map) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("auth.26");
        }
        if (loginModuleControlFlag == null) {
            throw new IllegalArgumentException("auth.27");
        }
        if (map == null) {
            throw new IllegalArgumentException("auth.1A");
        }
        this.loginModuleName = string;
        this.controlFlag = loginModuleControlFlag;
        this.options = Collections.unmodifiableMap(map);
    }

    public String getLoginModuleName() {
        return this.loginModuleName;
    }

    public LoginModuleControlFlag getControlFlag() {
        return this.controlFlag;
    }

    public Map<String, ?> getOptions() {
        return this.options;
    }

    public static class LoginModuleControlFlag {
        private final String flag;
        public static final LoginModuleControlFlag REQUIRED = new LoginModuleControlFlag("LoginModuleControlFlag: required");
        public static final LoginModuleControlFlag REQUISITE = new LoginModuleControlFlag("LoginModuleControlFlag: requisite");
        public static final LoginModuleControlFlag OPTIONAL = new LoginModuleControlFlag("LoginModuleControlFlag: optional");
        public static final LoginModuleControlFlag SUFFICIENT = new LoginModuleControlFlag("LoginModuleControlFlag: sufficient");

        private LoginModuleControlFlag(String string) {
            this.flag = string;
        }

        public String toString() {
            return this.flag;
        }
    }
}

