/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrtp.jlibrtp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.util.Enumeration;
import java.util.Iterator;
import org.jlibrtp.jlibrtp.CompRtcpPkt;
import org.jlibrtp.jlibrtp.Participant;
import org.jlibrtp.jlibrtp.RTCPSession;
import org.jlibrtp.jlibrtp.RTPSession;
import org.jlibrtp.jlibrtp.RtcpPkt;
import org.jlibrtp.jlibrtp.RtcpPktAPP;
import org.jlibrtp.jlibrtp.RtcpPktBYE;
import org.jlibrtp.jlibrtp.RtcpPktRR;
import org.jlibrtp.jlibrtp.RtcpPktSDES;
import org.jlibrtp.jlibrtp.RtcpPktSR;
import org.jlibrtp.jlibrtp.StaticProcs;

public class RTCPReceiverThread
extends Thread {
    private RTPSession rtpSession = null;
    private RTCPSession rtcpSession = null;

    RTCPReceiverThread(RTCPSession rtcpSession, RTPSession rtpSession) {
        this.rtpSession = rtpSession;
        this.rtcpSession = rtcpSession;
    }

    private Participant findParticipant(long ssrc, DatagramPacket packet) {
        Participant p = this.rtpSession.partDb.getParticipant(ssrc);
        if (p == null) {
            Enumeration<Participant> enu = this.rtpSession.partDb.getParticipants();
            while (enu.hasMoreElements()) {
                Participant tmp = enu.nextElement();
                if (tmp.ssrc >= 0L || !tmp.rtcpAddress.getAddress().equals(packet.getAddress()) && !tmp.rtpAddress.getAddress().equals(packet.getAddress())) continue;
                System.out.println("RTCPReceiverThread: Got an unexpected packet from SSRC:" + ssrc + " @" + packet.getAddress().toString() + ", WAS able to match it.");
                tmp.ssrc = ssrc;
                return tmp;
            }
            System.out.println("RTCPReceiverThread: Got an unexpected packet from SSRC:" + ssrc + " @" + packet.getAddress().toString() + ", was NOT able to match it.");
            p = new Participant(null, (InetSocketAddress)packet.getSocketAddress(), ssrc);
            this.rtpSession.partDb.addParticipant(2, p);
        }
        return p;
    }

    private int parsePacket(DatagramPacket packet) {
        if (packet.getLength() % 4 != 0) {
            return -1;
        }
        byte[] rawPkt = packet.getData();
        CompRtcpPkt compPkt = new CompRtcpPkt(rawPkt, packet.getLength(), (InetSocketAddress)packet.getSocketAddress(), this.rtpSession);
        if (this.rtpSession.debugAppIntf != null) {
            String str;
            String intfStr = this.rtpSession.mcSession ? this.rtcpSession.rtcpMCSock.getLocalSocketAddress().toString() : this.rtpSession.rtpSock.getLocalSocketAddress().toString();
            if (compPkt.problem == 0) {
                str = new String("Received compound RTCP packet of size " + packet.getLength() + " from " + packet.getSocketAddress().toString() + " via " + intfStr + " containing " + compPkt.rtcpPkts.size() + " packets");
                this.rtpSession.debugAppIntf.packetReceived(1, (InetSocketAddress)packet.getSocketAddress(), str);
            } else {
                str = new String("Received invalid RTCP packet of size " + packet.getLength() + " from " + packet.getSocketAddress().toString() + " via " + intfStr + ": " + this.debugErrorString(compPkt.problem));
                this.rtpSession.debugAppIntf.packetReceived(-2, (InetSocketAddress)packet.getSocketAddress(), str);
            }
        }
        Iterator iter = compPkt.rtcpPkts.iterator();
        long curTime = System.currentTimeMillis();
        while (iter.hasNext()) {
            RtcpPkt aPkt = (RtcpPkt)iter.next();
            if (aPkt.ssrc == this.rtpSession.ssrc) {
                System.out.println("RTCPReceiverThread() received RTCP packet with conflicting SSRC from " + packet.getSocketAddress().toString());
                this.rtpSession.resolveSsrcConflict();
                return -1;
            }
            if (aPkt.getClass() == RtcpPktRR.class) {
                RtcpPktRR rrPkt = (RtcpPktRR)aPkt;
                Participant p = this.findParticipant(rrPkt.ssrc, packet);
                p.lastRtcpPkt = curTime;
                if (this.rtpSession.rtcpAppIntf == null) continue;
                this.rtpSession.rtcpAppIntf.RRPktReceived(rrPkt.ssrc, rrPkt.reporteeSsrc, rrPkt.lossFraction, rrPkt.lostPktCount, rrPkt.extHighSeqRecv, rrPkt.interArvJitter, rrPkt.timeStampLSR, rrPkt.delaySR);
                continue;
            }
            if (aPkt.getClass() == RtcpPktSR.class) {
                RtcpPktSR srPkt = (RtcpPktSR)aPkt;
                Participant p = this.findParticipant(srPkt.ssrc, packet);
                p.lastRtcpPkt = curTime;
                if (p != null) {
                    if (p.ntpGradient < 0.0 && p.lastNtpTs1 > -1L) {
                        long newTime = StaticProcs.undoNtpMess(srPkt.ntpTs1, srPkt.ntpTs2);
                        p.ntpGradient = (double)(newTime - p.ntpOffset) / ((double)srPkt.rtpTs - (double)p.lastSRRtpTs);
                    } else {
                        p.ntpOffset = StaticProcs.undoNtpMess(srPkt.ntpTs1, srPkt.ntpTs2);
                        p.lastNtpTs1 = srPkt.ntpTs1;
                        p.lastNtpTs2 = srPkt.ntpTs2;
                        p.lastSRRtpTs = srPkt.rtpTs;
                    }
                    p.timeReceivedLSR = curTime;
                    p.setTimeStampLSR(srPkt.ntpTs1, srPkt.ntpTs2);
                }
                if (this.rtpSession.rtcpAppIntf == null) continue;
                if (srPkt.rReports != null) {
                    this.rtpSession.rtcpAppIntf.SRPktReceived(srPkt.ssrc, srPkt.ntpTs1, srPkt.ntpTs2, srPkt.rtpTs, srPkt.sendersPktCount, srPkt.sendersPktCount, srPkt.rReports.reporteeSsrc, srPkt.rReports.lossFraction, srPkt.rReports.lostPktCount, srPkt.rReports.extHighSeqRecv, srPkt.rReports.interArvJitter, srPkt.rReports.timeStampLSR, srPkt.rReports.delaySR);
                    continue;
                }
                this.rtpSession.rtcpAppIntf.SRPktReceived(srPkt.ssrc, srPkt.ntpTs1, srPkt.ntpTs2, srPkt.rtpTs, srPkt.sendersPktCount, srPkt.sendersPktCount, null, null, null, null, null, null, null);
                continue;
            }
            if (aPkt.getClass() == RtcpPktSDES.class) {
                RtcpPktSDES sdesPkt = (RtcpPktSDES)aPkt;
                if (this.rtpSession.rtcpAppIntf == null) continue;
                this.rtpSession.rtcpAppIntf.SDESPktReceived(sdesPkt.participants);
                continue;
            }
            if (aPkt.getClass() == RtcpPktBYE.class) {
                RtcpPktBYE byePkt = (RtcpPktBYE)aPkt;
                long time = System.currentTimeMillis();
                Participant[] partArray = new Participant[byePkt.ssrcArray.length];
                int i = 0;
                while (i < byePkt.ssrcArray.length) {
                    partArray[i] = this.rtpSession.partDb.getParticipant(byePkt.ssrcArray[i]);
                    if (partArray[i] != null) {
                        partArray[i].timestampBYE = time;
                    }
                    ++i;
                }
                if (this.rtpSession.rtcpAppIntf == null) continue;
                this.rtpSession.rtcpAppIntf.BYEPktReceived(partArray, new String(byePkt.reason));
                continue;
            }
            if (aPkt.getClass() != RtcpPktAPP.class) continue;
            RtcpPktAPP appPkt = (RtcpPktAPP)aPkt;
            Participant part = this.findParticipant(appPkt.ssrc, packet);
            if (this.rtpSession.rtcpAppIntf == null) continue;
            this.rtpSession.rtcpAppIntf.APPPktReceived(part, appPkt.itemCount, appPkt.pktName, appPkt.pktData);
        }
        return 0;
    }

    private String debugErrorString(int errorCode) {
        String aStr = "";
        switch (errorCode) {
            case -1: {
                aStr = "The first packet was not of type SR or RR.";
                break;
            }
            case -2: {
                aStr = "The padding bit was set for the first packet.";
                break;
            }
            case -200: {
                aStr = " Error parsing Sender Report packet.";
                break;
            }
            case -201: {
                aStr = " Error parsing Receiver Report packet.";
                break;
            }
            case -202: {
                aStr = " Error parsing SDES packet";
                break;
            }
            case -203: {
                aStr = " Error parsing BYE packet.";
                break;
            }
            case -204: {
                aStr = " Error parsing Application specific packet.";
                break;
            }
            case -205: {
                aStr = " Error parsing RTP Feedback packet.";
                break;
            }
            case -206: {
                aStr = " Error parsing Payload-Specific Feedback packet.";
                break;
            }
            default: {
                aStr = "Unknown error code " + errorCode + ".";
            }
        }
        return aStr;
    }

    @Override
    public void run() {
        while (!this.rtpSession.endSession) {
            byte[] rawPkt = new byte[1500];
            DatagramPacket packet = new DatagramPacket(rawPkt, rawPkt.length);
            if (!this.rtpSession.mcSession) {
                try {
                    this.rtcpSession.rtcpSock.receive(packet);
                }
                catch (IOException e) {
                    if (this.rtpSession.endSession) continue;
                    e.printStackTrace();
                }
            } else {
                try {
                    this.rtcpSession.rtcpMCSock.receive(packet);
                }
                catch (IOException e) {
                    if (this.rtpSession.endSession) continue;
                    e.printStackTrace();
                }
            }
            if ((!this.rtpSession.mcSession || packet.getSocketAddress().equals(this.rtcpSession.rtcpMCSock)) && packet.getSocketAddress().equals(this.rtcpSession.rtcpSock)) continue;
            this.parsePacket(packet);
        }
    }
}

